

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0



#line 15 "double.d"
#include <math.h> 

#define	CLASS	DoubleFloat_c
#define	ivType	DoubleFloat_iv_t

#include "generics.h"

object	DoubleFloat_c;


#line 28 "double.c"
typedef struct  _DoubleFloat_iv_t  {
	double iVal;
}	DoubleFloat_iv_t;



#line 25 "double.d"
cmeth objrtn DoubleFloat_cm_gNewWithDouble(object self, double val)
{ 
	object obj = oSuper(DoubleFloat_c, gNew, self)(self); 
	ivType *iv = ivPtr(obj); 
	iv->iVal = val; 
	return(obj); 
} 

imeth objrtn DoubleFloat_im_gStringRepValue(object self)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	return vSprintf(String, "%f", iv->iVal); 
} 

imeth char DoubleFloat_im_gCharValue(object self)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	return (char) iv->iVal; 
} 

imeth short DoubleFloat_im_gShortValue(object self)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	return (short) iv->iVal; 
} 

imeth unsigned short DoubleFloat_im_gUnsignedShortValue(object self)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	return (unsigned short) iv->iVal; 
} 

imeth long DoubleFloat_im_gLongValue(object self)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	return (long) iv->iVal; 
} 

imeth double DoubleFloat_im_gDoubleValue(object self)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	return (double) iv->iVal; 
} 

imeth void * DoubleFloat_im_gPointerValue(object self)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	return (void *) &iv->iVal; 
} 

imeth objrtn DoubleFloat_im_gChangeValue(object self, object val)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	ChkArg(val, 2); 
	iv->iVal = gDoubleValue(val); 
	return self; 
} 

imeth objrtn DoubleFloat_im_gChangeCharValue(object self, int val)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	iv->iVal = (double) val; 
	return self; 
} 

imeth objrtn DoubleFloat_im_gChangeShortValue(object self, int val)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	iv->iVal = (double) val; 
	return self; 
} 

imeth objrtn DoubleFloat_im_gChangeUShortValue(object self, unsigned val)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	iv->iVal = (double) val; 
	return self; 
} 

imeth objrtn DoubleFloat_im_gChangeLongValue(object self, long val)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	iv->iVal = (double) val; 
	return self; 
} 

imeth objrtn DoubleFloat_im_gChangeDoubleValue(object self, double val)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	iv->iVal = (double) val; 
	return self; 
} 

imeth objrtn DoubleFloat_im_gRound(object self, int p)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	double r; 

	r = pow(10.0, (double) p); 
	if (iv->iVal < 0.0) 
		iv->iVal = -(floor(.5 + -iv->iVal * r) / r); 
	else 
		iv->iVal = floor(.5 + iv->iVal * r) / r; 
	return self; 
} 

imeth objrtn DoubleFloat_im_gTruncate(object self, int p)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	double r; 

	r = pow(10.0, (double) p); 
	if (iv->iVal < 0.0) 
		iv->iVal = -(floor(-iv->iVal * r) / r); 
	else 
		iv->iVal = floor(iv->iVal * r) / r; 
	return self; 
} 

imeth int DoubleFloat_im_gHash(object self)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	double t; 

	t = .6125423371 * iv->iVal; 
	t = t < 0.0 ? -t : t; 
	return (int) (BIG_INT * (t - floor(t))); 
} 

imeth int DoubleFloat_im_gCompare(object self, object obj)
{ DoubleFloat_iv_t *iv = GetIVs(DoubleFloat, self);
	double sv, ov; 

	ChkArg(obj, 2); 
	if (ClassOf(obj) != CLASS) 
		return oSuper(DoubleFloat_c, gCompare, self)(self, obj); 
	if ((sv=iv->iVal) < (ov=ivPtr(obj)->iVal)) 
		return -1; 
	else if (sv == ov) 
		return 0; 
	else 
		return 1; 
} 


#line 165 "double.c"

objrtn	DoubleFloat_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (DoubleFloat_c) {
		LEAVECRITICALSECTION(cs);
		return DoubleFloat_c;
	}
	INHIBIT_THREADER;
	Number_initialize();
	if (DoubleFloat_c)  {
		ENABLE_THREADER;
		LEAVECRITICALSECTION(cs);
		return DoubleFloat_c;
	}
	DoubleFloat_c = gNewClass(Class, "DoubleFloat", sizeof(DoubleFloat_iv_t), 0, Number, END);
	cMethodFor(DoubleFloat, gNewWithDouble, DoubleFloat_cm_gNewWithDouble);
	iMethodFor(DoubleFloat, gTruncate, DoubleFloat_im_gTruncate);
	iMethodFor(DoubleFloat, gRound, DoubleFloat_im_gRound);
	iMethodFor(DoubleFloat, gUnsignedShortValue, DoubleFloat_im_gUnsignedShortValue);
	iMethodFor(DoubleFloat, gChangeDoubleValue, DoubleFloat_im_gChangeDoubleValue);
	iMethodFor(DoubleFloat, gDoubleValue, DoubleFloat_im_gDoubleValue);
	iMethodFor(DoubleFloat, gCompare, DoubleFloat_im_gCompare);
	iMethodFor(DoubleFloat, gChangeLongValue, DoubleFloat_im_gChangeLongValue);
	iMethodFor(DoubleFloat, gChangeShortValue, DoubleFloat_im_gChangeShortValue);
	iMethodFor(DoubleFloat, gShortValue, DoubleFloat_im_gShortValue);
	iMethodFor(DoubleFloat, gPointerValue, DoubleFloat_im_gPointerValue);
	iMethodFor(DoubleFloat, gCharValue, DoubleFloat_im_gCharValue);
	iMethodFor(DoubleFloat, gStringRepValue, DoubleFloat_im_gStringRepValue);
	iMethodFor(DoubleFloat, gChangeUShortValue, DoubleFloat_im_gChangeUShortValue);
	iMethodFor(DoubleFloat, gHash, DoubleFloat_im_gHash);
	iMethodFor(DoubleFloat, gChangeValue, DoubleFloat_im_gChangeValue);
	iMethodFor(DoubleFloat, gLongValue, DoubleFloat_im_gLongValue);
	iMethodFor(DoubleFloat, gChangeCharValue, DoubleFloat_im_gChangeCharValue);

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return DoubleFloat_c;
}



