

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0



#line 15 "date.d"
#include <string.h> 
#include <math.h> 
#include <time.h> 

#define	CLASS	Date_c
#define	ivType	Date_iv_t

#include "generics.h"

object	Date_c;


#line 26 "date.d"
static gLongValue_t longValue; 
static gChangeLongValue_t changeLongValue; 


static char *Dtfmt(long d, char *s) 
{ 
	int i; 
	char v[7]; 

	s[8] = '\0'; 

#line 44 "date.d"
	if (d < 101L) { 
		for (i=0 ; i != 8 ; ) 
			s[i++] = ' '; 
		return(s); 
	} 
	d %= 1000000L; 
	sprintf(v, "%6ld", d); 
	s[0] = v[2] == '0' ? ' ' : v[2]; 
	s[1] = v[3]; 
	s[2] = '/'; 
	s[3] = v[4]; 
	s[4] = v[5]; 
	s[5] = '/'; 
	s[6] = v[0] == ' ' ? '0' : v[0]; 
	s[7] = v[1] == ' ' ? '0' : v[1]; 
	return(s); 
} 

#if 0 

static char *Dtfmt4(long d, char *s) 
{ 
	int i; 
	char v[9]; 

	if (d <= 0L || d > 99991231L) { 
		for (i=0 ; i != 10 ; ) 
			s[i++] = ' '; 
		s[i] = '\0'; 
		return(s); 
	} 
	sprintf(v, "%8ld", d); 
	s[0] = (v[4] == '0') ? ' ' : v[4]; 
	s[1] = v[5]; 
	s[2] = '/'; 
	s[3] = v[6]; 
	s[4] = v[7]; 
	s[5] = '/'; 
	s[6] = v[0]; 
	s[7] = v[1]; 
	s[8] = v[2]; 
	s[9] = v[3]; 
	s[10] = '\0'; 
	return(s); 
} 

#endif 

static long Jul(long x) 
{ 
	long d, y; 
	long m; 

	if (x <= 0L) return(x); 
	y = x / 10000L; 
	m = (x % 10000L) / 100L; 
	d = x % 100L; 
	d += (long) (.5 + (m - 1L) * 30.57); 
	if (m > 2L) { 
		d--; 




		if (0L != y % 400L && 0L != y % 4L) 
			d--; 
		else if (0L != y % 400L && 0L == y % 100L) 
			d--; 
	} 
	d += (long) (365.25 * --y); 
	d += y / 400L; 
	d -= y / 100L; 
	return(d); 
} 

static long Cal(long d) 
{ 
	long y, m, t; 

	if (d <= 0L) return(d); 
	y = (long)(1.0 + d / 365.2425); 
	t = y - 1L; 
	d -= (long) (t * 365.25); 
	d -= t / 400L; 
	d += t / 100L; 
	if (d > 59L && 0L != y % 400L && (0L != y % 4 || 0L == y % 100L)) 
		d++; 
	if (d > 60L) 
		d++; 
	m = (long)((d + 30L) / 30.57); 
	d -= (long) floor(.5 + (m - 1L) * 30.57); 
	if (m == 13) { 
		m = 1; 
		++y; 
	} else if (!m) { 
		m = 12; 
		--y; 
	} 
	return 10000L * y + m * 100L + d; 
} 

static char *Dyofwk(long d, char *s) 
{ 
	int i; 
	char *p; 

	if (d <= 0L) 
		if (s) { 
		*s = '\0'; 
		return(s); 
	} else 
		return(""); 
	i = Jul(d) % 7L; 
	switch (i) { 
		case 0: p = "Sunday"; break; 
		case 1: p = "Monday"; break; 
		case 2: p = "Tuesday"; break; 
		case 3: p = "Wednesday"; break; 
		case 4: p = "Thursday"; break; 
		case 5: p = "Friday"; break; 
		case 6: p = "Saturday"; break; 
		default: p = ""; break; 
	} 
	if (s) { 
		strcpy(s, p); 
		return(s); 
	} else 
		return(p); 
} 

static char *Mmofyr(int m, char *s) 
{ 
	char *p; 

	if (m <= 0) 
		if (s) { 
		*s = '\0'; 
		return(s); 
	} else 
		return(""); 
	m = (m - 1) % 12; 
	switch (m) { 
		case 0: p = "January"; break; 
		case 1: p = "February"; break; 
		case 2: p = "March"; break; 
		case 3: p = "April"; break; 
		case 4: p = "May"; break; 
		case 5: p = "June"; break; 
		case 6: p = "July"; break; 
		case 7: p = "August"; break; 
		case 8: p = "September"; break; 
		case 9: p = "October"; break; 
		case 10: p = "November"; break; 
		case 11: p = "December"; break; 
		default: p = ""; break; 
	} 
	if (s) { 
		strcpy(s, p); 
		return(s); 
	} else 
		return(p); 
} 

static short *Timemark(short int *v) 
{ 
	struct tm *a; 




	time_t t; 

	time(&t); 
	a = localtime(&t); 
	v[0] = a->tm_year + 1900; 
	v[1] = a->tm_mon + 1; 
	v[2] = a->tm_mday; 
	v[3] = a->tm_hour; 
	v[4] = a->tm_min; 
	v[5] = a->tm_sec; 
	v[6] = 0; 
	return v; 
} 

static long _Today(void) 
{ 
	short v[7]; 

	Timemark(v); 
	return 10000L * (long) v[0] + 100L * (long) v[1] + (long) v[2]; 
} 

static long Date_ymd(long date, int *year, int *month, int *day) 
{ 
	register int temp; 

	temp = (int) (date % 10000L); 

	if (year) *year = (int) (date / 10000L); 
	if (month) *month = temp / 100; 
	if (day) *day = temp % 100; 
	return(date); 
} 

static long Ymd_date(int year, int month, int day) 
{ 
	return((long) year * 10000L + (long) month * 100L + (long) day); 
} 

static char *Num_sufx(int d) 
{ 
	register int i = d % 10; 

	if (i == 1 && d != 11) 
		return "st"; 
	else if (i == 2 && d != 12) 
		return "nd"; 
	else if (i == 3 && d != 13) 
		return "rd"; 
	else return "th"; 
} 

static char *Time2(char *buf) 
{ 
	short v[7], t=0; 

	Timemark(v); 
	if (v[3] >= 12) { 
		t = 1; 
		if (v[3] > 12) v[3] -= 12; 
	} 
	sprintf(buf, "%2d:%2d %s", 
		(int) v[3], (int) v[4], t ? "PM" : "AM"); 
	if (buf[3] == ' ') 
		buf[3] = '0'; 
	return(buf); 
} 

static char *DateFmt(char *buf, long dt, char *msk) 
{ 
	int y, m, d; 
	char tmp[20], *bp = buf; 

	if (dt <= 0L) { 
		*buf = '\0'; 
		return(buf); 
	} 
	Date_ymd(dt, &y, &m, &d); 
	while (*msk) 
		if (*msk != '%') 
		*bp++ = *msk++; 
	else 
		switch (*++msk) { 
		case '\0': 
		break; 
		case '%': 
		default: 
		*bp++ = *msk++; 
		break; 
		case 'W': 
		case 'w': 
		strcpy(bp, Dyofwk(dt, NULL)); 
		bp += strlen(bp); 
		msk++; 
		break; 
		case 'M': 
		strcpy(bp, Mmofyr(m, NULL)); 
		bp += strlen(bp); 
		msk++; 
		break; 
		case 'm': 
		strcpy(bp, Mmofyr(m, NULL)); 
		bp += 3; 
		msk++; 
		break; 
		case 'd': 
		sprintf(bp, "%d", d); 
		bp += strlen(bp); 
		msk++; 
		break; 
		case 'D': 
		sprintf(bp, "%2d", d); 
		for ( ; *bp ; ++bp) 
			if (*bp == ' ') 
			*bp = '0'; 
		msk++; 
		break; 
		case 'y': 
		sprintf(bp, "%2d", y%100); 
		for ( ; *bp ; ++bp) 
			if (*bp == ' ') 
			*bp = '0'; 
		msk++; 
		break; 
		case 'Y': 
		sprintf(bp, "%4d", y); 
		bp += strlen(bp); 
		msk++; 
		break; 
		case 'S': 
		case 's': 
		strcpy(bp, Num_sufx(d)); 
		bp += strlen(bp); 
		msk++; 
		break; 
		case 'n': 
		sprintf(bp, "%d", m); 
		bp += strlen(bp); 
		msk++; 
		break; 
		case 'N': 
		sprintf(bp, "%2d", m); 
		bp += strlen(bp); 
		msk++; 
		break; 
		case 'T': 
		case 't': 
		strcpy(bp, Time2(tmp)); 
		bp += strlen(bp); 
		msk++; 
		break; 
	} 
	*bp = '\0'; 
	return(buf); 
} 

static long Add_days(long date, long days) 
{ 
	if (date <= 0L) return(0L); 
	return Cal(days + Jul(date)); 
} 

static long Add_mon(long date, int months) 
{ 
	int y, m, d; 
	long mon; 

	if (date <= 0L) return(0L); 
	Date_ymd(date, &y, &m, &d); 
	mon = 12L * (long) y + (long) m + (long) months - 1L; 
	y = mon / 12L; 
	m = 1L + mon % 12L; 
	date = Ymd_date(y, m, d); 
	return(date); 
} 

static long Add_year(long date, int years) 
{ 
	int y, m, d; 

	if (date <= 0L) return(0L); 
	Date_ymd(date, &y, &m, &d); 
	y += years; 
	date = Ymd_date(y, m, d); 
	return(date); 
} 

static int Valid_date(long d) 
{ 
	return d == Cal(Jul(d)); 
} 

static long Date_dif(long d1, long d2) 
{ 
	return Jul(d1) - Jul(d2); 
} 

imeth objrtn Date_im_gDayName(object self)
{ 
	return gNewWithStr(String, Dyofwk(longValue(self), NULL)); 
} 

imeth objrtn Date_im_gMonthName(object self)
{ 
	int m; 
	Date_ymd(longValue(self), NULL, &m, NULL); 
	return gNewWithStr(String, Mmofyr(m, NULL)); 
} 

imeth objrtn Date_im_gFormatDate(object self, char *msk)
{ 
	char buf[80]; 

	return gNewWithStr(String, DateFmt(buf, longValue(self), msk)); 
} 

imeth objrtn Date_im_gStringRepValue(object self)
{ 
	char buf[15]; 

	return gNewWithStr(String, Dtfmt(gLongValue(self), buf)); 
} 

cmeth objrtn Date_cm_gToday(object self)
{ 
	return gNewWithLong(self, _Today()); 
} 

imeth objrtn Date_im_gAddDays(object self, long days)
{ 
	return changeLongValue(self, Add_days(longValue(self), days)); 
} 

imeth objrtn Date_im_gAddMonths(object self, int months)
{ 
	return changeLongValue(self, Add_mon(longValue(self), months)); 
} 

imeth objrtn Date_im_gAddYears(object self, int years)
{ 
	return changeLongValue(self, Add_year(longValue(self), years)); 
} 

imeth int Date_im_gValidDate(object self)
{ 
	return Valid_date(longValue(self)); 
} 

imeth long Date_im_gDifference(object self, object dt)
{ 
	ChkArgTyp(dt, 2, Date); 
	return Date_dif(longValue(self), longValue(dt)); 
} 

cmeth long Date_cm_gCalToJul(object self, long dt)
{ 
	return Jul(dt); 
} 

cmeth long Date_cm_gJulToCal(object self, long dt)
{ 
	return Cal(dt); 
} 

imeth long Date_im_gJulian(object self)
{ 
	return Jul(longValue(self)); 
} 

static void init_class(void) 
{ 
	longValue = imcPointer(CLASS, gLongValue); 
	changeLongValue = imcPointer(CLASS, gChangeLongValue); 
} 

#line 488 "date.c"

objrtn	Date_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (Date_c) {
		LEAVECRITICALSECTION(cs);
		return Date_c;
	}
	INHIBIT_THREADER;
	LongInteger_initialize();
	if (Date_c)  {
		ENABLE_THREADER;
		LEAVECRITICALSECTION(cs);
		return Date_c;
	}
	Date_c = gNewClass(Class, "Date", 0, 0, LongInteger, END);
	cMethodFor(Date, gCalToJul, Date_cm_gCalToJul);
	cMethodFor(Date, gToday, Date_cm_gToday);
	cMethodFor(Date, gJulToCal, Date_cm_gJulToCal);
	iMethodFor(Date, gJulian, Date_im_gJulian);
	iMethodFor(Date, gAddYears, Date_im_gAddYears);
	iMethodFor(Date, gMonthName, Date_im_gMonthName);
	iMethodFor(Date, gDayName, Date_im_gDayName);
	iMethodFor(Date, gFormatDate, Date_im_gFormatDate);
	iMethodFor(Date, gAddMonths, Date_im_gAddMonths);
	iMethodFor(Date, gDifference, Date_im_gDifference);
	iMethodFor(Date, gAddDays, Date_im_gAddDays);
	iMethodFor(Date, gStringRepValue, Date_im_gStringRepValue);
	iMethodFor(Date, gValidDate, Date_im_gValidDate);

	init_class();

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return Date_c;
}



