// File: SampledImage.h
//
// (c) 1996 Mayur Patel
//

#ifndef SampledImage_CLASS
#define SampledImage_CLASS

#include <InputImage.h>

#include <ImageMan.h>
#include <FillStrategy.h>

// *******************************************************************
// CLASS: SampledImage
// DESCRIPTION:
//    Serves as the base class for images with finite range and
//    resolution.
//
class SampledImage : public InputImage {
   public:
   
      //
      // description:
      //    sets a strategy for validating out-of-range data
      //
      void
      setFillStrategy( FillStrategy *pStrategy );
      
      //
      // description:
      //    allocates and returns a new tile containing image data
      // post:
      //    returns null on error
      //
      ImageTile *
      newTile( const ImageArea& area );
      
      //
      // description:
      //    returns the dimensions of this image
      //
      const ImageArea&
      getArea( void ) const
      { return( _area ); }
      
      
   protected:         
      SampledImage( void );
      ~SampledImage( void );
   
      void
      setArea( const ImageArea& setArea );
      
      FillStrategy *
      getFillStrategy ( void )
      { return ( _pFiller ); }
      
      int
      applyFillStrategy( ImageTile *pWriteHere );

      ImageMan *
      getManPointer( void )
      { return ( _manager.getPointer() ); }
      
   private:   
      ImageArea		_area;
      FillStrategy	*_pFiller;
      ManReference	_manager;   
};

#endif

