// File: InputImage.h
//
// (c) 1996 Mayur Patel

#ifndef InputImage_CLASS
#define InputImage_CLASS

#include <Referenced.h>
#include <Type.h>
#include <ImageTile.h>

// *******************************************************************
// CLASS: InputImage
// DESCRIPTION:
//    Abstract base class for images
// NOTES:
// 1) Two techniques for requesting tiles.
//    One goes through the cache. (high-level)
//    One by-passes the cache. (low-level)
// 2) Default Image type is 16 bits, but is easily overridden.
// 3) protected member _mtType might change (Ex: SGI image: 8b or 16b)
//
class InputImage : public Referenced {
   public:   
      virtual ImageTile *
      newTile( const ImageArea & area );

      //
      // pre: pWriteHere->getType() must match image type
      // post: returns a non-zero on error.
      //
      virtual int
      fillTile( ImageTile *pWriteHere ) = 0;

      Type
      getType( void ) const
      { return (_mtType ); }
      
   protected:
      InputImage( Type setType=UShort ) { _mtType = setType; }
      
      void
      setType( Type setType ) { _mtType = setType; }

   private:
      Type		_mtType;
};

#endif
