// File: ImageTile.h
//
// (c) 1996 Mayur Patel

#ifndef ImageTile_CLASS
#define ImageTile_CLASS

#include <Type.h>
#include <Referenced.h>
#include <BinaryBuffer.h>
#include <ImageArea.h>

class ImageTile : public Referenced {
   public:              
      ImageTile( const ImageArea& setArea, Type setType=UShort );
      ImageTile( const ImageTile& source );
      
      ~ImageTile( void ) { }
      
      //
      // post: returns the size, in bytes, of the tile buffer.
      //
      unsigned
      getRAMSize( void ) const
      { return( _maArea.width*_maArea.height*bytesize( _mtType ));}
            
      Type
      getType( void ) const
      { return ( _mtType ); }
      
      const ImageArea&
      getArea( void ) const
      { return ( _maArea ); }
      
      //
      // post: resizes the internal buffer & sets new data type
      // post: destroys current contents
      // note: use typecast() for a version to preserve contents.
      //
      int
      alloc( const ImageArea& setArea, Type setType);
      
      void *
      getBufferAt( signed iColumn, signed iRow ) const;
      
      //
      // post: returns a pointer to the data buffer
      // note: this allows fast iteration over buffer contents
      // note: be sure to confirm type of data with getType()
      //
      const void *
      getBuffer(void) const { return ( _buffer.getBuffer() ); }      
      void *
      getBuffer( void ) { return ( _buffer.getBuffer() ); }
      
      //
      // pre: (*this) was acquired by a C++ new operation
      //    or a ??::newTile() method
      // post: dereferenced a smart pointer.
      // note: It is important to use this to avoid memory leaks!!
      // 
      void
      deleteTile( void ) {Referenced::unregisterReference();}

      //
      // post: resizes the internal buffer & sets new data type
      // post: typecasted current contents as well
      // note: use alloc() for a fast version that destroys contents.
      //
      int
      typecast( Type type );
      
   protected:
      ImageArea	_maArea;
      Type		_mtType;
      
      BinaryBuffer	_buffer;
};

#endif

