// File: ImageTile.C
//
// (c) 1996 Mayur Patel

#include <ImageTile.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>

ImageTile::ImageTile( const ImageTile& source )
{
   _maArea = source.getArea();   
   _mtType = source.getType();
   if ( !(alloc( _maArea, _mtType )))
      memcpy( getBuffer(), source.getBuffer(), source.getRAMSize() );
   
   return;
}


ImageTile::ImageTile( const ImageArea& setArea, Type setType )
{   
   alloc( setArea, setType );
   return;
}


int
ImageTile::alloc( const ImageArea& setArea, Type setType )
{
   int iRet;
   
   iRet = 0;
      
   _maArea = setArea;
   _mtType = setType;
   if ( !(_buffer.useBytes( getRAMSize(), 0 )) )
   {
      _maArea.width = 0;
      _maArea.height = 0;
      iRet = -1;
   }
            
   return ( iRet );
}

//
// returns NULL on error.
//
void *
ImageTile::getBufferAt( signed iColumn, signed iRow ) const
{
   unsigned char *	cpBuffer = 0;
   unsigned 		uIndex = 0;
   
   if (( iColumn >= _maArea.x ) && 
      ((iColumn - _maArea.x )< _maArea.width ))
   {
      uIndex = iColumn - _maArea.x;
   
      if ((iRow >= _maArea.y ) && 
         ((iRow - _maArea.y)<_maArea.height ))
      {
	 uIndex += _maArea.width * ( iRow - _maArea.y );
	 
	 cpBuffer = (unsigned char *) getBuffer();
	 cpBuffer += bytesize( _mtType ) * uIndex;
      }
   }
   
   return ( (void *) cpBuffer );
}

int
ImageTile::typecast( Type setType )
{
   int 			iRet;
   BinaryBuffer		tempBuffer;
   unsigned long 	ulLoop;

   iRet = 0;
   
   if ( _mtType != setType )
   {
      if ( tempBuffer.useBytes( getRAMSize(), 0 ) )
      {
         memcpy( tempBuffer.getBuffer(), getBuffer(), getRAMSize() );
         
         if ( _buffer.useBytes(  
            _maArea.width * _maArea.height * bytesize(setType), 0 ) )
         {
            ulLoop = _maArea.width * _maArea.height;
            switch( setType )
            {
#define TYPEMACRO( label, type, low, high, prec, func ) \
               case( label ): \
               func ( ulLoop, ( type * ) getBuffer(), \
                     tempBuffer.getBuffer(),_mtType); \
               break;
#include <Type.m>
               default:
                  iRet = -1;
                  break;
            };

	    _mtType = setType;

	 } else
            iRet = -1;
      } else
         iRet = -1;
   }
         
   return ( iRet );
}

