// File: ImageMan.h
//
// (c) 1996 Mayur Patel

#ifndef ImageMan_CLASS
#define ImageMan_CLASS

#include <ImageTile.h>

class ImageMan;
class ManReference {
   public:
      ManReference( void );
      ~ManReference( void );
      
      ImageMan *
      getPointer( void ) { return( _pManager ); }
      
      ImageMan *
      operator->( void ) { return ( _pManager ); }
      
   protected:
     static ImageMan *	_pManager;
     static unsigned		_uReferences;   
};


class SampledImage;
class ImageMan {
   public:      
      //
      // uses SampledImage::fillTile( ImageTile *pWriteHere );
      // may calculate & cache more data area than requested.
      //
      virtual ImageTile *
      newTile ( SampledImage *pCaller, const ImageArea& area );
      
   protected:
      ImageMan( void ) { }

      virtual
      ~ImageMan( void );
      
      friend class ManReference;    
};

#endif
