#ifndef TRI3D_H
#define TRI3D_H

#include "WinDOS.h"
#include "Vector3D.h"

enum {
	TRI_FIXED = 0,
	TRI_MOVEABLE = 1,
	TRI_LEFTHAND = 2 // right is default (QD3D, Renderware etc; D3D is left handed)
};

class Tri3D {
public:
	static float light_res;
	int 		vi1, vi2, vi3; 				// vertex indices
	Uv 			uv1, uv2, uv3;				// texture coords
	Rgb			rgb1, rgb2, rgb3;			// vertex gouraud values
	long		userData;
	
	// Viewport-clipped values
	Uv 			clip_uv1, clip_uv2, clip_uv3;				
	Rgb			clip_rgb1, clip_rgb2, clip_rgb3;			

	float		r, g, b;					// base values
	int 		texmap; 					// index into renderer-specific texture map
	int			type; 						// fixed, moveable etc for dynamic or static lighting
	Vector3D 	normal;
	class 		Tri3D *next;
	float		lightEffect_1, lightEffect_2, lightEffect_3;
	float		light_distance, light_strength; // for default light (lightList[0])
	Vertex3D 	clip_v[3]; 						// The clipped vertices (passed to TimeSlice)
	
				Tri3D(
					int ivi1, int ivi2, int ivi3, 
					Uv &uv1, Uv &uv2, Uv &uv3, Rgb &p_rgb,
					int texmapIndex, int type, 
					Light3D light_list[],
					Vector3D vertex_list[], long dat);
	void 		CalcFixedLightEffects(
					Light3D lightList[], 
					Vertex3D &v1, Vertex3D &v2, Vertex3D &v3);
	int 		GetClip(Vertex3D *vertexList);				
};

#endif