#include <string.h>
#include "Texture.h"

char *Texture16::CreateWashLR(Rgb start, Rgb end)
{
	if (!bits) return NULL;
	float rstep = (end.r - start.r) / width;
	float gstep = (end.g - start.g) / width;
	float bstep = (end.b - start.b) / width; 
	for (int n = 0; n < width; n++) {
		PackedRgb p(start.r, start.g, start.b);
		for (int y = 0; y < height; y++)
			pairs[y * width + n] =   p.GetShorty();
		start.r += rstep;
		start.g += gstep;
		start.b += bstep;	
	}
	return bits;
}	

char *Texture16::CreateWashTB(Rgb start, Rgb end)
{
	if (!bits) return NULL;
	float rstep = (end.r - start.r) / height;
	float gstep = (end.g - start.g) / height;
	float bstep = (end.b - start.b) / height;
	for (int y = 0; y < height; y++) {	
		PackedRgb p(start.r, start.g, start.b);		
		for (int x = 0; x < width; x++) {
			pairs[y * width + x] =   p.GetShorty();
		}
		start.r += rstep;
		start.g += gstep;
		start.b += bstep;			
	}
	return bits;
}	

char *Texture16::CreateFlatColor(Rgb col)
{
	// More for debugging...
	if (!bits) return NULL;
	for (int y = 0; y < height; y++) {	
		PackedRgb p(col.r, col.g, col.b);		
		for (int x = 0; x < width; x++) {
			pairs[y * width + x] =   p.GetShorty();
		}
	}
	return bits;
}	
	
char *Texture16::CreateBlock(Rgb col)
{
	// Also for debugging...
	if (!bits) return NULL;
	PackedRgb p(col.r, col.g, col.b);
	
	for (int y = 0; y < height; y++) {	
		memset(bits + y * rowBytes, p.GetShorty(), rowBytes);
	}
	return bits;
}	
	