#include "Quad3D.h"

float Quad3D::light_res = 0.001f;

inline float fmax(float v, float m) 
	{ return v > m ? m : v; }
inline float flimit(float v, float min, float max) 
	{ float f = fmax(v, max); return f >= min ? f : min; }

Quad3D::Quad3D(
	int ivi1, int ivi2, int ivi3, int ivi4,
	Uv &puv1, Uv &puv2, Uv &puv3, Uv &puv4, Rgb &p_rgb,
	int texmapIndex, int ptype, 
	Light3D light_list[],
	Vector3D vertex_list[], long ud)
	:
	vi1(ivi1),
	uv1(puv1),
	vi2(ivi2),
	uv2(puv2),
	vi3(ivi3),
	uv3(puv3),
	vi4(ivi4),
	uv4(puv4),
	next(NULL),
	texmap(texmapIndex),
	type(ptype),
	r(p_rgb.r),
	g(p_rgb.g),
	b(p_rgb.b),
	userData(ud)
{	
	normal.SetupAsNormal(vertex_list[vi1], vertex_list[vi2], vertex_list[vi3]);		
	CalcFixedLightEffects(light_list, vertex_list[vi1], vertex_list[vi2], vertex_list[vi3], vertex_list[vi4]);
}

void Quad3D::CalcFixedLightEffects(
	Light3D lightList[], Vertex3D &v1, Vertex3D &v2, Vertex3D &v3, Vertex3D &v4)
{
	lightEffect_1 = lightEffect_2 = lightEffect_3 = lightEffect_4 = 0.0f;
	int active_lights = 0;
	float dotPlus = 1.0f;
						
	for (int i = 0; i < MAX_LIGHTS; i++) {
		Light3D &l3d = lightList[i];
		if (l3d.active) { 
			active_lights++;
			switch (l3d.light_type) {
			case L3D_SPOT:
			case L3D_AMBIENT:
			case L3D_LOCAL:
			case L3D_DISTANT:
				// GetStrength should return val between -1.0f and 1.0f
				// based on dot product of light vector and tri normal
				// multiplied by distance for spot or local, or
				// scaled by relative distance from nearest point of object
				// It's a fair hack, anyway... 			
				float dis_1 = v1.GetDistance(l3d); 
				float dis_2 = v2.GetDistance(l3d); 
				float dis_3 = v3.GetDistance(l3d);
				float dis_4 = v4.GetDistance(l3d);
				// invert
				dis_1 = 1.0f / dis_1;
				dis_2 = 1.0f / dis_2; 
				dis_3 = 1.0f / dis_3; 
				dis_4 = 1.0f / dis_4; 
				float dot = normal.GetDotProduct(l3d);
				if (dot != 0.0f) { // workaround MW debugger problem no fp watch				
					dotPlus = (1.0f - dot) * l3d.strength;				
				}
				lightEffect_1 += dis_1 + dotPlus;
				lightEffect_2 += dis_2 + dotPlus;
				lightEffect_3 += dis_3 + dotPlus;
				lightEffect_4 += dis_4 + dotPlus;
			}
		}
	}
	if (active_lights) {
		lightEffect_1 /= active_lights;
		lightEffect_2 /= active_lights;
		lightEffect_3 /= active_lights;
		lightEffect_4 /= active_lights;
		
		rgb1.r = flimit(r + lightEffect_1, 0.0f, 1.0f);
		rgb1.g = flimit(g + lightEffect_1, 0.0f, 1.0f);
		rgb1.b = flimit(b + lightEffect_1, 0.0f, 1.0f);

		rgb2.r = flimit(r + lightEffect_2, 0.0f, 1.0f);
		rgb2.g = flimit(g + lightEffect_2, 0.0f, 1.0f);
		rgb2.b = flimit(b + lightEffect_2, 0.0f, 1.0f);

		rgb3.r = flimit(r + lightEffect_3, 0.0f, 1.0f);
		rgb3.g = flimit(g + lightEffect_3, 0.0f, 1.0f);
		rgb3.b = flimit(b + lightEffect_3, 0.0f, 1.0f);	
		
		rgb4.r = flimit(r + lightEffect_4, 0.0f, 1.0f);
		rgb4.g = flimit(g + lightEffect_4, 0.0f, 1.0f);
		rgb4.b = flimit(b + lightEffect_4, 0.0f, 1.0f);			
	}
}

int Quad3D::GetClip(Vertex3D *vertexList)
{	
	// Project() will store the temporary uv values in the vertex
	// The pixel_point Vertex3D values are clipped and are also temporary
	
	/*
	Line2D::SetClipRect(Vertex3D::raster_min_x, Vertex3D::raster_min_y,	
		Vertex3D::raster_max_x, Vertex3D::raster_max_y);
	*/	
	Vertex3D &v1 = vertexList[vi1];
	Vertex3D &v2 = vertexList[vi2];
	Vertex3D &v3 = vertexList[vi3];
	Vertex3D &v4 = vertexList[vi4];
	
	int point_set = v1.Project() + v2.Project() + v3.Project() + v4.Project();
	
		// All points are within z range
		// Points returning 1 are within viewport
		// Points returning -1 need clipping
		
	if (point_set < -4) return 0; // At least 1 of z is out
		
	switch (point_set) {
	case 4:
		// all points in,
		// UV unaffected
		v1.u = uv1.u;
		v1.v = uv1.v;
		v2.u = uv2.u;
		v2.v = uv2.v;
		v3.u = uv3.u;
		v3.v = uv3.v;
		v4.u = uv4.u;
		v4.v = uv4.v;
		return 1;				
	// This is where you will need to design finer clipping resolution
	// if the rasterizer doesn't handle it. RAVE doesn't, Direct3D IM does.
	case -3: 					// all points out
		break;					
	case -1:					// 2 points are out
		break;
	case 1:						// 1 point out
		break;
	}
	return 0;	
}

