#ifndef PANEL_H
#define PANEL_H

#include "WinDOS.h"
#include "Renderer.h"
#include "Tri3D.h"

struct QuadVertexIndices {
	int a, b, c, d;
	
	QuadVertexIndices(
		int pa, int pb, 
		int pc, int pd)
	: a(pa), b(pb), c(pc), d(pd) {}
};

struct VertexRect {
	Vertex3D *a, *b, *c, *d;
};

struct Quad {
	Tri3D 	*t1, *t2;	
	float 	r, g, b;
	int 	tex;
	long 	data;  // -1 is reserved to denote invalid
	Quad	*next;
	
	QuadVertexIndices GetVertices() {
		QuadVertexIndices qv(
			t1->vi1, t1->vi2, 
			t2->vi2, t2->vi3);
		return qv;
	}	
};

struct IndexedQuad {
	// These are direct indices into vertex list
	// For rasterizers that take triangles only,
	// these need to be converted to two tris for submission
	int			v1, v2, v3, v4; 	
	float 		r, g, b;
	int 		tex;
	long 		data;  // -1 is reserved to denote invalid
	IndexedQuad	*next;		
};

class Panel {
	Renderer 		*renderer;
	
	int 			AddIndexedQuad(
						int qIndex,
						int vi1, int vi2, int vi3, int vi4, 
						Rgb &p_rgb, int tmp, int type = TRI_FIXED, long triData = -1);							
	
public:	
	float 			width, height;
	int 			columns, rows, quadListSize, indexedQuadListSize, 
					start_vertex, end_vertex;
	Quad 			*quadList;
	IndexedQuad		*indexedQuadList;
	long			ref;
	
					Panel();
					Panel(long r);	
					~Panel();	
	
	bool 			Create(
						Renderer *r, float w, float h, int col, int row, long dat);
	void			Destroy();
	int 			InstallQuads(
						float rcol, float gcol, float bcol,	
						float tx, float ty, float tz,
						float rx, float ry, float rz,
						int tex_index, int vData);						
	Quad 			AddQuad(
						int qIndex,
						int vi1, int vi2, int vi3, 
						int vi4, Rgb &p_rgb, int tmp, int type = TRI_FIXED, long dat = 0);	
	void 			ColorCell(
						int posx, int posy,
						float red, float green, float blue, int tmapIndex, int dat);
	void 			Transform(
						float tx, float ty, float tz, 
						float rx, float ry, float rz,long t);						
	void 			Rotate(
						float rx, float ry, float rz, long t);						
						
	Panel 			*Append();
	Panel 			*Find(long r);
	int				GetCellBounds(int cellCol, int cellRow, VertexRect &vRect);
		
	Panel			*next;	
};

#endif