#include "Panel.h"
#include "Color16.h"
#include "Quad3D.h"

#define GIVE 5 // arbitrary inset value for fake lighting of panel

inline float fmax(float v, float m) { return v > m ? m : v; }
inline float fmin(float v, float m) { return v < m ? m : v; }

Panel::Panel() 
	:
	ref(0),
	renderer(NULL),
	width(0.0),
	height(0.0),
	quadList(NULL),
	quadListSize(0),
	next(NULL)
{

}

Panel::Panel(long r) 
	:
	ref(r),
	renderer(NULL),
	width(0.0),
	height(0.0),
	quadList(NULL),
	quadListSize(0),
	next(NULL)
{

}

Panel::~Panel()
{
	if (quadList) delete [] quadList;
}

bool Panel::Create(
	class Renderer *r, 
	float w, float h, 
	int col, int row, long dat) 
{
	width = w; 
	height = h; 	
	columns = col; 
	rows = row;
	renderer = r;
	if (quadList = new Quad[columns * rows])
		quadListSize = columns * rows;
	else
		quadListSize = 0;
	if (dat) ref = dat;
	return quadList != NULL;
}

void Panel::Destroy()
{
	Panel *current_panel = this->next, *next_panel;
	this->next = NULL;
	while (current_panel) {
		next_panel = current_panel->next;
		delete current_panel;
		current_panel = next_panel;
	}
}
	
Panel *Panel::Append()
{
	Panel *current_panel = this;
	while (current_panel->next)
		current_panel = current_panel->next;
	current_panel->next = new Panel();
	return current_panel->next;
}

Panel *Panel::Find(long r)
{
	Panel *current_panel = this;
	do {
		if (current_panel->ref == r) 
			break;
		current_panel = current_panel->next;
	} while (current_panel);
	return current_panel;
}
		
Quad Panel::AddQuad(
	int qIndex,
	int vi1, int vi2, int vi3, int vi4, 
	Rgb &p_rgb, int tmp, int type, long dat)
{
	Quad ret;
	if (qIndex >= quadListSize) {
		ret.data = -1;
		return ret;
	}
	Uv uv1(0, 1, O_LEFT, O_TOP);
	Uv uv2(0, 0, O_LEFT, O_BOTTOM);
	Uv uv3(1, 0, O_RIGHT, O_BOTTOM);
	Uv uv4(1, 1, O_RIGHT, O_TOP);
	
	ret.t1 = renderer->AddTri(vi1, vi2, vi4, uv1, uv2, uv4, p_rgb, tmp, type);
	ret.t2 = renderer->AddTri(vi2, vi3, vi4, uv2, uv3, uv4, p_rgb, tmp, type);	
	ret.r = p_rgb.r;
	ret.g = p_rgb.g;
	ret.b = p_rgb.b;
	ret.tex = tmp;
	ret.data = dat;	
	quadList[qIndex] = ret;
	return ret;
}

int Panel::AddIndexedQuad(
	int qIndex,
	int vi1, int vi2, int vi3, int vi4, 
	Rgb &p_rgb, int tmp, int type, long dat)
{
	IndexedQuad ret;
	if (qIndex >= indexedQuadListSize) {
		ret.data = -1;
		return -1;
	}
	if (dat == -1) dat = qIndex;
	Uv uv1(0, 1, O_LEFT, O_TOP);
	Uv uv2(0, 0, O_LEFT, O_BOTTOM);
	Uv uv3(1, 0, O_RIGHT, O_BOTTOM);
	Uv uv4(1, 1, O_RIGHT, O_TOP);

	Quad3D *active_quad, *new_quad;
	active_quad = renderer->quad_list;
	while (active_quad) {
		if (active_quad->next)
			active_quad = active_quad->next;
		else
			break;	
	}
	
	new_quad = new Quad3D(
		vi1, vi2, vi3, vi4, uv1, uv2, uv3, uv4, 
		p_rgb, tmp, type, renderer->lightList, renderer->vertex_list, dat);
	
	if (!active_quad) // must be first one
		renderer->quad_list = new_quad;
	else
		active_quad->next = new_quad;	
	return 1;
}

void Panel::ColorCell(
	int posx, int posy,
	float red, float green, float blue, int tmapIndex, int dat)
{
	Quad &qq = quadList[posy * columns + posx];
	qq.data = dat; 
	Tri3D *workTri = qq.t1;
	workTri->rgb1.r = red;
	workTri->rgb2.r = red;
	workTri->rgb3.r = red;
	workTri->rgb1.g = green;
	workTri->rgb2.g = green;
	workTri->rgb3.g = green;
	workTri->rgb1.b = blue;
	workTri->rgb2.b = blue;
	workTri->rgb3.b = blue;
	workTri->texmap = tmapIndex;
	workTri = qq.t2;
	workTri->rgb1.r = red;
	workTri->rgb2.r = red;
	workTri->rgb3.r = red;
	workTri->rgb1.g = green;
	workTri->rgb2.g = green;
	workTri->rgb3.g = green;
	workTri->rgb1.b = blue;
	workTri->rgb2.b = blue;
	workTri->rgb3.b = blue;
	workTri->texmap = tmapIndex;		
}

void Panel::Transform(
	float tx, float ty, float tz, 
	float rx, float ry, float rz,long t)
{
	// This would be far more efficient if
	// a linked list is passed to the renderer->vertex function
	for (int i = 0; i < quadListSize; i++) {		
		QuadVertexIndices qv = quadList[i].GetVertices();
		renderer->vertex_list[qv.a].Transform(tx, ty, tz, rx, ry, rz, t);
		renderer->vertex_list[qv.b].Transform(tx, ty, tz, rx, ry, rz, t);
		renderer->vertex_list[qv.c].Transform(tx, ty, tz, rx, ry, rz, t);
		renderer->vertex_list[qv.d].Transform(tx, ty, tz, rx, ry, rz, t);
	}
}

int Panel::InstallQuads(
	float rcol, float gcol, float bcol,	
	float tx, float ty, float tz,
	float rx, float ry, float rz,
	int tex_index, int vData)
{	
	int meshPointsX = columns + 1;
	int meshPointsY = rows + 1;
	if (meshPointsX < 2) meshPointsX = 2;
	if (meshPointsY < 2) meshPointsY = 2;

	float posx = -(meshPointsX / 2.0f);
	float posy = -(meshPointsY / 2.0f);
	float posz = 0;
	float vx, vy, vz;
	float colsize, rowsize;

	int q1, q2, q3, q4;
	int q = 0;

	colsize = width / (meshPointsX - 1);
	rowsize = height / (meshPointsY - 1);

	start_vertex = renderer->num_vertices;
	int lastv = -1, ext;
	float slope, s = meshPointsX * meshPointsY;
	Rgb t_rgb(rcol, gcol, bcol);
		
	// make a simple mesh	
	for (int row = 0; row < meshPointsY; row ++) {
		for (int col = 0; col < meshPointsX; col++) {
			slope = s - (float)(row * meshPointsX + col) + GIVE;
			vx = posx + col * colsize;
			vy = posy + row * rowsize;
			vz = posz;
			if ((lastv = renderer->AddVertex(vx, vy, vz, 
				rcol * fmax((slope / s), 1.0f), 
				gcol * fmax((slope / s), 1.0f), 
				bcol * fmax((slope / s), 1.0f), vData)) < 0)
				goto skip;
			end_vertex = lastv;	
			renderer->TransformVertex(lastv, tx, ty, tz, rx, ry, rz);
		}		
	}
skip:		
	for (row = 0; row < (meshPointsY - 1); row++) {
		int offset = start_vertex + row * meshPointsX;
		for (int col = 0; col < (meshPointsX - 1); col++) {
			if ((ext = (offset + col + meshPointsX + 1)) > lastv) return -1;
			q1 = offset + col;
			q2 = offset + col + meshPointsX;
			q3 =  ext;
			q4 = offset + col + 1;			
			AddIndexedQuad(q++, q1, q2, q3, q4, t_rgb, tex_index);
		}
	}
	return 1;
}
