#ifndef LINE2D_H
#define LINE2D_H

enum {
	clip_none = 0,
	clip_start = 1,
	clip_end = 2,
	clip_accept = 4
};

class Point2D {
public:
	int x, y;
	Point2D() : x(0), y(0) {}
	Point2D(int px, int py) : x(px), y(py) {}
	void operator-=(Point2D &sub) { x -= sub.x; y -= sub.y; }
	void operator+=(Point2D &add) { x += add.x; y += add.y; }	
};

typedef struct {
	union {
		unsigned short all;
		struct {
			unsigned left : 4;
			unsigned right : 4;
			unsigned bottom : 4;
			unsigned top : 4;
		} sector;
	};
} OutCode;

class Line2D {			
	static int 			min_x, min_y, max_x, max_y;
					
	inline OutCode		CompOutCode(int x, int y);	

public:
						Line2D(int xa, int ya, int xb, int yb) 
							: x0(xa), y0(ya), x1(xb), y1(yb) {
							start_clip_factor = end_clip_factor = 1.0f; }
							
	static void 		SetClipRect(int x1, int x2, int y1, int y2) {
					 		min_x = x1; min_y = y1; max_x = x2; max_y = y2; }					 			
	int 				Clip2Rect();
	
	int 				x0, y0, x1, y1;
	float				start_clip_factor, end_clip_factor;
};		

#endif