#include "Color16.h"

ColorDef Color::red = {1.0f, 0.0f, 0.0f};
ColorDef Color::green = {0.0f, 1.0f, 0.0f};
ColorDef Color::blue = {0.0f, 0.0f, 1.0f};
ColorDef Color::black = {0.0f, 0.0f, 0.0f};
ColorDef Color::white = {1.0f, 1.0f, 1.0f};

PackedRgb::PackedRgb()
: flr(0.0f), flg(0.0f), flb(0.0f) 
{ 
	SetShorty();
}

PackedRgb::PackedRgb(float fr, float fg, float fb)
: flr(fr), flg(fg), flb(fb) 
{ 
	SetShorty();
}

PackedRgb::PackedRgb(short s)
{ 
	// Note: this is for quick conversions via GetShorty()
	// Float values are not set
	packed = *((Rgb16 *)&s);
}

void PackedRgb::Set(float fr, float fg, float fb)
{ 
	flr = fr; flg = fg; flb = fb; 
	SetShorty();
}

void PackedRgb::SetShorty()
{
	packed.a = 1;
	packed.r = (int)(0x0f * flr); 
	packed.g = (int)(0x0f * flg); 
	packed.b = (int)(0x0f * flb);
	
	// shorty = *((short*)&packed); // now a union
}
