#include "AppMain.h"

// globals
int bscan = 0;
int running = 1;
int is_active = 0;
Raver *rave = NULL;

#if defined(__INTEL__)
	char szAppName[] = "HeadsOffApp";
	HWND hWindow = NULL;
#endif

//////////////////////////////////// main \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

#if defined(macintosh)
int main()
#elif defined(__INTEL__)
int CALLBACK WinMain(
	HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPSTR lpCmdLine,
	int nCmdShow)	
#endif

{	
	unsigned long scanrslt;
#if defined(macintosh)
	InitToolbox ();
#endif	
	KeyScanner scanner(&bscan);
	is_active = 1;

#if defined(__INTEL__)
    MSG msg;
	
	if (!InitApplication(hInstance)) return (FALSE); 	
	rave = new Raver(WINWIDTH, WINHEIGHT, (void*)hInstance, mazev);
	if (rave) {
		rave->Load();
		hWindow = rave->window;
				
		while (running) {
			if (::PeekMessage(&msg, rave->window, 0, 0, PM_REMOVE))
					::DispatchMessage(&msg);	    	    
				scanner.Scan(&scanrslt);
		    	if (scanrslt & k_esc)
		    		running = 0;	        	    		
		    	else		
					if (is_active) rave->TimeSlice(scanrslt);
		}	
	} 
	// this is just a precaution, as the destructor is called
	// by CW Win (see below about Mac condition)
	rave->Destroy();   	
    return (msg.wParam); // INTEL

#elif defined(macintosh)

	EventRecord event;
	// Compiler won't allow >32K dynamic class on Mac (local data error)
	rave = new Raver(WINWIDTH, WINHEIGHT, NULL, mazev);
	if (rave) {
		rave->Load();
				
		while (running) {
	    	if (WaitNextEvent(keyDownMask, &event, 0, NULL))
				HandleEvent(&event);	    		
			scanner.Scan(&scanrslt);
    		if (scanrslt & k_esc) 
    			running = 0;	   
    		else
    			rave->TimeSlice(scanrslt);
		}	
	}
	// a slight quirk of the CW Mac package: we can't delete
	// the object and null it as the object reference is obviously
	// cached and deleted by the system, so we get mem error.
	// But strangely the destructor is not called
	
	//rave->DumpInfo(); // if you want to see where your camera was positioned last
	
	rave->Destroy(); 	
	FlushEvents (everyEvent, 0);
	return (0);

#endif // macintosh

}

#if defined(__INTEL__)

BOOL InitApplication(HINSTANCE hInst)
{
    WNDCLASS  wc;
    HWND      hwnd;

    hwnd = FindWindow (szAppName, 0);
    if (hwnd) 
	{
        // We found another version of ourself. Lets defer to it:
        if (IsIconic(hwnd)) 
            ShowWindow(hwnd, SW_RESTORE);
        SetForegroundWindow (hwnd);
        return false;
    }	
    wc.style         = 0;//CS_HREDRAW | CS_VREDRAW | CS_CLASSDC;
    wc.lpfnWndProc   = (WNDPROC)WndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInst;
    wc.hIcon         = LoadIcon (hInst, szAppName);
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);

	wc.lpszMenuName  = NULL;
	
    wc.lpszClassName = szAppName;
	return RegisterClass(&wc);
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	//int newWidth;
	//int newHeight;
	//int newDepth;
	HDC hdc = NULL;
	PAINTSTRUCT ps;
	
	switch (message) {
	case WM_KILLFOCUS:
		is_active = FALSE;
		break;
	case WM_SETFOCUS:
		is_active = TRUE;
		ShowCursor(FALSE);
		break;
		/*
	case WM_DISPLAYCHANGE:
		newWidth = LOWORD(lParam);
		newHeight = HIWORD(lParam);
		newDepth = wParam;
		// TODO: adjustments for new display settings
		break;
		*/
	case WM_PAINT:
		hdc = BeginPaint(hdc, &ps);
		// TODO: put your drawing update code here
		if (is_active) rave->TimeSlice(0);
		EndPaint(hWnd, &ps);
		break;
	case WM_CLOSE:
		running = 0;;
		return false;
	default:
		return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	return (01);
}

#endif // INTEL

#if defined(macintosh)

void InitToolbox ()
{
	InitGraf((Ptr) &qd.thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	FlushEvents(everyEvent,0);
	TEInit();
	InitDialogs(0L);
	InitCursor();
}

bool HandleEvent(EventRecord* myEvent)
{
	Rect dragRect;
	WindowPtr whichWindow;
	short res = 0;

	switch (myEvent->what) {
	case mouseDown:
		switch ((short)FindWindow(myEvent->where, &whichWindow)) {
		case inSysWindow:
			SystemClick(myEvent, whichWindow);
			break;
		case inMenuBar:
			res = DoCommand(MenuSelect(myEvent->where));
			break;
		case inDrag:
			SetPort((GrafPtr)whichWindow);
			SetRect(&dragRect, 4, 20 + 4, qd.screenBits.bounds.right - 4, qd.screenBits.bounds.bottom - 4);
			DragWindow(whichWindow, myEvent->where, &dragRect);
			break;
		case inContent:
			if (whichWindow != FrontWindow())
				SelectWindow(whichWindow);
			break;
		}
		break;
	case keyDown:
		int kChar = (myEvent->message & charCodeMask);
		if (((myEvent->modifiers & cmdKey) != 0)) {
			if (kChar == 'q' || kChar == 'Q')
				running = false;
		}
		break;
	}
	return (res);
}

short DoCommand(long mResult)
{
	short theMenu, theItem;
	OSErr res = 0;

	theItem = LOshort(mResult);
	theMenu = HIshort(mResult);					// This is the resource ID 

	switch (theMenu) {
	case APPLE_MENU_ID:
		if (theItem == 1)
			ShowAboutBox();
		break;

	case FILE_MENU_ID:
		switch (theItem) {
		// TODO: file menu items here
		}
		break;
	}

	HiliteMenu(0);
	return (res);
}

void ShowAboutBox()
{
	// TODO: Mac about box here if desired
}

#endif