// External Declarations for various tables

#ifndef TABLES_HPP
#define TABLES_HPP

#include "misc.hpp"

typedef struct {                  // Define of each min code table entry
  int Index;
  long CodeValue;
} MINCODEENTRY;

// Misc. Tables
extern BYTE LumaQuantTable[64];   // Luma quantization table
extern BYTE ChromaQuantTable[64]; // Chroma quantization table

extern BYTE ZigZagTable[64];      // Zig zag reordering table

// Tables related to Huffman Encoding/Decoding. Names of tables
// describe their content.
extern BYTE EncDCLumaCodeLength[12];
extern WORD EncDCLumaCode[12];
extern BYTE EncDCChromaCodeLength[12];
extern WORD EncDCChromaCode[12];
extern BYTE EncACLumaCodeLength[256];
extern WORD EncACLumaCode[256];
extern BYTE EncACChromaCodeLength[256];
extern WORD EncACChromaCode[256];

extern MINCODEENTRY DecDCLumaMinCodeIndex[10];
extern long DecDCLumaMaxCodeIndex[10];
extern BYTE DecDCLumaCodeCategory[12];
extern WORD DecDCLumaCode[12];

extern MINCODEENTRY DecDCChromaMinCodeIndex[12];
extern long DecDCChromaMaxCodeIndex[12];
extern BYTE DecDCChromaCodeCategory[12];
extern WORD DecDCChromaCode[12];

extern MINCODEENTRY DecACLumaMinCodeIndex[17];
extern long DecACLumaMaxCodeIndex[17];
extern BYTE DecACLumaCodeCategory[162];
extern WORD DecACLumaCode[162];

extern MINCODEENTRY DecACChromaMinCodeIndex[17];
extern long DecACChromaMaxCodeIndex[17];
extern BYTE DecACChromaCodeCategory[162];
extern WORD DecACChromaCode[162];

#endif

