// Discrete Cosine Transform Class Interface File

#ifndef DCT_HPP
#define DCT_HPP

#include "misc.hpp"

#define FORWARDREORDER  1         // Direction of zigzag
#define INVERSEREORDER  0         // 1 is pixel order to freq order
                                  // 0 is freq order to pixel order

// The DCT Class Definition
class DCT {

  public:
	 DCT(void);

	 void FDCT(BYTEBLOCKPTR InBlock, INTBLOCKPTR  OutBlock);
	 void IDCT(INTBLOCKPTR  InBlock, BYTEBLOCKPTR OutBlock);

     void ZigZagReorder(int *InBlock, int *OutBlock, BOOL ForwardReorder);
};

#endif


