// Buffer Manager Class Interface Definition


#ifndef BUFMAN_HPP
#define BUFMAN_HPP

#include "misc.hpp"
#include "color.hpp"

// The BufferManager Class Definition
class BufferManager {
  private:
    IMAGETYPE ImageType;
    WORD WidthInPixels;
    BYTE huge *lpDIBImageData;

    BYTE State;                   // One of six possible states
	WORD Y1Offset;                // Horz offset in buffer to block
	WORD Y2Offset;                // of interest
	WORD CbOffset;
	WORD CrOffset;

	WORD NumberOfHorzBlocks;
    int  HorzBlocksLeft;
    WORD FromRow;
    WORD ToRow;

	WORD YBufferBytesPerLine;
    WORD CBufferBytesPerLine;
	DWORD BufferSize;

	BYTE far *lpY1Buffer;
	BYTE far *lpY2Buffer;
	BYTE far *lpCbBuffer;
	BYTE far *lpCrBuffer;

    ColorConvert *ColorConvertObject;

  public:
    BufferManager(IMAGETYPE Type, WORD Width, WORD Height,
                  BYTE huge *lpImage);
   ~BufferManager(void);

	void GetNextBlock(BYTE *lpBlock, int BlockTypeNumber);
	void PutNextBlock(BYTE *lpBlock, int BlockTypeNumber);

    void FlushDIBData(void);

};

#endif

