#ifndef MMNEHEAD_H
#define MMNEHEAD_H

#define NO_EXE          0
#define NO_NE           1
#define GOT_NE                2

#define NE_SIGVALUE     0x454E          // 'NE' -- Win, 16-bit os/2 and os/2 bound apps
#define LE_SIGVALUE     0x454C          // 'LE' -- Win VxD
#define LX_SIGVALUE     0x584C          // 'LX' -- os/2 32-bit
#define PE_SIGVALUE     0x4550          // 'PE' -- Win32 app
#define WIN386_SIGVALUE 0x3357          // 'W3' -- Win386.exe

// based on Chapter 6 of the 3.1 SDK programmer's ref (volume 4)
// See UNDOCUMENTED WINDOWS for a description of how this structure
//   changes once a New Executable has been loaded into memory (see
//   Module Table)
typedef struct tagNEHeader
{
    UINT MagicNumber ;
    UINT        Linker ;
    UINT        pEntry ;      // start of entry table
    UINT        cbEntry ;     // size of entry table
    DWORD CheckSum ;   // field name taken from EXEHDR
    UINT        wModuleflags ;
    UINT nAutoDS ;     // automatic DS segment number (usually last segment)

    UINT        cbHeap ;      // initial size of local heap
    UINT cbStack ;     // stack size
    ULONG EntryPoint ; // CS:IP
    ULONG Stack ;      // SS:SP
    UINT cbSegment ;      // no. of entries in segment table
    UINT cbModule ;    // no. entries in module table
    UINT cbNRes ;      // no. of entries in non-resident names table

    UINT pSegment ;  // start of segment table
    UINT pResource ; // start of resource table
    UINT pResident ; // start of resident name table
    UINT pModule ;   // start of module reference table
    UINT pImport ;   // start of imported names table
    UINT pNRes ;     // start of non-resident names table

    UINT cbMoveEnt ; // count of moveable entries -- field name from EXEHDR

    UINT align ;             // segment alignment shift count (EXEHDR seg sector size)
    UINT cbResource ;  // no. of resource segments
    BYTE        apptype ;     // target operating system
    BYTE        otherflags ;  // other .EXE flags
    UINT pFastLoad ;

    UINT        lenFastLoad ;
    UINT        reserved ;
    UINT        expWinver ;   // expected version
} NEHEADER ;

typedef struct tagEntryTable
{
    BYTE CountOfRecords ; // number of records in this bundle
    BYTE FixedMoveable ;   // segment type for this bundle
    BYTE Entry[1] ;
} ENTRYTABLE ;


// note the interleaved BYTE and WORD values below:
// they require your compiler to build structures on a one
//   byte boundary (see your compiler documentation on structure packing)
typedef struct tagEntryTableMoveable
{
    BYTE flags ;
    WORD int3f ;
    BYTE segno ;
    WORD offset ;
} ETMOVEABLE ;

typedef struct tagEntryTableFixed
{
    BYTE flags ;
    WORD offset ;
} ETFIXED ;

typedef struct tagSegment
{
    WORD offset ;
    WORD len ;
    WORD flags ;
    WORD minsize ;
} SEGMENT ;

#endif // MMNEHEAD_H

