// mapman.h -- generic constants for the MapMan application
#ifndef MAPMAN_H
#define MAPMAN_H

// the following are constants to allow our DOS app to use
//   Windows-like data types.
#ifndef ULONG
typedef unsigned long ULONG ;
#endif

#ifndef UINT
typedef unsigned int  UINT ;
#endif

#ifndef BOOL
typedef unsigned int BOOL ;
#endif

#ifndef DWORD
typedef unsigned long DWORD ;
#endif

#ifndef WORD
typedef unsigned int WORD ;
#endif

#ifndef BYTE
typedef unsigned char BYTE ;
#endif

#ifndef NULL
#define NULL ( ( void *) 0 )
#endif

#ifndef TRUE
#define TRUE ( 1 )
#endif

#ifndef FALSE
#define FALSE ( 0 )
#endif

#ifndef LOWORD
#define LOWORD( val )           ( (WORD)(DWORD)( val ) )
#endif
#ifndef HIWORD
#define HIWORD( val )           ( (WORD)((( (DWORD)( val ) ) >> 16) & 0xFFFF))
#endif

#define RC_OK          ( 0 )
#define RC_NOARG       ( 1 )
#define RC_NOOLDEXE    ( 2 )
#define RC_NONEWEXE    ( 3 )
#define RC_CANTFINDEXE ( 4 )
#define RC_MALLOCERROR ( 100 )

#define BUFFERSIZE     ( 32 * 1024 )
#define SEEK_BEGIN     0

// prototypes follow:

// in mapman.c
BOOL LoadExe( char *pExeName ) ;

// in mapdutil.c -- contains DOS-specific code for the following procs
BOOL AllocBuffer( void ) ;
BOOL FreeBuffer( void ) ;
int  DebugInt( int myint ) ;
int  DebugString( char *pstr ) ;
void myexit( int rc ) ;
int  myFileOpen( char *pExeName ) ;
int  myFileSeek( int hExe, int offset, int direction ) ;
int  myFileRead( int hExe, char *pBuffer, int cbBuffer ) ;
void myfree( void *pMem ) ;
void *mymalloc( int iSizeToAlloc ) ;
int  myprintfBuildFarPtr( int seg, int offset ) ;
int  myprintfFormatInt( char* format, int value ) ;
int  myprintfFormatStr( char* format, char *str ) ;
int  myprintfInt( int myint ) ;
int  myprintfStr( char *pstr ) ;
BOOL ProcessArgs( int cbArg, char *pArgs[] ) ;

// in mapfile.c -- NE-specific code
BOOL BuildEntryTable( void ) ;
BOOL BuildNonResidentNamesTable( void ) ;
BOOL BuildResidentNamesTable( void ) ;
BOOL BuildSegmentTable( void ) ;
BOOL IsMZ( void ) ;
BOOL IsNE( void ) ;
BOOL SetMZ( char *pBuff ) ;
BOOL SetNE( void ) ;

// in mapllist.c -- routines related to our entrypoint and segment lists
void DumpEntryPointList( void ) ;
void DumpPublicsByName( void ) ;
void DumpPublicsByValue( void ) ;
void DumpSegmentList( void ) ;
void FreeLists( void ) ;
struct tagEntryPoint *GetEntryPointElement( WORD ordinal ) ;
char* GetModuleName( void ) ;
struct tagEntryPoint *MakeEntryPointElement( void ) ;

// in mapmkmap.c
int BuildMapFile( void ) ;
int myTabAsSpaces( char* PrevString, int HowMuch ) ;

#ifndef NOEXTERNS
extern char* pBuffer ;
extern char* pExeName ;
extern BOOL  bVerbose ;
extern struct tagMZHeader *pMZ ;
extern struct tagNEHeader *pNE ;
extern struct tagSegment  *pSegmentHead ;
#endif

#endif // MAPMAN_H
