// mapfile.c -- includes various file-system things such as header validation
//   functions, and the functions to build various NE structures
//   Please note:  because of the manipulation of NE structures in this
//   module, be SURE that your compiler is packing structs on a 1 byte
//   boundary (see the note on ETMOVEABLE in mmnehead.h).

#include "mapman.h"
#include "mmmzhead.h"
#include "mmnehead.h"
#include "mapllist.h"

#define INVALID_VALUE  0xFFFF

// do we have a valid MZ?
BOOL IsMZ( )
{
  return ( ( MZ_SIGVALUE == pMZ->MagicNumber ) ? TRUE : FALSE ) ;
}

// set our MZ header pointer and validate its contents
BOOL SetMZ( char *pBuff )
{
  pMZ = (MZHEADER *) pBuff ;
  return( IsMZ() ) ;
}

// do we have a valid NE?
BOOL IsNE( )
{
  return ( ( NE_SIGVALUE == pNE->MagicNumber ) ? TRUE : FALSE ) ;
}

// set our NE header pointer and validate its contents
BOOL SetNE( )
{
  char *pBytes ;
  int  NEoffset ;

  if ( ( pMZ ) &&
       ( pMZ->RelocationTableAddress >= 0x40 ) )
  {
    pBytes = (char *) pMZ ;          // get BYTE pointer for MZHeader base
                                     //   (needed because of how C does
                                     //   structure arithmatic)
    NEoffset = (int) pMZ->pThisNE ;  // extract offset of NEHeader
    pBytes += NEoffset ;
                                     // pBytes now points to NEHeader
    pNE = (NEHEADER *) pBytes ;
    return( IsNE() ) ;
  }
  else
    return( FALSE ) ;
}

// build elements for resident names table on our entry list
//   The first element is the module (or library) name from the .DEF file
BOOL BuildResidentNamesTable()
{
  char *pByte = (char *) pNE ;
  int  offset = pNE->pResident ;
  char cbSize ;
  int  ordinal, *pOrdinal ;

  pByte += offset ;                            // pResName based of off pNE

  while ( ( cbSize = *pByte ) &&               // cbSize = length of following
          ( cbSize != 0 ) )                    //   API name.  Length of 0 means EOT
  {
    ENTRYPOINT *ep = MakeEntryPointElement() ; // add new entry...

    // pByte+1 for cbSize chars is name
    ep->pszAPIName = pByte+1 ;
    ep->wAPIOrdinal = INVALID_VALUE ;
    ep->wSegmentNumber = INVALID_VALUE ;
    ep->wOffset = INVALID_VALUE ;

    pByte++ ;          // skip length byte
    pByte += cbSize ;  // skip n chars

    pOrdinal = (int *) pByte ; // convert byte pointer to word pointer
    ordinal = *pOrdinal ;
    ep->wAPIOrdinal = ordinal ;
    *(pByte) = '\0' ; // Null-terminate name (ordinal saved already)
//DebugString( ep->pszAPIName ) ;          // DEBUG!
//DebugInt( ep->wAPIOrdinal ) ;            // DEBUG!
    pByte += 2 ;      // skip ordinal
  }

  return(TRUE) ;
}

// build elements for non-resident names table on our entry list
//   The first element is the description from the .DEF file
BOOL BuildNonResidentNamesTable()
{
  char *pByte = (char *) pBuffer ; // N.B., based off of start of EXE!
  int  offset = pNE->pNRes ;
  char cbSize ;
  int  ordinal, *pOrdinal ;

  pByte += offset ;                // based off of start of MZ header

  while ( ( cbSize = *pByte ) &&
          ( cbSize != 0 ) )
  {
    ENTRYPOINT *ep = MakeEntryPointElement() ; // add new entry...

    // pByte+1 for cbSize chars is name
    ep->pszAPIName = pByte+1 ;
    ep->wAPIOrdinal = INVALID_VALUE ;
    ep->wSegmentNumber = INVALID_VALUE ;
    ep->wOffset = INVALID_VALUE ;

    pByte++ ;         // skip length byte
    pByte += cbSize ; // skip n chars

    pOrdinal = (int *) pByte ; // convert byte pointer to word pointer
    ordinal = *pOrdinal ;
    ep->wAPIOrdinal = ordinal ;
    *(pByte) = '\0' ; // Null-terminate name (ordinal saved already)
//DebugString( ep->pszAPIName ) ;          // DEBUG!
//DebugInt( ep->wAPIOrdinal ) ;            // DEBUG!
    pByte += 2 ;      // skip ordinal
  }

  return(TRUE) ;
}

// builds entire segment table at once (as an array of segment entries).
BOOL BuildSegmentTable()
{
  char *pByte = (char *) pNE ;
  UINT cbSegs = pNE->cbSegment ;          // no. of segments in executable
  UINT offset = pNE->pSegment ;           // offset to segment table
  SEGMENT *tmpsp ;
  UINT w ;

  // global variable -- allocate space for segment table
  pSegmentHead = mymalloc( sizeof( SEGMENT ) * cbSegs ) ;

  pByte += offset ;    // based on start of pNE

  for (w=0;w< cbSegs ; w++ )
  {
     tmpsp = (SEGMENT *) pByte ;
     pSegmentHead[w] = *tmpsp ;        // wth element of the list is segno w+1
     pByte += 8 ;                      // advance to next elt in segment table

// DebugInt( tmpsp->offset ) ;            // DEBUG!
// DebugInt( tmpsp->len ) ;               // DEBUG!
// DebugInt( tmpsp->flags ) ;             // DEBUG!
// DebugInt( tmpsp->minsize ) ;           // DEBUG!
  }

  return(TRUE) ;
}

// fills in our entry table list from the entry table in the NE.  This is
//   where an api name or ordinal is associated with an actual segment
//   number and offset
BOOL BuildEntryTable()
{
  char CountOfRecords, FixedMoveable ;
  char * pByte ;
  WORD BytesRead = 0 ;
  WORD ThisEntry = 0 ; // entrypoints start with 1, will be incremented below
  ENTRYPOINT* ep ;
  ENTRYTABLE* et ;
  ETMOVEABLE* etm ;
  ETFIXED*    etf ;
  char flags, segno ;
  WORD offset ;

  pByte = (char *) pNE + pNE->pEntry ;

  while ( BytesRead < pNE->cbEntry ) 	
  {
    et = (ENTRYTABLE *) pByte ;
    CountOfRecords = et->CountOfRecords ;
    FixedMoveable = et->FixedMoveable ;
    pByte += 2 ;
    BytesRead += 2 ;

//  myprintfFormatInt( "Count of Records:  %X\n", CountOfRecords ) ;
    //  first, stop if count of records is 0...
    if ( 0 == CountOfRecords )
    {
       return ( TRUE ) ;
    }

    // second, we may have empty entries in the table (as the linker
    //   tries to compact the entry table).  For example write.exe
    //   has ordinals 1-4, but not 5-7, 8-11 but not 12-14.  Each
    //   of these bundles is followed by a byte which is the
    //   number of ordinals to skip.  The VGA driver (VGA.DRV) with
    //   my copy of Win31 has lots of these!
    if ( (char) 0x0 == FixedMoveable )
    {
// as CountOfRecords is signed, convert it to unsigned here so
//   sign extension won't be done before addition below
      unsigned char SkipCount = CountOfRecords ;
      ThisEntry += SkipCount ;             // skip these entries in the entry table...
                                           // skip mysterious 03 00
                                           //   after bundles in write.exe
      continue ;
    }

    // otherwise, process normal segment
    if ( (char) 0xFF == FixedMoveable) // is this segment fixed or moveable?
    {
       // moveable

//     myprintfFormatInt( "MOVEABLE:  %X\n", FixedMoveable ) ;

       while ( CountOfRecords-- )
       {
         etm = (ETMOVEABLE *) pByte ;

         flags = etm->flags ;
         segno = etm->segno ;
    	   offset =  etm->offset ;
         ThisEntry += 1 ;

         ep = GetEntryPointElement( ThisEntry ) ;
         if ( ep )
         {
            ep->wSegmentNumber = (WORD) segno ;
            ep->wOffset = offset ;
         }
         else
         {  // couldn't find entry point for ThisEntry
            //   Exehdr outputs ordinals in decimal so we will, too!
            if (TRUE == bVerbose)
            {
              myprintfFormatInt( "MAPMAN:  No entry elt found for %d!\n", ThisEntry ) ;
            }
         }
    //	  wsprintf( string, "Entry:  %X, flags: %X, segno:  %X, offset: %X",
    //  			ThisEntry, flags, segno, offset ) ;

    	   pByte += 6 ;
         BytesRead += 6 ;

       }
    }
    else
    {  // fixed
//    myprintfFormatInt( "FIXED:  %X\n", FixedMoveable ) ;

      while ( CountOfRecords-- )
      {
        etf = (ETFIXED *) pByte ;

        flags = etf->flags ;
        segno = FixedMoveable ;
   	  offset =  etf->offset ;
     	  ThisEntry += 1 ;
        ep = GetEntryPointElement( ThisEntry ) ;
        if ( ep )
        {
           ep->wSegmentNumber = (WORD) segno ;
           ep->wOffset = offset ;
        }
        else
        {  // couldn't find entry point for ThisEntry
            //   Exehdr outputs ordinals in decimal so we will, too!
            if (TRUE == bVerbose)
            {
              myprintfFormatInt( "MAPMAN:  No entry elt found for %d!\n", ThisEntry ) ;
            }
        }
//       	 wsprintf( string, "Entry:  %X, flags: %X, segno:  %X, offset: %X",
//       			ThisEntry, flags,
//       			segno, offset ) ;

	     pByte += 3 ;
	     BytesRead += 3 ;
      }
    }

  }

  return(TRUE) ;
}

