#ifndef TEXTWINDOW_H
#define TEXTWINDOW_H

#include "basicwin.h"

class OleClientObj;

struct LRECT {
	long 	left;
	long	top;
	long	right;
	long	bottom;

};

extern char * TextWindowClass;

class DataTransfer;

class TextWindow : public BasicWindow {

protected:


int	width;
int	height;
int	Dirty;
int	PageWidth;
int	PageHeight;
int	CharWidth;
int	LineHeight;
int	FrameWidth;
int	bCapture;
UINT	SizeState;
long	xOrigin;
long	yOrigin;
LRECT	rctlMark;
LRECT	rctlObj;
POINT	pntMouse;
char	*spFileName;

OleClientObj	**oleObjList;
OleClientObj	*SelectedObject;
IStorage	* pIStg;
DataTransfer	*pDataObj;

int	nObjects;
int	nItems;
HBITMAP	hMarkRedraw;

LRESULT WMSize (HWND hWnd, WPARAM wParam, LPARAM lParam);
LRESULT WMCreate (HWND hWnd, WPARAM wParam, LPARAM lParam);
LRESULT WMPaint (HWND hWnd, WPARAM wParam, LPARAM lParam);
virtual LRESULT WndProc(HWND hWnd,UINT msg,WPARAM wParam, LPARAM lParam);
LRESULT WMLButtonDown(HWND hWnd,WPARAM wParam,LPARAM lParam);
LRESULT WMLButtonDblClick(HWND hWnd,WPARAM wParam,LPARAM lParam);
LRESULT WMRButtonDown(HWND hWnd,WPARAM wParam,LPARAM lParam);
LRESULT WMLButtonUp(HWND hWnd, WPARAM wParam, LPARAM lParam);
LRESULT WMMouseMove(HWND hWnd, WPARAM wParam, LPARAM lParam);
LRESULT WMCommand (HWND hWnd, WPARAM wParam, LPARAM lParam);

void InitiateResize(long x,long y);
void ResizeFrame(int x, int y);
void DrawSizeFrame();
OleClientObj * FindSelectedObject(long xpos,long ypos,LRECT& rctlSel);

void EraseMarker();
void EraseMarker(HDC hDC);
void DrawMarker();
void DrawMarker(HDC hDC);
void MoveMarker(long x,long y);

void AddObject(OleClientObj *obj);
void FrameObject(OleClientObj *obj);
void SelectAnObject(OleClientObj *obj);
void FrameObject(HDC hDC,OleClientObj *obj);
void RemoveFrame(OleClientObj *obj);
void SizeCursor(int x, int y);
void ShowCursor();
void WriteObjectInfo();

void ReleaseStorage();
void OpenStorage();

void GetCursorPos(long& x, long& y);
BOOL IsVisible(RECT& rct);
OleClientObj * GetSelectedObject();

public:

TextWindow(BasicWindow *Aparent);
virtual ~TextWindow();
void NewFile();
BOOL LoadFile(char *spFile);
BOOL Save();
BOOL SaveAs(char *spFile);
inline long GetXLocation() {return (rctlMark.left + rctlMark.right)/2;};
inline long GetYLocation() {return (rctlMark.top + rctlMark.bottom)/2;};
inline BOOL IsObjectSelected() {return (SelectedObject != NULL);};
BOOL  Create();
void Resize (int new_width,int new_height);
inline BOOL IsDirty() {return Dirty;};
inline void SetDirty() {Dirty = 1;};
void InsertObject(CLSID& clsidObj);
void DeleteSelectedObject();
void CopyToClipboard();
void CutToClipboard();
HMENU CreateObjectMenu (UINT idStart);
void ProcessMenuCommand(UINT idStart,UINT idCommand);
void Redraw(LRECT& rctlDraw);
void DeleteOleObject(OleClientObj *obj);
void PasteObject();
BOOL CreateFromData(IDataObject *pIData,long x,long y);
LRESULT HScroll (HWND hWnd,WPARAM wParam, LPARAM lParam);
LRESULT VScroll (HWND hWnd,WPARAM wParam, LPARAM lParam);
void ConvertLongRectToPixels(LRECT& rctLong,RECT& rctPix);
void SetFilename(const char *spFile);
inline char * GetFilename() {return spFileName;};

};

#endif