#include <windows.h>
#include <ole2.h>
#include <values.h>
#include <stdlib.h>

#include "textwin.h"
#include "oleobj.h"
#include "dataobj.h"
#include "wdres.h"
#include "gdiobj.h"

#include "debug.h"

const	char OBJ_LIST[] = "ObjectList";  // Name of Object List Stream
const	int PageWidthInch = 85; //Page Width in tenths of an inch
const	int PageHeightInch = 110; //Page Height in tenths of an inch
const   int MarkDim = 16; // size of mark bitmap
const	int ID_OBJSTART = 500; // starting id of the ole verbs menu items


const UINT  SZ_NONE = 0;
const UINT  SZ_EAST = 1;
const UINT  SZ_WEST = 2;
const UINT  SZ_NORTH = SZ_EAST << 4;
const UINT  SZ_SOUTH = SZ_WEST << 4;
const UINT  SZ_SW = SZ_SOUTH | SZ_WEST;
const UINT  SZ_SE = SZ_SOUTH | SZ_EAST;
const UINT  SZ_NW = SZ_NORTH | SZ_WEST;
const UINT  SZ_NE = SZ_NORTH | SZ_EAST;


TextWindow::TextWindow(BasicWindow *Aparent)
 : BasicWindow (Aparent)
{
	HDC	hDC;
        long	lWord;

        spFileName = NULL;
	height = 10;
	width = 10;
	Dirty = FALSE;
        hDC = GetDC(NULL);
	PageWidth = (PageWidthInch * GetDeviceCaps(hDC,LOGPIXELSX))/10;
	PageHeight = (PageHeightInch * GetDeviceCaps(hDC,LOGPIXELSY))/10;
	ReleaseDC(NULL,hDC);
	lWord = GetDialogBaseUnits();
	CharWidth = LOWORD(lWord);
	LineHeight = HIWORD(lWord);
        FrameWidth = CharWidth/2;
	xOrigin = 0;
	yOrigin = 0;
	rctlMark.left = 0;
	rctlMark.top = 0;
	rctlMark.right = MarkDim;
	rctlMark.bottom = MarkDim;
	hMarkRedraw = NULL;

	nObjects = 0;
	nItems = 0;
	oleObjList = NULL;
	SelectedObject = NULL;
	SizeState = SZ_NONE;
	bCapture = FALSE;
        pDataObj = NULL;
}

TextWindow::~TextWindow()
{
	if (pDataObj && (OleIsCurrentClipboard(pDataObj) == S_OK)) {
		OleFlushClipboard();
        }
	for (int i=0; i<nObjects; i++) {
		delete oleObjList[i];
	}
	free (oleObjList);

	if (hMarkRedraw)DeleteObject(hMarkRedraw);
	if (pIStg) pIStg->Release();
        if (spFileName) delete [] spFileName;
}

void TextWindow::NewFile()
{
	int	i;
	HCURSOR	hSaveCursor;
        HWND	hParent;

        hParent = GetParent(hWindow);
        hSaveCursor = SetCursor(hWaitCursor);
	EraseMarker();
	for (i=0; i<nObjects; i++) {
		delete oleObjList[i];
	}
	free (oleObjList);
	oleObjList = NULL;
	nObjects = 0;
	SelectedObject = NULL;
        xOrigin = 0; yOrigin = 0;
	if (pIStg) pIStg -> Release();
	pIStg = NULL;
        SizeState = SZ_NONE;
	MoveMarker(0,0);
	Dirty = 0;
	SetScrollPos (hParent,SB_HORZ,0,TRUE);
	SetScrollPos (hParent,SB_VERT,0,TRUE);
        SetCursor(hSaveCursor);

}

BOOL TextWindow::LoadFile(char *spFile)
{
      HRESULT		hrr;
      char		*spMess;
      char		message[150];
      CLSID		clsid;
      IStream		*pIObjLst;
      char		spObject[10];
      OleClientObj	*pObj;
      HCURSOR		hSaveCursor;

      static MSGLIST	Messages[] = {
	{"File does not exist", STG_E_FILENOTFOUND},
	{"Access Denied", 	STG_E_ACCESSDENIED},
	{"Not a valid Collage File", STG_E_FILEALREADYEXISTS},
	{"Too Many Open Files",	STG_E_TOOMANYOPENFILES},
	{NULL,			0}
      };

      hSaveCursor = SetCursor(hWaitCursor);
      hrr = StgOpenStorage(spFile,NULL,STGM_TRANSACTED|STGM_READWRITE|STGM_SHARE_EXCLUSIVE,
	NULL,0,&pIStg);
      if (FAILED(hrr)) {
      	 SetCursor(hSaveCursor);
	 spMess = GetErrorMessage(GetScode(hrr),Messages);
	 if (spMess) 
		wsprintf(message,"Could not Open File %s - %s",spFile,spMess);
	 else
		wsprintf(message, "Could not Open File %s",spFile);

	 MessageBox(NULL,message,"Error",MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION);

	 return FALSE;
      }

      ReadClassStg(pIStg,&clsid);
      if (!(clsid == CLSID_Collage)) {
      	SetCursor(hSaveCursor);
      	wsprintf (message,"%s is not a valid Collage File",spFile);
	MessageBox(NULL,message,"Error", MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION);
	pIStg -> Release();
        pIStg = NULL;
        return FALSE;
      }

      hrr = pIStg -> OpenStream(OBJ_LIST,0,STGM_DIRECT|STGM_READ|STGM_SHARE_EXCLUSIVE,
	0, &pIObjLst);

      if (FAILED(hrr)) {
      		SetCursor(hSaveCursor);
		MessageBox(NULL,"Could Not Read File","Error",MB_OK|MB_APPLMODAL|
			MB_ICONSTOP);
		pIStg->Release();
                pIStg = NULL;
		return FALSE;
      }
      do {
	pIObjLst->Read(spObject,10,NULL);
	if (*spObject != '\0') {
		pObj = new OleClientObj (pIStg,spObject,this);
		if (pObj->IsValid()) {
			AddObject(pObj);
		}
		else
                	delete pObj;
        }
      } while (*spObject) ;

      pIObjLst -> Release();

      SetCursor (hSaveCursor);
      return TRUE;
}


BOOL TextWindow::Save()
{
	HCURSOR		hSaveCursor;

        hSaveCursor = SetCursor(hWaitCursor);
	WriteObjectInfo();
	pIStg -> Commit(STGC_DEFAULT);
	Dirty = 0;
        SetCursor(hSaveCursor);

        return TRUE;
}


BOOL TextWindow::SaveAs(char *spFile)
{
	HRESULT		herr;
	char		mess[100];
	IStorage	*pINewStg;
        HCURSOR		hSaveCursor;

        hSaveCursor = SetCursor(hWaitCursor);
	herr = StgCreateDocfile(spFile,STGM_TRANSACTED|STGM_CREATE|STGM_READWRITE|STGM_SHARE_EXCLUSIVE,
		0,&pINewStg);

	if (FAILED(herr)) {
		wsprintf(mess,"Could not save file %s",spFile);
		MessageBox(NULL, mess, "ERROR", MB_OK|MB_APPLMODAL|
                	MB_ICONEXCLAMATION) ;
		return FALSE;
	}

	pIStg->CopyTo(NULL,NULL,NULL,pINewStg);
        ReleaseStorage();
	pIStg -> Release();
	pIStg = pINewStg;
        WriteObjectInfo();
	pIStg -> Commit(STGC_ONLYIFCURRENT);
	OpenStorage();
	Dirty = 0;
        SetCursor(hSaveCursor);

	return TRUE;
}

void TextWindow::CopyToClipboard()
{
	DataTransfer	*pNewDataObj;

	if (SelectedObject) {
		pNewDataObj = new DataTransfer(SelectedObject,spFileName);
                pNewDataObj -> AddRef();
		if (pNewDataObj->IsValid()) {
		     OleSetClipboard(pNewDataObj);
		     pDataObj = pNewDataObj;
		}
		pNewDataObj->Release();
	}
}

void TextWindow::CutToClipboard()
{
	if (SelectedObject) {
		CopyToClipboard();
		DeleteSelectedObject();
	}
}

void TextWindow::WriteObjectInfo()
{
	IStream		*pIObjStr;
	char		*spObj;
	int		i;
	HRESULT		hrr;
        char		null = '\0';

	pIStg -> SetClass(CLSID_Collage);
	hrr = pIStg -> OpenStream(OBJ_LIST, 0,
		STGM_DIRECT|STGM_CREATE|STGM_READWRITE|STGM_SHARE_EXCLUSIVE,
		0, &pIObjStr);
	if (FAILED(hrr)) {
		pIStg -> CreateStream(OBJ_LIST,STGM_DIRECT|STGM_READWRITE|
			STGM_SHARE_EXCLUSIVE,0,0,&pIObjStr);
	}
	for (i=0; i<nObjects; i++) {
		spObj = oleObjList[i]->GetStorageName();
		pIObjStr -> Write(spObj,lstrlen(spObj)+1,NULL);
	}
        pIObjStr -> Write(&null,1,NULL);
	pIObjStr -> Release();
}

void TextWindow::ReleaseStorage()
{
	for (int i=0; i<nObjects; i++) {
		oleObjList[i]->ReleaseStorage();
	}
}

void TextWindow::OpenStorage()
{
	for (int i=0; i<nObjects; i++) {
		oleObjList[i]->OpenStorage(pIStg);
	}
}

HMENU TextWindow::CreateObjectMenu (UINT idStart)
{
	if (SelectedObject) 
		return SelectedObject->CreateEditMenu(idStart);
	else
		return NULL;
}


void TextWindow::InsertObject(CLSID& clsidObj)
{
	HRESULT		hErr;
	OleClientObj	*pObj;
        HCURSOR		hSaveCursor;

        hSaveCursor = SetCursor(hWaitCursor);
	nItems++;
	pObj = new OleClientObj(this,(LPSTORAGE)pIStg,nItems,clsidObj,
		GetXLocation(),GetYLocation());
	if (pObj->IsValid()) {
		AddObject(pObj);
                pObj->SetFilename(spFileName);
		SelectAnObject(pObj);
		pObj->Activate(OLEIVERB_SHOW);
                SetCursor(hSaveCursor);
	}
	else {
		SetCursor(hSaveCursor);
		delete pObj;
                MessageBox (NULL,"Could Not Create Object","Error",
		    MB_OK|MB_ICONSTOP|MB_APPLMODAL);
	}

}

void TextWindow::PasteObject()
{
	OleClientObj	*OldObj;

	IDataObject	*pIData;
        LRECT		*rctlSObj;
	long		x,y;


	OldObj = SelectedObject;
	OleGetClipboard(&pIData);
	if (pIData == NULL) return;

	if (SelectedObject) {
		rctlSObj = SelectedObject->GetClientRect();
		x = rctlSObj->left;
		y = rctlSObj->top;
	}
	else {
		x = GetXLocation();
		y = GetYLocation();
        }


	if (CreateFromData(pIData,x,y) && OldObj)
		DeleteOleObject(OldObj);

	if (SelectedObject) Redraw(*(SelectedObject->GetClientRect()));
}

BOOL TextWindow::CreateFromData(IDataObject *pIData,long x,long y)
{
	OleClientObj	*pObj;
	nItems++;


	pObj = new OleClientObj(pIStg,nItems,x,y,pIData,this);
	if (pObj->IsValid()) {
		AddObject(pObj);
		pObj -> SetFilename(spFileName);
		SelectAnObject(pObj);

	}
	else {
		delete pObj;
                MessageBox (NULL,"Could Not Create Object","Error",
		    MB_OK|MB_ICONSTOP|MB_APPLMODAL);
	}

        return TRUE;
}

        

void TextWindow::Redraw(LRECT& rctlDraw)
{
	RECT	rctObj;

	ConvertLongRectToPixels(rctlDraw,rctObj);
	rctObj.left -= FrameWidth;
	rctObj.right += FrameWidth;
	rctObj.top -= FrameWidth;
	rctObj.bottom += FrameWidth;

	InvalidateRect(hWindow,&rctObj,TRUE);
}

void TextWindow::AddObject(OleClientObj *obj)
{
	nObjects ++;
	oleObjList = (OleClientObj **)realloc(oleObjList,nObjects*sizeof(OleClientObj *));
        oleObjList[nObjects-1] = obj;
}

void TextWindow::DeleteSelectedObject()
{
	DeleteOleObject(SelectedObject);
}

void TextWindow::DeleteOleObject(OleClientObj *obj)
{
	int	idx;
	char	szObjName[80];
        RECT	rctObj;

	if (obj == NULL) return;
        ConvertLongRectToPixels(*obj->GetClientRect(),rctObj);

	for (idx=0; idx < nObjects; idx++) {
		if (oleObjList[idx] == obj) break;
	}
        nObjects--;
	for (int i = idx; i<nObjects; i++) {
		oleObjList[i] = oleObjList[i+1];
	}
	oleObjList = (OleClientObj **)realloc(oleObjList,nObjects*sizeof(OleClientObj *));
        lstrcpy(szObjName,obj->GetStorageName());
	delete obj;

	pIStg -> DestroyElement(szObjName);
	InvalidateRect(hWindow,&rctObj,TRUE);
	if (obj == SelectedObject) {
		SelectedObject = NULL;
		MoveMarker(rctObj.left+xOrigin,rctObj.top+yOrigin);
        }
}
	                	

void TextWindow::FrameObject(OleClientObj *obj)
{
	HDC 	hDC = GetDC(hWindow);
	FrameObject(hDC,obj);
	ReleaseDC(hWindow,hDC);
}

void TextWindow::FrameObject(HDC hDC,OleClientObj *obj)
{
	LRECT 	*p_rctlObj;
	HRGN	 hRgn;
	HBRUSH  hBr;
        RECT	rctObj;

	p_rctlObj = obj->GetClientRect();
	ConvertLongRectToPixels(*p_rctlObj,rctObj);
	hRgn = CreateRectRgnIndirect(&rctObj);
	hBr = (HBRUSH)GetStockObject(GRAY_BRUSH);
	FrameRgn(hDC,hRgn,hBr,FrameWidth,FrameWidth);
	DeleteObject(hRgn);
}

void TextWindow::RemoveFrame(OleClientObj *obj)
{
	RECT	rct;

	ConvertLongRectToPixels(*obj->GetClientRect(),rct);
        InflateRect(&rct,FrameWidth,FrameWidth);
	if (IsVisible(rct)) {
		InvalidateRect(hWindow,&rct,TRUE);
	}
}
        	

void TextWindow::SizeCursor(int x, int y)
{
	RECT	rctObj;
        UINT	yDir,xDir;

	if (GetSelectedObject() == NULL) {
		SizeState = SZ_NONE;
                return;
	}
	ConvertLongRectToPixels(*(GetSelectedObject()->GetClientRect()),rctObj);
//
// if point lays outside object frame rectangle then discard
//
	if ((y < rctObj.top - FrameWidth) || (y > rctObj.bottom + FrameWidth) ||
	    (x < rctObj.left - FrameWidth)|| (x > rctObj.right + FrameWidth)) {
		SizeState = SZ_NONE;
		return;
	}
//
// if point lays inside frame rectangle then also discard
//
	if ((y > rctObj.top) && (y < rctObj.bottom) && (x > rctObj.left) && (x < rctObj.right)) {
		SizeState = SZ_NONE;
		return;
	}

// by process of elimination point must lie within frame rectangle

	if (y < rctObj.top + LineHeight) 
		yDir = SZ_NORTH;
	else if ( y > rctObj.bottom - LineHeight)
		yDir = SZ_SOUTH;
	else
		yDir = SZ_NONE;

	if (x < rctObj.left + LineHeight)
		xDir = SZ_WEST;
	else if (x > rctObj.right - LineHeight)
		xDir = SZ_EAST;
	else
		xDir = SZ_NONE;

	SizeState = xDir | yDir;
}

void TextWindow::ShowCursor()
{
	switch (SizeState) {

	case SZ_NONE:
		SetCursor(hPlain);
		break;
	case SZ_NORTH:
	case SZ_SOUTH:
		SetCursor(hVertArrow);
		break;
	case SZ_EAST:
	case SZ_WEST:
		SetCursor(hHorizArrow);
		break;
	case SZ_NW:
	case SZ_SE:
		SetCursor(hNwArrow);
		break;
	case SZ_NE:
	case SZ_SW:
		SetCursor(hSwArrow);
		break;
	}
}
        	
BOOL TextWindow::Create()
{
	HRESULT 	hErr;
	char		message[100];
	static MSGLIST	ErrMessage[] = {
		{"Access Denied", STG_E_ACCESSDENIED},
		{"File Already Exists", STG_E_FILEALREADYEXISTS},
		{"Out of Memeory", STG_E_INSUFFICIENTMEMORY},
		{"Invalid Name", STG_E_INVALIDNAME},
		{"Invalid Pointer", STG_E_INVALIDPOINTER},
		{"Invalid Flags", STG_E_INVALIDFLAG},
		{"Too Many Open Files",STG_E_TOOMANYOPENFILES},
                {NULL, 0 }
        };

	CreateWindow (TextWindowClass,NULL,WS_CHILDWINDOW|WS_VISIBLE,0,0,width,height,
		pParent->GetWindow(),NULL,hInst,(LPSTR)this);

	hErr = StgCreateDocfile(NULL,STGM_TRANSACTED | STGM_READWRITE
            | STGM_CREATE | STGM_DELETEONRELEASE
	    | STGM_SHARE_EXCLUSIVE,0,&pIStg);
	if (FAILED(hErr)) {
        	wsprintf (message,"Could No Open Temp File - %s",GetErrorMessage(GetScode(hErr),ErrMessage));
		MessageBox(NULL,message,"FATAL ERROR",MB_APPLMODAL|MB_OK|MB_ICONSTOP);
		return FALSE;
	}
        return TRUE;

}


void TextWindow::GetCursorPos(long& x, long& y)
{
	x = (rctlMark.right + rctlMark.left)/2;
	y = (rctlMark.top + rctlMark.bottom)/2;
}

void TextWindow::Resize (int new_width,int new_height)
{
	if ((new_width != width) || (new_height != height)) {
		MoveWindow (hWindow,0,0,new_width,new_height,TRUE);
	}
}

LRESULT TextWindow::WMCreate (HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	hWindow = hWnd;
	return 0;
}

LRESULT TextWindow::WMSize (HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	width = LOWORD (lParam);
	height = HIWORD (lParam);
	SetScrollRange(pParent->hWindow,SB_HORZ,0,PageWidth/CharWidth,TRUE);
        SetScrollRange(pParent->hWindow,SB_VERT,0,PageHeight/LineHeight,TRUE);

	return 0;
}

LRESULT TextWindow::WMPaint (HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT		ps;

	HDC hDC = BeginPaint(hWnd, &ps);
	EraseMarker();

	for (int i=0; i<nObjects; i++) {
		oleObjList[i]->Draw(hDC);
	}

	if (GetSelectedObject())
		FrameObject(hDC,GetSelectedObject());
        else
	        DrawMarker();

	EndPaint (hWnd, &ps);

	return 0;
}

// HScroll Method is called from the Main Window Processing
LRESULT TextWindow::HScroll (HWND hWnd,WPARAM wParam, LPARAM lParam)
{
	long	xOriginOld;

        UpdateWindow(hWindow);

	xOriginOld = xOrigin;
        EraseMarker();

	switch (wParam) {

	case SB_BOTTOM:
	      xOrigin = PageWidth;
              break;

	case SB_LINEDOWN:
	      xOrigin += CharWidth;
              if (xOrigin > PageWidth) xOrigin = PageWidth;
              break;

	case SB_LINEUP:
	      xOrigin -= CharWidth;
	      if (xOrigin < 0) xOrigin = 0;
              break;

	case SB_PAGEDOWN:
	      xOrigin += width;
	      if (xOrigin > PageWidth) xOrigin = PageWidth;
              break;

	case SB_PAGEUP:
	      xOrigin -= width;
	      if (xOrigin < 0) xOrigin = 0;
              break;

	case SB_TOP:
	      xOrigin = 0;
              break;

	case SB_THUMBPOSITION:
	      xOrigin = LOWORD(lParam) * CharWidth;
              break;
	}
        if (xOrigin != xOriginOld) {
		ScrollWindow(hWindow,xOriginOld-xOrigin,0,NULL,NULL);
		SetScrollPos(hWnd,SB_HORZ,xOrigin/CharWidth,TRUE);
	}
        if (GetSelectedObject() == NULL)
        	DrawMarker();

	return 0;
}

// VScroll Method is called from the Main Window Processing
LRESULT TextWindow::VScroll (HWND hWnd,WPARAM wParam, LPARAM lParam)
{
	long	yOriginOld;

	UpdateWindow(hWindow);

	yOriginOld = yOrigin;
        EraseMarker();

	switch (wParam) {

	case SB_BOTTOM:
	      yOrigin = PageHeight;
              break;

	case SB_LINEDOWN:
	      yOrigin += LineHeight;
              if (yOrigin > PageHeight) yOrigin = PageHeight;
              break;

	case SB_LINEUP:
	      yOrigin -= LineHeight;
	      if (yOrigin < 0) yOrigin = 0;
              break;

	case SB_PAGEDOWN:
	      yOrigin += height;
	      if (yOrigin > PageHeight) yOrigin = PageHeight;
              break;

	case SB_PAGEUP:
	      yOrigin -= height;
	      if (yOrigin < 0) yOrigin = 0;
              break;

	case SB_TOP:
	      yOrigin = 0;
              break;

	case SB_THUMBPOSITION:
	      yOrigin = LOWORD(lParam)*LineHeight;
              break;

	}
	if (yOrigin != yOriginOld) {
		SetScrollPos(hWnd,SB_VERT,yOrigin/LineHeight,TRUE);
		ScrollWindow(hWindow,0,yOriginOld-yOrigin,NULL,NULL);
	}
        if (GetSelectedObject() == NULL)
		DrawMarker();

	return 0;
}

LRESULT TextWindow::WMLButtonDown(HWND hWnd,WPARAM wParam,LPARAM lParam)
{
	int	x,y;
	long	xpos,ypos;
        LRECT	rctlObj;
        OleClientObj	*NewSelectedObj;

	x = LOWORD(lParam);
	y = HIWORD(lParam);

	xpos = x + xOrigin;
	ypos = y + yOrigin;

        NewSelectedObj = NULL;

	if (SizeState == SZ_NONE) {
        	NewSelectedObj = FindSelectedObject(xpos,ypos,rctlObj);
	}
	else {
		NewSelectedObj = SelectedObject;
	}

	if (NewSelectedObj != SelectedObject) {
        	SizeState = SZ_NONE;
		if (GetSelectedObject()) {
                	FPRINTF (debug,"Button Down - Remove Frame\n");
			RemoveFrame(SelectedObject);
                        }
		else {
                	FPRINTF (debug,"Button Down - Erase Marker\n");
			EraseMarker();
		}

		SelectedObject = NewSelectedObj;

		if (GetSelectedObject()) {
                	FPRINTF (debug, "Button Down - Frame Object\n");
			FrameObject(SelectedObject);
                        InitiateResize(xpos,ypos);
                }
		else {
                	FPRINTF (debug, "Button Down - Move Marker\n");
			MoveMarker(xpos,ypos);
                }
	}
	else if (GetSelectedObject() == NULL) {
        	FPRINTF (debug, "Button Down - Move Marker (NULL Object)\n");
		MoveMarker(xpos,ypos);
	}
	else {
		InitiateResize(xpos,ypos);
        }
        	
	ShowCursor();
        return 0;
}

LRESULT TextWindow::WMLButtonDblClick(HWND hWnd,WPARAM wParam,LPARAM lParam)
{
	if (GetSelectedObject()) {
		GetSelectedObject()->Activate(OLEIVERB_PRIMARY);
	}
        return 0;
}

LRESULT TextWindow::WMRButtonDown(HWND hWnd,WPARAM wParam,LPARAM lParam)
{
	int	x,y;
	long	xpos,ypos;
        LRECT	rctlObj;
	OleClientObj	*NewSelectedObj;
        HMENU	hMenu;

	x = LOWORD(lParam);
	y = HIWORD(lParam);

	xpos = x + xOrigin;
	ypos = y + yOrigin;

	NewSelectedObj = FindSelectedObject(xpos,ypos,rctlObj);

	SizeState = SZ_NONE;
        if (SelectedObject != NewSelectedObj) {
		if (GetSelectedObject()) {
        	       	FPRINTF (debug,"Button Down - Remove Frame\n");
			RemoveFrame(SelectedObject);
	        }
		else {
        	       	FPRINTF (debug,"Button Down - Erase Marker\n");
			EraseMarker();
		}
		SelectedObject = NewSelectedObj;

		if (SelectedObject) {
			FrameObject(SelectedObject);
		}
		else {
			MoveMarker(xpos,ypos);
		}
	}
	if (SelectedObject) {
		hMenu = SelectedObject->CreateEditMenu(ID_OBJSTART);
		if (hMenu) {
			UpdateWindow(hWindow);
			POINT	pnt;
			pnt.x = x; pnt.y = y;
                        ClientToScreen(hWindow,&pnt);
			TrackPopupMenu(hMenu,TPM_CENTERALIGN|TPM_RIGHTBUTTON,
				pnt.x,pnt.y,0,hWindow,NULL);
			DestroyMenu(hMenu);
                }
	}

        return 0;
}


OleClientObj * TextWindow::FindSelectedObject(long xpos,long ypos,LRECT& rctlSel)
{
	OleClientObj	*NewSelectedObj = NULL;

	for (int i=0; i<nObjects; i++) {
	    rctlSel = *(oleObjList[i]->GetClientRect());
	    if ((xpos >= rctlSel.left) && (xpos <= rctlSel.right) &&
		(ypos >= rctlSel.top) && (ypos <= rctlSel.bottom)) {
			NewSelectedObj = oleObjList[i];
			break;
	    }
	}
	return NewSelectedObj;
}


void TextWindow::InitiateResize(long x,long y)
{
	pntMouse.x = x - xOrigin;
	pntMouse.y = y - yOrigin;
	rctlObj = *(SelectedObject->GetClientRect());
	SetCapture(hWindow);
	bCapture = TRUE;
	DrawSizeFrame();
}

void TextWindow::ResizeFrame(int x, int y)
{
	int	dx,dy;

	dx = x - pntMouse.x;
	dy = y - pntMouse.y;
	pntMouse.x = x;
	pntMouse.y = y;
        DrawSizeFrame();

	if (SizeState == SZ_NONE) {
		rctlObj.left += dx;
		rctlObj.right += dx;
		rctlObj.top += dy;
		rctlObj.bottom += dy;
		if (rctlObj.left < 0) {
			rctlObj.right -= rctlObj.left;
			rctlObj.left = 0;
		}
		if (rctlObj.right > PageWidth) {
			rctlObj.left -= rctlObj.right - PageWidth;
			rctlObj.right = PageWidth;
		}
		if (rctlObj.top < 0) {
			rctlObj.bottom -= rctlObj.top;
			rctlObj.top = 0;
		}
		if (rctlObj.bottom > PageHeight) {
			rctlObj.top -= rctlObj.bottom - PageHeight;
			rctlObj.bottom = PageHeight;
		}
	}
	else {
		if (SizeState & SZ_EAST) {
			rctlObj.right += dx;
			if (rctlObj.right > PageWidth)rctlObj.right = PageWidth;
			if (rctlObj.right < rctlObj.left +10) rctlObj.right = rctlObj.left + 10;
                }
		if (SizeState & SZ_WEST) {
			rctlObj.left += dx;
			if (rctlObj.left < 0) rctlObj.left = 0;
			if (rctlObj.left > rctlObj.right - 10) rctlObj.left = rctlObj.right - 10;
                }
		if (SizeState & SZ_NORTH) {
			rctlObj.top += dy;
			if (rctlObj.top < 0) rctlObj.top = 0;
			if (rctlObj.top > rctlObj.bottom - 10)rctlObj.top = rctlObj.bottom -10;
                }
		if (SizeState & SZ_SOUTH) {
			rctlObj.bottom += dy;
			if (rctlObj.bottom > PageHeight) rctlObj.bottom = PageHeight;
			if (rctlObj.bottom < rctlObj.top + 10) rctlObj.bottom = rctlObj.top + 10;
		}
	}
	DrawSizeFrame();
}

void TextWindow::DrawSizeFrame()
{
	HDC	hDC;
	RECT	rctObj;

	hDC = GetDC(hWindow);
	ConvertLongRectToPixels(rctlObj,rctObj);
	DrawFocusRect(hDC,&rctObj);
	ReleaseDC(hWindow,hDC);
}

        

LRESULT TextWindow::WMLButtonUp(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	RECT		rctObj;
	LRECT		rctlObj1;

	if (bCapture) {
        	DrawSizeFrame();
		ReleaseCapture();
		rctlObj1 = *(SelectedObject->GetClientRect());
		if ((rctlObj.left != rctlObj1.left) || (rctlObj.right != rctlObj1.right) ||
                    (rctlObj.top != rctlObj1.top) || (rctlObj.bottom != rctlObj1.bottom)) {
			ConvertLongRectToPixels(rctlObj1,rctObj);
			InvalidateRect(hWindow,&rctObj,TRUE);
			SelectedObject->SetClientRect(rctlObj);
			ConvertLongRectToPixels(rctlObj,rctObj);
			InvalidateRect(hWindow,&rctObj,TRUE);
		}
		bCapture = FALSE;
	}
        return 0;
}


LRESULT TextWindow::WMMouseMove(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	if (bCapture) {
		ResizeFrame(LOWORD(lParam),HIWORD(lParam));
        }
	else {
		SizeCursor(LOWORD(lParam),HIWORD(lParam));
	}
	ShowCursor();
        return 0;

}

LRESULT TextWindow::WMCommand (HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	ProcessMenuCommand(ID_OBJSTART,wParam);
        return 0;
}

void TextWindow::ProcessMenuCommand(UINT idStart,UINT idCommand)
{
	if ((SelectedObject != NULL) && (idCommand >= idStart)) {
		SelectedObject -> Activate(idCommand - idStart);
	}
}


void TextWindow::SelectAnObject(OleClientObj *obj)
{
	FPRINTF (debug, "Select an object called with obj %X:%X\n",HIWORD(obj),LOWORD(obj));
	if (GetSelectedObject()) {
		RemoveFrame(SelectedObject);
	}
	else {
		EraseMarker();
	}
	SelectedObject = obj;
        if (GetSelectedObject()) 
		FrameObject(SelectedObject);
	else
        	DrawMarker();
}

LRESULT TextWindow::WndProc(HWND hWnd,UINT msg,WPARAM wParam, LPARAM lParam)
{
	switch (msg) {

	case WM_CREATE:
		return WMCreate (hWnd, wParam, lParam);
	case WM_SIZE:
		return WMSize (hWnd, wParam, lParam);
	case WM_PAINT:
		return WMPaint(hWnd,wParam,lParam);
	case WM_LBUTTONDOWN:
		return WMLButtonDown(hWnd,wParam,lParam);
	case WM_LBUTTONDBLCLK:
		return WMLButtonDblClick(hWnd,wParam,lParam);
	case WM_RBUTTONDOWN:
        	return WMRButtonDown(hWnd,wParam,lParam);
	case WM_LBUTTONUP:
		return WMLButtonUp(hWnd,wParam,lParam);
	case WM_MOUSEMOVE:
		return WMMouseMove(hWnd,wParam,lParam);
	case WM_COMMAND:
		return WMCommand(hWnd, wParam,lParam);
	default:
		return DefWindowProc (hWnd,msg,wParam,lParam);
	}
}

void TextWindow::EraseMarker()
{
	HDC	hDC = GetDC(hWindow);
	EraseMarker(hDC);
	ReleaseDC(hWindow,hDC);
}

void TextWindow::EraseMarker(HDC hDC)
{
	HDC	hMem;
	RECT	rctMark;

	if (hMarkRedraw) {        	
                FPRINTF(debug,"Erase Marker: Marker Erased\n");
		hMem = CreateCompatibleDC(hDC);
		SelectObject(hMem,hMarkRedraw);
		ConvertLongRectToPixels(rctlMark,rctMark);
		BitBlt (hDC,rctMark.left,rctMark.top,rctMark.right-rctMark.left,
			rctMark.bottom-rctMark.top,hMem,0,0,SRCCOPY);
		DeleteDC(hMem);
		DeleteObject (hMarkRedraw);
		hMarkRedraw = NULL;

	}
}
void TextWindow::DrawMarker()
{
   HDC		hDC;

   hDC = GetDC(hWindow);
   DrawMarker(hDC);
   ReleaseDC(hWindow,hDC);
}

void TextWindow::DrawMarker(HDC hDC)
{
   HDC		hMem;
   RECT		rctMark;

   FPRINTF (debug,"DrawMarker: Marker Drawn\n");
   hMem	= CreateCompatibleDC(hDC);
   hMarkRedraw = CreateCompatibleBitmap(hDC,MarkDim,MarkDim);
   SelectObject(hMem,hMarkRedraw);
   ConvertLongRectToPixels(rctlMark,rctMark);
   BitBlt (hMem,0,0,MarkDim,MarkDim,hDC,rctMark.left,rctMark.top,SRCCOPY);

   SelectObject(hMem,hMarkBack);
   BitBlt (hDC,rctMark.left,rctMark.top,MarkDim,MarkDim,hMem,0,0,SRCAND);

   SelectObject(hMem,hMarkFore);
   BitBlt (hDC,rctMark.left,rctMark.top,MarkDim,MarkDim,hMem,0,0,SRCPAINT);

   DeleteDC(hMem);
}

void TextWindow::MoveMarker(long x,long y)
{
   HDC 	hDC = GetDC(hWindow);
   FPRINTF(debug,"MoveMarker: Move To (%ld,%ld)\n", x,y);
   EraseMarker(hDC);
   rctlMark.left = x - 8;
   rctlMark.right = x + 8;
   rctlMark.top = y - 8;
   rctlMark.bottom = y + 8;

   DrawMarker(hDC);
   ReleaseDC(hWindow,hDC);
}


void TextWindow::ConvertLongRectToPixels(LRECT& rctLong,RECT& rctPix)
{
      LRECT	rctlPix;

      rctlPix.top = rctLong.top - yOrigin;
      if (rctlPix.top > MAXINT) rctlPix.top = MAXINT;
      else if (rctlPix.top < -MAXINT) rctlPix.top = -MAXINT;

      
      rctlPix.bottom = rctLong.bottom - yOrigin;
      if (rctlPix.bottom > MAXINT) rctlPix.bottom = MAXINT;
      else if (rctlPix.bottom < -MAXINT) rctlPix.bottom = -MAXINT;


      rctlPix.left = rctLong.left - xOrigin;
      if (rctlPix.left > MAXINT) rctlPix.left = MAXINT;
      else if (rctlPix.left < -MAXINT) rctlPix.left = -MAXINT;


      rctlPix.right = rctLong.right - xOrigin;
      if (rctlPix.right > MAXINT) rctlPix.right = MAXINT;
      else if (rctlPix.right < -MAXINT) rctlPix.right = -MAXINT;

      rctPix.top = (int)rctlPix.top;
      rctPix.bottom = (int)rctlPix.bottom;
      rctPix.left = (int)rctlPix.left;
      rctPix.right = (int)rctlPix.right;

}

OleClientObj * TextWindow::GetSelectedObject()
{
	if (SelectedObject && SelectedObject->ContainsData())
		return SelectedObject;
	else
		return NULL;
};


BOOL TextWindow::IsVisible(RECT& rct)
{
	RECT	rctClient,rctResult;

	SetRect(&rctClient,0,0,width,height);
	return IntersectRect(&rctResult,&rctClient,&rct);
}

void TextWindow::SetFilename(const char *spFile)
{
	int	idx;

	if (spFileName) delete [] spFileName;
        spFileName = NULL;
        if (spFile) {
		spFileName = new char [lstrlen(spFile) + 1];
		lstrcpy(spFileName,spFile);
	}
	for (idx=0; idx < nObjects; idx++) {
                oleObjList[idx] -> SetFilename(spFileName);
	}
}



char * GetErrorMessage (SCODE	sc,MSGLIST *msg)
{

	char	*spMessage;
	MSGLIST *pMsg;
	static char spNull[] = "";

	pMsg = msg;
	while (pMsg->error && (pMsg -> scode != sc)) pMsg++;

        if (pMsg->error == NULL) return spNull;
	return pMsg->error;
}
