Dialog::Dialog(HWND hParent,HINSTANCE hInstance, UINT nDlg)
{
	hParentWin = hParent;
	hInst = hInstance;
	BaseDialog = BaseDlg;
}

Dialog::~Dialog()
{
}

BOOL Dialog::Dispatch(HWND hDlg,UINT msg, WPARAM wParam, LPARAM lParam)
{
	Dialog		*obj;

	if (msg == WM_INITDIALOG) {
		SetProp (hDlg,"OBJ_LO",LOWORD(lParam));
		SetProp (hDlg,"OBJ_HI",HIWORD(lParam));
	}
	obj = (Dialog *)MAKELONG(GetProp(hDlg,"OBJ_LO"),GetProp(hDlg,"OBJ_HI"));
	if (obj != NULL) {
		return obj -> WndProc (hDlg,msg,wParam,lParam);
	}
	return FALSE;
}

BOOL Dialog::Create()
{
	return DialogBoxParam(hInst,MAKEINTRESOURCE(BaseDialog),hParentWin,
		Dispatch,(DWORD)this);
}

OptionDialog::OptionDialog (HWND hParent, HINSTANCE hInstance,UINT BaseDlg,int nOptions)
	: Dialog (hParent,hInstance,BaseDialog)
{

	nOpt = nOptions;
	lpDlg = NULL;
	option = (int **)calloc(nOpt, sizeof(int *));
	CurrOption = -1;
}

OptionDialog::~OptionDialog()
{
	int		i;

	if (lpDlg) free (lpDlg);
	if (option) {
		for (i=0; i<nOpt; i++) {
			if (option[i]) free (option[i]);
		}
		free option;
	}
}

BOOL OptionDialog::Create()
{
	char					*lpDlg;
	LPDLGTEMPLATE		lpDlgHeader;
	LPDLGITEMTEMPLATE	lpItem;
	int					idx;
	RECT					rct;


	lpDlg = LoadDlgTemplate(BaseDialog,&dlgSize);
	if (lpDlg == NULL) return;
	lpDlgHeader = (LPDLGTEMPLATE)lpDlg;
//  Find the options box
	lpItem = FindFirstItem (lpDlgHeader);
	idx = 0;
	while ( lpItem->dtIID != IDC_OPTIONS) {
		idx ++;
		if (idx < lpDlgHeader->dtItemCount) break;
		lpItem = GetNextDlgItem(lpItem);
	}
	if (lpItem->dtIID == IDC_OPTIONS) {
		rct.left = lpItem->dtilX;
		rct.top = lpItem->dtilY;
		rct.right = rect.left + lpItem->dtilCX;
		rct.bottom = rect.top + lpItem->dtilCY;
		option[0] = GetOptions(rct,lpDlg,NULL,NULL);
		for (idx =1; idx < nOptions; idx++) {
			 lpOptDlg = LoadDlgTemplate(BaseDialog+idx,NULL);
			 if (lpOptDlg) {
				option[idx] = GetOptions(rct,lpOptDlg,&lpDlg,&dlgSize);
			 }
			 free (lpOptDlg);
		}
	}
	return DialogBoxIndirectParam (hInst,(HANDLE)lpDlg,hParentWin,Dispatch,(DWORD)this);
}

char * OptionsDialog::LoadDlgTemplate (UINT res_id, DWORD *cbDlgSize)
{
	HFILE			hFile;
	HRSRC       hrDlg;
	DWORD			cbSize;
	char			*lpDlg;

	if (cbDlgSize) *cbDlgSize = 0;
	hrDlg = FindResource(hInst,MAKEINTRESOURCE(res_id),RT_DIALOG);
	if (hrDlg == NULL) return NULL;
	cbSize = SizeofResource (hrDlg);
	lpDlg = (char *)malloc(cbSize);
	hFile = AccessResource(hInst,hrDlg);
	_lread (hFile,lpDlg,cbSize);
	_lclose (hFile);

	if (cbDlgSize) *cbDlgSize = cbSize;
	return lpDlg;
}

LPDLGITEMTEMPLATE FindFirstItem (char * lpDialog)
{
	LPDLGTEMPLATE	lpHeader = (LPDLGTEMPLATE)lpDialog;

	lpPtr = lpDialog + sizeof(DLGTEMPLATE);
// skip the menu name field
	lpPtr += lstrlen(lpPtr) + 1;
// skip the Class name field
	lpPtr += lstrlen(lpPtr) + 1;
// skip the Caption field
	lpPtr += lstrlen(lpPtr) +1;

	if (lpHeader->dtStyle & DS_SETFONT) {
		lpPtr += sizeof (FONTINFO);
		lpPtr += lstrlen (lpPtr) + 1;
	}

	return (LPDLGITEMTEMPLATE) lpPtr;
 }

LPDLGITEMTEMPLATE GetNextDlgItem (LPDLGITEMTEMPLATE lpItem)
{
	char		* lpPtr = (char *)lpItem;

	lpPtr += sizeof(DLGITEMTEMPLATE);
// skip the class name
	lpPtr += lstrlen(lpPtr) + 1;
// skip the text field
	lpPtr += lstrlen(lpPtr) + 1;
// skip the additional data field
	lpPtr += *lpPtr + 1;

	return (LPDLGITEMTEMPLATE)lpPtr;
}

int SizeOfDlgItem (LPDLGITEMTEMPLATE lpItem)
{
	char		* lpPtr = (char *)lpItem;
	int		size = 0;

	size += sizeof(DLGITEMTEMPLATE);
	lpPtr += sizeof(DLGITEMTEMPLATE);
// skip the class name
	size += lstrlen(lpPtr) + 1;
	lpPtr += lstrlen(lpPtr) + 1;
// skip the text field
	size += lstrlen(lpPtr) + 1;
	lpPtr += lstrlen(lpPtr) + 1;
// skip the additional data field
	size += *lpPtr + 1;

	return size;
}

int * GetOptions(RECT& rct,char *lpOptDlg,char **lpDlg,int *dlgSize)
{
	LPDLGITEMTEMPLATE		lpItem;
	LPDLGTEMPLATE			lpOptHdr = (LPDLGTEMPLATE)lpOptDlg;
	int						*optAns = NULL;
	int						nCtrls = 0;

	lpItem = GetFirstItem (lpOptDlg);

	for (int idx=0; idx < lpOptHdr->dtItemCount; idx++,lpItem = GetNextDlgItem(lpItem)) {
		SetRect (&rctCtrl,lpItem->dtilX,lpItem->dtilY,lpItem->dtilX+lpItem->dtilCX,
				lpItem->dtilY+lpItem->dtilCY);
		if (IsRectWithinRect (rct,rctCtrl)) {
			nCtrls ++;
			optAns = (int *)realloc(optAns,nCtrls *sizeof(int));
			optAns[nCtrls-1] = lpItem->dtillD;
			if (lpDlg != NULL) {
				lpDlgHdr = (LPDLGTEMPLATE)(*lpDlg);
				lpDlgHdr->dtItemCount++;
				ctrlSize = SizeOfDlgItem(lpItem);
				*lpDlg = (char *)realloc(*lpDlg,*dlgSize+ctrlSize);
				memcpy (*lpDlg+*dlgSize,lpItem,ctrlSize);
				*dlgSize += ctrlSize;
			}
		}
	}

	return optAns;
}

