#include <windows.h>
//
//	Handles the insert object dialog
//
#include <shellapi.h>
#include <commdlg.h>
#include <ole2.h>
#include "oledlg.h"
#include "wdres.h"

#include "debug.h"

//--------------------------------------------------------------------------------------------
//
//	Basic dialog code
//
//	Used to encapsulate dialog behavior in C++ classes
//
//	Ira Rodens
//
//--------------------------------------------------------------------------------------------

Dialog::Dialog(HWND hParent,HINSTANCE hInstance, UINT nDlg)
{
	hParentWin = hParent;
	hInst = hInstance;
	BaseDialog = nDlg;
}

Dialog::~Dialog()
{
}


BOOL CALLBACK _export Dialog::Dispatch(HWND hDlg,UINT msg, WPARAM wParam, LPARAM lParam)
{
//   Dispatches events to the correct object

	Dialog		*obj;

// On initialization store an object pointer in properties
	if (msg == WM_INITDIALOG) {
		SetProp (hDlg,"OBJ_LO",(HANDLE)LOWORD(lParam));
		SetProp (hDlg,"OBJ_HI",(HANDLE)HIWORD(lParam));
	}
// Retrieve the object pointer from the properties
	obj = (Dialog *)MAKELONG(GetProp(hDlg,"OBJ_LO"),GetProp(hDlg,"OBJ_HI"));
	if (obj != NULL) {
		return obj -> WndProc (hDlg,msg,wParam,lParam);
	}
	return FALSE;
}

BOOL Dialog::Create()
{
	return DialogBoxParam(hInst,MAKEINTRESOURCE(BaseDialog),hParentWin,
		Dispatch,(DWORD)this);
}


InsertObjDlg::InsertObjDlg (HWND hParent,HINSTANCE hInstance)
 : Dialog (hParent,hInstance,DLG_INS_OBJ1)
 {
		clsidServer = CLSID_NULL;
 }

 InsertObjDlg::~InsertObjDlg()
 {
 }

 BOOL InsertObjDlg::WMInitDialog (HWND hDlg, WPARAM wParam, LPARAM lParam)
 {
	RECT		rctList;

	hDialog = hDlg;
	GetWindowRect(GetDlgItem(hDialog,IDC_SERVERLIST),&rctList);
	SendDlgItemMessage(hDialog,IDC_SERVERLIST,LB_SETCOLUMNWIDTH,
			rctList.left-rctList.right,0L);

	ListServers();
	CreateFrom = CREATE_NEW;

	return TRUE;
 }

 void InsertObjDlg::IDCServerList(WPARAM wParam,LPARAM lParam)
 {
	if (HIWORD(lParam) == LBN_DBLCLK)
		IDoK();
 }

void InsertObjDlg::IDoK()
{
	int		idx;
	char		szServer[150];
	char		*lpszCLSID;

	if (CreateFrom == CREATE_NEW) {
		idx = (int)SendDlgItemMessage (hDialog,IDC_SERVERLIST,LB_GETCURSEL,0,0L);
		SendDlgItemMessage (hDialog,IDC_SERVERLIST,LB_GETTEXT,idx,(LONG)szServer);
		lpszCLSID = szServer;
		while (*lpszCLSID++ != '\t');
                CLSIDFromString (lpszCLSID,&clsidServer);
	}

	EndDialog(hDialog,TRUE);
}

 BOOL InsertObjDlg::WMCommand (HWND hDlg,WPARAM wParam, LPARAM lParam)
 {
	switch (wParam) {

	case IDOK:
		IDoK();
		break;
	case IDCANCEL:
		EndDialog(hDlg,FALSE);
		break;
	case IDC_SERVERLIST:
		IDCServerList (wParam,lParam);
		break;
        }
	return TRUE;
 }

BOOL InsertObjDlg::WndProc (HWND hDlg,UINT msg,WPARAM wParam, LPARAM lParam)
 {
	switch (msg) {

	case WM_INITDIALOG:
		return WMInitDialog(hDlg,wParam,lParam);
	case WM_COMMAND:
		return WMCommand (hDlg,wParam,lParam);
	}
	return FALSE;
 }

 void InsertObjDlg::ListServers()
 {
	const	int MAX_KEY_SIZE = 80;

	char		*lpszKeyName;
	char		*lpszServer;
	char		*lpszResponse;
	char		*lpszProgId;
	char		*lpszCLSID;
	CLSID		clsid;
	int		idx;
	HKEY		hKey;
	long		nChar;
	LPMALLOC	pIMalloc;
	RECT		rctList;
	int		nTab;

	if (CoGetMalloc(MEMCTX_TASK,&pIMalloc) != S_OK)
		return;
//	Clear out the list box
	SendDlgItemMessage(hDialog,IDC_SERVERLIST,LB_RESETCONTENT,0,0L);

	GetWindowRect(GetDlgItem(hDialog,IDC_SERVERLIST),&rctList) ;
        nTab = rctList.right - rctList.left;
	SendDlgItemMessage(hDialog,IDC_SERVERLIST,LB_SETTABSTOPS,1,(LPARAM)&nTab);

	if (RegOpenKey (HKEY_CLASSES_ROOT,NULL,&hKey) != ERROR_SUCCESS)
		return;

	lpszKeyName = new char[MAX_KEY_SIZE];
	lpszProgId  = new char[MAX_KEY_SIZE];
	lpszServer  = new char[MAX_KEY_SIZE];
	lpszResponse = new char[MAX_KEY_SIZE];

	for (idx=0; RegEnumKey(hKey,idx,lpszProgId,MAX_KEY_SIZE)==ERROR_SUCCESS;
			idx++ ) {

		wsprintf (lpszKeyName,"%s\\NonInsertable",lpszProgId);
		nChar = MAX_KEY_SIZE;
		if (RegQueryValue(hKey,lpszKeyName,lpszResponse,&nChar)==ERROR_SUCCESS)
			continue;

		wsprintf (lpszKeyName,"%s\\protocol\\StdFileEditing\\server",lpszProgId);
		nChar = MAX_KEY_SIZE;
		if (RegQueryValue(hKey,lpszKeyName,lpszResponse,&nChar)!= ERROR_SUCCESS) {

			wsprintf (lpszKeyName,"%s\\Insertable",lpszProgId);
			nChar = MAX_KEY_SIZE;
			if (RegQueryValue(hKey,lpszKeyName,lpszResponse,&nChar)!=ERROR_SUCCESS)
				  continue;
		}
		nChar = MAX_KEY_SIZE;
		if (RegQueryValue(hKey,lpszProgId,lpszServer,&nChar) != ERROR_SUCCESS)
			continue;

		if ((CLSIDFromProgID(lpszProgId,&clsid) != S_OK) ||
			(StringFromCLSID(clsid,&lpszCLSID) != S_OK))
				continue;

		if (SendDlgItemMessage(hDialog,IDC_SERVERLIST,LB_FINDSTRING,-1,(LPARAM)lpszServer)
			==LB_ERR) {
			wsprintf (lpszResponse,"%s\t%s",lpszServer,lpszCLSID);
			SendDlgItemMessage(hDialog,IDC_SERVERLIST,LB_ADDSTRING,0,(LPARAM)lpszResponse);
		}
		pIMalloc->Free((void *)lpszCLSID);

	}

	delete [] lpszKeyName;
	delete [] lpszProgId;
	delete [] lpszResponse;
	delete [] lpszServer;
	pIMalloc->Release();
	RegCloseKey(hKey);
	if (idx > 0)
		SendDlgItemMessage(hDialog,IDC_SERVERLIST,LB_SETCURSEL,0,0L);
}

