#include <windows.h>
#include <ole2.h>
#include <commdlg.h>
#include <alloc.h>

#include "mainwin.h"
#include "textwin.h"
#include "oledlg.h"
#include "gdiobj.h"
#include "wdres.h"

#include "debug.h"

const	UINT ID_OBJMENU = 450;

 BOOL PASCAL _export AboutDlgProc (HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);

 BasicWindow::BasicWindow (BasicWindow *parent)
 {
	pParent = parent;
	if (parent) hInst = parent->GetInstance();
 }

 BasicWindow::~BasicWindow()
 {
 }

 LRESULT PASCAL _export BasicWindow::Dispatch (HWND hWnd,UINT msg,WPARAM wParam, LPARAM lParam)
 {
	BasicWindow		*obj;
	LRESULT			res;

	if (msg == WM_NCCREATE) {
		  SetWindowLong (hWnd,0,(long)(((CREATESTRUCT *)lParam)->lpCreateParams));
	}
	obj = (BasicWindow *)GetWindowLong(hWnd,0);
	if (obj) res = obj -> WndProc (hWnd,msg,wParam,lParam);
	else res = DefWindowProc (hWnd,msg,wParam,lParam);

	if (msg == WM_NCDESTROY) {
		delete obj;
	}
	return res;
 }

 MainWindow::MainWindow (HINSTANCE hInstance,LPSTR spWinTitle,int nCmndShow)
  : BasicWindow((BasicWindow *)NULL)
 {
	hInst = hInstance;
	spTitle = new char [lstrlen(spWinTitle)+1];
	lstrcpy (spTitle,spWinTitle);
	nShow = nCmndShow;
	hWindow = NULL;
	textWindow = NULL;
 }

MainWindow::~MainWindow()
{
	if (spTitle) delete [] spTitle;
}

 void MainWindow::Create ()
 {
	CreateWindow(MainWindowClass,spTitle,WS_OVERLAPPEDWINDOW | WS_HSCROLL | WS_VSCROLL,
		CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,NULL,NULL,hInst,(LPSTR)this);

	ShowWindow (hWindow,nShow);
 }

 LRESULT MainWindow::WMCreate (HWND hWnd, WPARAM wParam, LPARAM lParam)
 {
	hWindow = hWnd;
	textWindow = new TextWindow (this);
	if (!textWindow -> Create()) {
		PostQuitMessage(0);
		return -1;
	}

	return 0;
 }

 LRESULT MainWindow::WMSize (HWND hWnd, WPARAM wParam, LPARAM lParam)
 {
   int	width,height;

   if (textWindow) {
	width = LOWORD (lParam);
	height = HIWORD (lParam);
	textWindow -> Resize(width,height);
   }
   return 0;
 }

LRESULT	MainWindow::WMPaint (HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT		ps;
	BeginPaint (hWnd,&ps);
	EndPaint (hWnd, &ps);
	return 0;
}

LRESULT MainWindow::WMSetFocus (HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	if (textWindow->hWindow) SetFocus(textWindow->hWindow);
        return 0;
}

LRESULT MainWindow::WMDestroy(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	PostQuitMessage(0);
	return 0;
}

LRESULT MainWindow::WMInitMenuPopup(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	HMENU hMenu = (HMENU)wParam;
	HMENU hPopup;
	int	nPos;
	char	spObject[15];
	IDataObject	*pIData;

	if ((LOWORD(lParam) == 1) && (HIWORD(lParam)==0)) {
		nPos = GetMenuItemCount(hMenu) - 1;
                GetMenuString(hMenu,nPos,spObject,sizeof(spObject),MF_BYPOSITION);

		if (textWindow->IsObjectSelected()!=NULL) {
			EnableMenuItem(hMenu,CM_CUT,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hMenu,CM_EDITCOPY,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hMenu,CM_DELETE,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hMenu,CM_EDITINSERT_OBJECT,MF_BYCOMMAND|MF_GRAYED);
			hPopup = textWindow->CreateObjectMenu(ID_OBJMENU);
			ModifyMenu(hMenu,nPos,MF_BYPOSITION|MF_ENABLED|MF_POPUP|MF_STRING,(UINT)hPopup,spObject);
		}
		else {
			EnableMenuItem(hMenu,CM_CUT,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hMenu,CM_EDITCOPY,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hMenu,CM_DELETE,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hMenu,CM_EDITINSERT_OBJECT,MF_BYCOMMAND|MF_ENABLED);
			ModifyMenu(hMenu,nPos,MF_BYPOSITION|MF_GRAYED|MF_STRING,CM_OBJECT,spObject);
		}

		OleGetClipboard(&pIData);
		if(pIData && (S_OK == GetScode(OleQueryCreateFromData(pIData))))
			EnableMenuItem(hMenu,CM_EDITPASTE,MF_BYCOMMAND|MF_ENABLED);
		else
			EnableMenuItem(hMenu,CM_EDITPASTE,MF_BYCOMMAND|MF_GRAYED);
//		if (pIData) pIData->Release();

	}
        return 0;
}


void MainWindow::CMAbout()
{
	DialogBox (GetInstance(),MAKEINTRESOURCE(DLG_ABOUT),
		hWindow, AboutDlgProc);
}

void MainWindow::CMExit()
{
	if (textWindow && textWindow->IsDirty() ) {
		switch (MessageBox(NULL,"File has been changed. Do You Wish to Save?",
			"Confirm",MB_YESNOCANCEL|MB_APPLMODAL|MB_ICONQUESTION)) {
		case IDYES:
			CMFileSave();
			break;
		case IDNO:
			break;
		case IDCANCEL:
			return;
		}
        }

	DestroyWindow(hWindow);
}

void MainWindow::CMInsertObject()
{
	InsertObjDlg	*oleDlg;

	oleDlg = new InsertObjDlg (hWindow,GetInstance());
	if (oleDlg->Create()) {
		if (oleDlg->GetType() == CREATE_NEW) {
			textWindow->InsertObject(oleDlg->GetCLSID());
		}
	}
	delete oleDlg;

}

void MainWindow::CMFileNew()
{
	if (textWindow->IsDirty()) {
		switch (MessageBox(NULL,"File Has Been Changed. Do You Wish to Save?",
			"Confirm",MB_YESNOCANCEL|MB_APPLMODAL|MB_ICONQUESTION)) {

		case IDYES:
			CMFileSave();
			break;
		case IDNO:
			break;
		case IDCANCEL:
			return;
		}
	}
        textWindow -> SetFilename(NULL);
	textWindow ->NewFile();
	InvalidateRect(textWindow->GetWindow(),NULL,TRUE);
	SetTitle(textWindow -> GetFilename());
}

void MainWindow::CMFileOpen()
{
	OPENFILENAME	*ofnLoad;
	LPSTR		spFilter;
	LPSTR		spFile;
	LPSTR		spFileTitle;
        HCURSOR		hSaveCursor;
	static char	szDefaultExt[] = "col";
	const int	FILE_LEN = 128;


	if (textWindow->IsDirty()) {
		switch(MessageBox(NULL,"File has been Changed. Do You Wish to Save the File?","Confirm",
			MB_YESNOCANCEL|MB_APPLMODAL|MB_ICONQUESTION)) {
		case IDYES:
			CMFileSave();
			break;
		case IDNO:
			break;
		case IDCANCEL:
			return;
		}
        }

	spFilter = GetFilterString(hInst,IDS_SAVEFILTER);
	spFile = (LPSTR)malloc(FILE_LEN);
        *spFile = '\0';
	spFileTitle = (LPSTR)malloc(FILE_LEN);
	*spFileTitle = '\0';
	ofnLoad = (OPENFILENAME *)calloc(1,sizeof(OPENFILENAME));

	ofnLoad->lStructSize = sizeof(OPENFILENAME);
	ofnLoad->hwndOwner = hWindow;
	ofnLoad->lpstrFilter = spFilter;
	ofnLoad->nFilterIndex = 1;
	ofnLoad->lpstrFile = spFile;
	ofnLoad->nMaxFile = FILE_LEN;
	ofnLoad->lpstrFileTitle = spFileTitle;
	ofnLoad->nMaxFileTitle = FILE_LEN;
	ofnLoad->Flags = OFN_NOREADONLYRETURN | OFN_FILEMUSTEXIST |
		 OFN_PATHMUSTEXIST;
	ofnLoad->lpstrDefExt = szDefaultExt;

	if (GetOpenFileName(ofnLoad)) {
        	hSaveCursor = SetCursor(hWaitCursor);
                textWindow->SetFilename(spFile);
                textWindow->NewFile();
		if (!textWindow->LoadFile(spFile)) {
                	textWindow->SetFilename(NULL);
		}
		InvalidateRect(textWindow->GetWindow(),NULL,TRUE);
		SetTitle(textWindow->GetFilename());
                SetCursor(hSaveCursor);
	}

	free(spFile);
	free(spFileTitle);
	free(ofnLoad);
}
	

void MainWindow::CMFileSave()
{
	HCURSOR		hSaveCursor;

	if (textWindow->GetFilename() == NULL) {
		CMFileSaveAs();
	}
	else {
		hSaveCursor = SetCursor(hWaitCursor);
		textWindow->Save();
		SetCursor(hSaveCursor);
	}
}

void MainWindow::CMFileSaveAs()
{
	OPENFILENAME	*ofnSave;
	LPSTR		spFilter;
	LPSTR		spFile;
	LPSTR		spFileTitle;
        HCURSOR		hSaveCursor;
	static char	szDefaultExt[] = "col";
	const int	FILE_LEN = 128;

	spFilter = GetFilterString(hInst,IDS_SAVEFILTER);
	spFile = (LPSTR)malloc(FILE_LEN);
        *spFile = '\0';
	spFileTitle = (LPSTR)malloc(FILE_LEN);
	*spFileTitle = '\0';
	ofnSave = (OPENFILENAME *)calloc(1,sizeof(OPENFILENAME));

	ofnSave->lStructSize = sizeof(OPENFILENAME);
	ofnSave->hwndOwner = hWindow;
	ofnSave->lpstrFilter = spFilter;
	ofnSave->nFilterIndex = 1;
	ofnSave->lpstrFile = spFile;
	ofnSave->nMaxFile = FILE_LEN;
	ofnSave->lpstrFileTitle = spFileTitle;
	ofnSave->nMaxFileTitle = FILE_LEN;
	ofnSave->Flags = OFN_HIDEREADONLY | OFN_NOREADONLYRETURN |
		 OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST;
	ofnSave->lpstrDefExt = szDefaultExt;

	if (GetSaveFileName(ofnSave)) {
		hSaveCursor = SetCursor(hWaitCursor);
                textWindow->SetFilename(spFile);
		textWindow->SaveAs(spFile);
		SetTitle(spFile);
                SetCursor(hSaveCursor);
	}

	free(spFile);
	free(spFileTitle);
	free(ofnSave);
}

void MainWindow::SetTitle(char *spTitle)
{
	char 	szTitle[150];

	if (spTitle == NULL)
		lstrcpy(szTitle,"Collage");
        else
		wsprintf (szTitle,"Collage - %s",spTitle);

	SetWindowText(hWindow,szTitle);
}

LRESULT MainWindow::WMCommand (HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	switch (wParam) {

	case CM_FILENEW:
                CMFileNew();
		break;
	case CM_FILEOPEN:
        	CMFileOpen();
		break;
	case CM_FILESAVE:
        	CMFileSave();
		break;
	case CM_FILESAVE_AS:
		CMFileSaveAs();
		break;
	case CM_FILEEXIT:
		CMExit();
		break;
	case CM_CUT:
        	textWindow->CutToClipboard();
		break;
	case CM_EDITCOPY:
		textWindow->CopyToClipboard();
		break;
	case CM_EDITPASTE:
        	textWindow->PasteObject();
		break;
	case CM_DELETE:
		textWindow->DeleteSelectedObject();
		break;
	case CM_EDITINSERT_OBJECT:
		CMInsertObject();
		break;
	case CM_ABOUT:
		CMAbout();
		break;
	default:
		textWindow->ProcessMenuCommand(ID_OBJMENU,wParam);
                break;
	}
	return 0;
}

LRESULT MainWindow::WndProc(HWND hWnd,UINT msg,WPARAM wParam, LPARAM lParam)
 {
	switch (msg) {

	case WM_CREATE:
		return WMCreate (hWnd, wParam, lParam);
	case WM_SIZE:
		return WMSize (hWnd, wParam, lParam);
	case WM_PAINT:
		return WMPaint (hWnd, wParam, lParam);
	case WM_COMMAND:
		return WMCommand (hWnd, wParam, lParam);
	case WM_DESTROY:
		return WMDestroy(hWnd, wParam, lParam);
	case WM_HSCROLL:
		return textWindow->HScroll(hWnd,wParam,lParam);
	case WM_VSCROLL:
		return textWindow->VScroll(hWnd,wParam,lParam);
	case WM_SETFOCUS:
		return WMSetFocus(hWnd,wParam,lParam);
	case WM_INITMENUPOPUP:
		return WMInitMenuPopup(hWnd, wParam, lParam);
	case WM_CLOSE:
		CMExit();
		return 0;
	default:
		return DefWindowProc (hWnd,msg,wParam,lParam);
	}
 }
 BOOL PASCAL _export AboutDlgProc (HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
 {
	if ((msg == WM_COMMAND) && (wParam == IDOK)) {
		EndDialog (hDlg,0);
		return TRUE;
	}
	return FALSE;
 }

LPSTR GetFilterString(HINSTANCE hInstance, UINT id)
{
	static char	szFilter[128];
	char		*spFilter;

	szFilter[0] = '\0';
	szFilter[1] = '\0';

	if (LoadString(hInstance,id,szFilter,sizeof szFilter)) {

		spFilter = szFilter;
		while (*spFilter) {
			if (*spFilter == '|') *spFilter = '\0';
			spFilter++;
		}
	}
	return szFilter;
}