//		Standard Dialog Class Headers
//

#ifndef DIALOG_H
#define DIALOG_H

#include "dlgtemp.h"
class Dialog
{
protected:

HWND			hDialog;
HWND			hParentWin;
HINSTANCE	hInst;
UINT			BaseDialog;

static BOOL CALLBACK _export Dispatch(HWND hDlg,UINT msg, WPARAM wParam, LPARAM lParam);
virtual BOOL WndProc (HWND hDlg,UINT msg, WPARAM wParam, LPARAM lParam) =0;

public:

Dialog(HWND hParent,HINSTANCE hInstance, UINT nDlg);
virtual ~Dialog();
virtual BOOL Create();

};

class OptionDialog : public Dialog
{
protected:
	struct Option {
		int	*ctrl;
		int   nCtrl;
	};
	int		nOpt;
	Option	**option;
	int		CurrOption;
	UINT		OptionId;
	HANDLE	hDlgTemp;

char * LoadDlgTemplate (UINT res_id, DWORD *cbDlgSize);
LPDLGITEMTEMPLATE FindFirstItem (char * lpDialog);
LPDLGITEMTEMPLATE GetNextDlgItem (LPDLGITEMTEMPLATE lpItem);
int SizeOfDlgItem (LPDLGITEMTEMPLATE lpItem);
Option * GetOptions(RECT& rct,char *lpOptDlg,char **lpDlg,DWORD *dlgSize);
void ShowOption(int nShowOpt);
UINT GetTemplateSize(char * lpDialog);
virtual BOOL WndProc (HWND hDlg,UINT msg, WPARAM wParam, LPARAM lParam) =0;

public:
OptionDialog (HWND hParent, HINSTANCE hInstance,UINT BaseDlg,int nOptions,UINT optionID);
virtual ~OptionDialog();
virtual BOOL Create();

};

BOOL IsRectInsideRect (RECT& a, RECT& b);


#endif