#include <windows.h>
#include <alloc.h>
#include <mem.h>
#include "dialog.h"

#include "debug.h"

//--------------------------------------------------------------------------------------------
//
//	Basic dialog code
//
//	Used to encapsulate dialog behavior in C++ classes
//
//	Ira Rodens
//
//--------------------------------------------------------------------------------------------

Dialog::Dialog(HWND hParent,HINSTANCE hInstance, UINT nDlg)
{
	hParentWin = hParent;
	hInst = hInstance;
	BaseDialog = nDlg;
}

Dialog::~Dialog()
{
}


BOOL CALLBACK _export Dialog::Dispatch(HWND hDlg,UINT msg, WPARAM wParam, LPARAM lParam)
{
//   Dispatches events to the correct object

	Dialog		*obj;

// On initialization store an object pointer in properties
	if (msg == WM_INITDIALOG) {
		SetProp (hDlg,"OBJ_LO",(HANDLE)LOWORD(lParam));
		SetProp (hDlg,"OBJ_HI",(HANDLE)HIWORD(lParam));
	}
// Retrieve the object pointer from the properties
	obj = (Dialog *)MAKELONG(GetProp(hDlg,"OBJ_LO"),GetProp(hDlg,"OBJ_HI"));
	if (obj != NULL) {
		return obj -> WndProc (hDlg,msg,wParam,lParam);
	}
	return FALSE;
}

BOOL Dialog::Create()
{
	return DialogBoxParam(hInst,MAKEINTRESOURCE(BaseDialog),hParentWin,
		Dispatch,(DWORD)this);
}

// Option dialog is used for creating a dialog some of whose appearance changes
// depending on which options are chosen.
// Requires that each of the options be created as a series of dialog created
// thru the resource editor. The first dialog must contain all of the invariant
// controls in the dialog. In each dialog the options must be framed by a control
// with the resource id OptionId (should be black frame). The options in the dialog box
// must not have conflicting control ids. The dialog views must have sequential resource
// ids starting with BaseDlg 

OptionDialog::OptionDialog (HWND hParent, HINSTANCE hInstance,UINT BaseDlg,int nOptions,UINT optionID)
	: Dialog (hParent,hInstance,BaseDlg)
{

	nOpt = nOptions;
	hDlgTemp = NULL;
	option = (Option **)calloc(nOpt, sizeof(Option *));
	CurrOption = -1;
	OptionId = optionID;
}

OptionDialog::~OptionDialog()
{
	int		i;

	if (hDlgTemp) {
		GlobalUnlock(hDlgTemp);
		GlobalFree(hDlgTemp);
	}
	if (option) {
		for (i=0; i<nOpt; i++) {
			if (option[i]) free (option[i]);
		}
		free (option);
	}
}

BOOL OptionDialog::Create()
{
	char					*lpDlg;
	char					*lpOptDlg;
	char					*lpDlgTemp;
	LPDLGTEMPLATE		lpDlgHeader;
	LPDLGITEMTEMPLATE	lpItem;
	int					idx;
	RECT					rct;
	DWORD					dlgSize;

// load the master dialog template
	lpDlg = LoadDlgTemplate(BaseDialog,&dlgSize);
	if (lpDlg == NULL) return FALSE;
	dlgSize = GetTemplateSize(lpDlg);
	lpDlgHeader = (LPDLGTEMPLATE)lpDlg;
//  Find the options box
	lpItem = FindFirstItem (lpDlg);
	idx = 0;
	while ( lpItem->dtillD != OptionId) {
		idx ++;
		if (idx >= lpDlgHeader->dtItemCount) break;
		lpItem = GetNextDlgItem(lpItem);
	}
// if the option box is found then go on
	if (lpItem->dtillD == OptionId) {
	// get the option box dimensions
		rct.left = lpItem->dtilX;
		rct.top = lpItem->dtilY;
		rct.right = rct.left + lpItem->dtilCX;
		rct.bottom = rct.top + lpItem->dtilCY;
	// change the option box to disabled and invisible
		lpItem->dtilStyle &= ~WS_VISIBLE;
		lpItem->dtilStyle |= WS_DISABLED;
        // get the option ctrl ids for the master template
		option[0] = GetOptions(rct,lpDlg,NULL,NULL);
        // add all of the other dialogs
		for (idx =1; idx < nOpt; idx++) {
			 lpOptDlg = LoadDlgTemplate(BaseDialog+idx,NULL);
			 if (lpOptDlg) {
				option[idx] = GetOptions(rct,lpOptDlg,&lpDlg,&dlgSize);
			 }
			 free (lpOptDlg);
		}
	}
// must put the resulting template in Global Memory for Windows to use it
	hDlgTemp = GlobalAlloc(GMEM_FIXED,dlgSize);
	lpDlgTemp = (char *)GlobalLock(hDlgTemp);
	memcpy (lpDlgTemp,lpDlg,(int)dlgSize);
	free (lpDlg);
	return DialogBoxIndirectParam (hInst,hDlgTemp,hParentWin,Dispatch,(LPARAM)this);
}

char * OptionDialog::LoadDlgTemplate (UINT res_id, DWORD *cbDlgSize)
{
	HFILE			hFile;
	HRSRC       hrDlg;
	DWORD			cbSize;
	char			*lpDlg;

// Load the dialog template by brute force
	if (cbDlgSize) *cbDlgSize = 0;
	hrDlg = FindResource(hInst,MAKEINTRESOURCE(res_id),RT_DIALOG);
	if (hrDlg == NULL) return NULL;
	cbSize = SizeofResource (hInst,hrDlg);
	lpDlg = (char *)malloc((int)cbSize);
	hFile = AccessResource(hInst,hrDlg);
	_lread (hFile,lpDlg,(int)cbSize);
	_lclose (hFile);

	if (cbDlgSize) *cbDlgSize = cbSize;
	return lpDlg;
}

LPDLGITEMTEMPLATE OptionDialog::FindFirstItem (char * lpDialog)
{
	LPDLGTEMPLATE	lpHeader = (LPDLGTEMPLATE)lpDialog;
	char				*lpPtr;

	lpPtr = lpDialog + sizeof(DLGTEMPLATE);
// skip the menu name field
	lpPtr += lstrlen(lpPtr) + 1;
// skip the Class name field
	lpPtr += lstrlen(lpPtr) + 1;
// skip the Caption field
	lpPtr += lstrlen(lpPtr) +1;

// Check if font info is present
// if so then skip the font field
	if (lpHeader->dtStyle & DS_SETFONT) {
		lpPtr += sizeof (FONTINFO);
		lpPtr += lstrlen (lpPtr) + 1;
	}

	return (LPDLGITEMTEMPLATE) lpPtr;
 }

LPDLGITEMTEMPLATE OptionDialog::GetNextDlgItem (LPDLGITEMTEMPLATE lpItem)
{
	char		* lpPtr = (char *)lpItem;

	lpPtr += sizeof(DLGITEMTEMPLATE);
// skip the class name
// Predefined classes are given by a byte code greater than 0x80
	if ((unsigned char)(*lpPtr) < 0x80)
		lpPtr += lstrlen(lpPtr) + 1;
	else
		lpPtr++;
// skip the text field
	lpPtr += lstrlen(lpPtr) + 1;
// skip the additional data field
	lpPtr += *lpPtr + 1;

	return (LPDLGITEMTEMPLATE)lpPtr;
}

int OptionDialog::SizeOfDlgItem (LPDLGITEMTEMPLATE lpItem)
{
	char		* lpPtr = (char *)lpItem;
	int		size = 0;

	size += sizeof(DLGITEMTEMPLATE);
	lpPtr += sizeof(DLGITEMTEMPLATE);
// skip the class name
	if ((unsigned char)(*lpPtr) < 0x80) {
		size += lstrlen(lpPtr) + 1;
		lpPtr += lstrlen(lpPtr) + 1;
	}
	else {
		size ++;
		lpPtr ++;
	}
// skip the text field
	size += lstrlen(lpPtr) + 1;
	lpPtr += lstrlen(lpPtr) + 1;
// skip the additional data field
	size += *lpPtr + 1;

	return size;
}

OptionDialog::Option * OptionDialog::GetOptions(RECT& rct,char *lpOptDlg,char **lpDlg,DWORD *dlgSize)
{
	LPDLGITEMTEMPLATE		lpItem;
	LPDLGTEMPLATE			lpDlgHdr;
	LPDLGTEMPLATE			lpOptHdr = (LPDLGTEMPLATE)lpOptDlg;
	Option					*optAns = (Option *)calloc(1,sizeof(Option));
	RECT						rctCtrl;
	int						ctrlSize;


	lpItem = FindFirstItem (lpOptDlg);

	for (int idx=0; idx < lpOptHdr->dtItemCount; idx++,lpItem = GetNextDlgItem(lpItem)) {
		SetRect (&rctCtrl,lpItem->dtilX,lpItem->dtilY,lpItem->dtilX+lpItem->dtilCX,
				lpItem->dtilY+lpItem->dtilCY);
		if (IsRectInsideRect (rct,rctCtrl) && (lpItem->dtillD != OptionId)) {
			optAns->nCtrl ++;
			optAns->ctrl = (int *)realloc(optAns->ctrl,optAns->nCtrl *sizeof(int));
			optAns->ctrl[optAns->nCtrl-1] = lpItem->dtillD;
			lpItem->dtilStyle &= ~WS_VISIBLE;
			lpItem->dtilStyle |= WS_DISABLED;
			if (lpDlg != NULL) {
				lpDlgHdr = (LPDLGTEMPLATE)(*lpDlg);
				lpDlgHdr->dtItemCount++;
				ctrlSize = SizeOfDlgItem(lpItem);
				*lpDlg = (char *)realloc(*lpDlg,(int)(*dlgSize+ctrlSize));
				memcpy (*lpDlg+(int)*dlgSize,lpItem,(int)ctrlSize);
				*dlgSize += ctrlSize;
			}
		}
	}

	return optAns;
}

void OptionDialog::ShowOption(int nShowOpt)
{
	HWND		hCtrl;
	int		i;

	if ((CurrOption >= 0) && (option[CurrOption] != NULL)){
		for (i=0; i<option[CurrOption]->nCtrl; i++) {
			hCtrl = GetDlgItem(hDialog,option[CurrOption]->ctrl[i]);
			ShowWindow(hCtrl,SW_HIDE);
			EnableWindow(hCtrl,FALSE);
		}
	}
	if ((nShowOpt >= 0) && (option[nShowOpt] != NULL)) {
		for (i=0; i<option[nShowOpt]->nCtrl; i++) {
			hCtrl = GetDlgItem(hDialog,option[nShowOpt]->ctrl[i]);
			EnableWindow(hCtrl,TRUE);
			ShowWindow(hCtrl,SW_SHOW);
		}
	}
	CurrOption = nShowOpt;
}

UINT OptionDialog::GetTemplateSize(char * lpDialog)
{
	LPDLGTEMPLATE lpHeader = (LPDLGTEMPLATE)lpDialog;
	LPDLGITEMTEMPLATE lpItem;
	int				i;

	lpItem = FindFirstItem(lpDialog);
	for (i=0; i<lpHeader-> dtItemCount; i++) {
		lpItem = GetNextDlgItem(lpItem);
	}
	return (UINT)((char *)lpItem - lpDialog) ;
}

//
//		Determines if rect b is inside rect a
//
BOOL IsRectInsideRect (RECT& a, RECT& b)
{
	return ((b.left >= a.left) && (b.top >= a.top) &&
			  (b.right <= a.right)) ;
}
