#ifndef DATAOBJ_H
#define DATAOBJ_H

class DtFormatEtcEnum;

class DataTransfer : public IDataObject
{
private:

friend DtFormatEtcEnum;

int		nRef;
int		nFmt;
FORMATETC	**fmtList;
IStorage	*pIStg;
HGLOBAL		hObjDesc;
OBJECTDESCRIPTOR *pObjDesc;
BOOL		valid;

public:

DataTransfer(OleClientObj *pObj,const char *spDocTitle);
~DataTransfer();
STDMETHODIMP DAdvise(FORMATETC FAR * pFmt,DWORD advf,LPADVISESINK pAdvise,DWORD FAR * pConn);
STDMETHODIMP DUnadvise(DWORD dwConnect);
STDMETHODIMP EnumDAdvise(LPENUMSTATDATA FAR *pEnum);
STDMETHODIMP EnumFormatEtc(DWORD dwDirect,LPENUMFORMATETC FAR *pEnum);
STDMETHODIMP GetCanonicalFormatEtc(LPFORMATETC pFmtIn,LPFORMATETC pFmtOut);
STDMETHODIMP GetData(LPFORMATETC pFmt,LPSTGMEDIUM pStgMed);
STDMETHODIMP GetDataHere(LPFORMATETC pFmt,LPSTGMEDIUM pStgMed);
STDMETHODIMP QueryGetData(LPFORMATETC pFmt);
STDMETHODIMP SetData(LPFORMATETC pFmt,LPSTGMEDIUM pStgMed,BOOL bRelease);
STDMETHODIMP_(ULONG) AddRef();
STDMETHODIMP_(ULONG) Release();
STDMETHODIMP QueryInterface(REFIID niid,LPVOID * ppvObj);

inline BOOL IsValid() {return valid;};
};


class DtFormatEtcEnum : public IEnumFORMATETC
{
private:

ULONG		nRef;
DataTransfer	*pIData;
int		n;

public:

DtFormatEtcEnum (DataTransfer *pData);
~DtFormatEtcEnum();
STDMETHODIMP Next(ULONG celt,LPFORMATETC pFmt,ULONG * pCeltFetch);
STDMETHODIMP Skip(ULONG celt);
STDMETHODIMP Reset();
STDMETHODIMP Clone(IEnumFORMATETC ** pEnum);
STDMETHODIMP_(ULONG) AddRef();
STDMETHODIMP_(ULONG) Release();
STDMETHODIMP QueryInterface(REFIID niid,LPVOID * ppvObj);
};

#endif