/* example.c: This file exemplifies the use of the BOB Macro processor library
 *
 * Copyright (c) 1994 Brett Dutton
 *
 *** Revision History:
 * 13-Dec-1994 Dutton      Initial coding
 */

/*
 * Description:
 */

/*
 * includes
 */
#include <stdio.h>
#include <stdlib.h>
#include "bob/bob.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>

/*
 * macros
 */
#define APPNAME "example"
#define VERSION APPNAME " 1.0 By Brett Dutton"

/*
 * typedefs
 */

/*
 * prototypes
 */
void AppCheckBob ( XtPointer cl_data, int *fid, XtInputId *id );
void Quit ( Widget w, XtPointer cl_data, XtPointer call_data );
void Break ( Widget w, XtPointer cl_data, XtPointer call_data );
void LoadOk ( Widget w, XtPointer cl_data, XtPointer call_data );
void ExecuteOk ( Widget w, XtPointer cl_data, XtPointer call_data );
int Message ( int argc, VALUE *arg, VALUE *retval );
int Error ( int argc, VALUE *arg, VALUE *retval );
void ShowError ( char *msg );

/*
 * variables
 */

/* these resources are usually external */
static String resources[] = {
    "*example.width: 300",
    "*example.height: 400",
    "*quit*label: Quit",
    "*break*label: Break",
    "*Command*background: green",
    "*message*label: Message:",
    "*message*width: 275",
    "*error*label: Error:",
    "*error*width: 275",
    "*value: ",
    "*load*label: Load file:",
    "*load*loadok*label: Ok",
    "*load*width: 275",
    "*execute*label: Execute function:",
    "*execute*executeok*label: Ok",
    "*execute*width: 275",
};

/* global widgets */
Widget message, errordia, load, loadok, executedia, executeok;

/*
 * functions
 */

/******************************************************************************
 * Function:
 *  main -- main function
 * 
 * Returns: Nothing   
 */
void main ( int argc, char *argv[] ) 
{
    XtAppContext        app_context;
    Widget              topLevel;
    Widget              box, quit, brkwid;
    int                 bobSock;
    

    /* create a application */
    topLevel = XtVaAppInitialize ( &app_context, APPNAME, NULL, 0, 
                                  &argc, argv, resources, NULL ); 
    
    /* create all the buttons and dialogs for the application */
    box = XtVaCreateManagedWidget ( "box", boxWidgetClass, topLevel, NULL ); 
    quit = XtVaCreateManagedWidget ( "quit", commandWidgetClass, box, NULL ); 
    brkwid = XtVaCreateManagedWidget ( "break", commandWidgetClass, box, 
                                      NULL); 
    message = XtVaCreateManagedWidget ( "message", dialogWidgetClass, box, 
                                       NULL ); 
    errordia = XtVaCreateManagedWidget ( "error", dialogWidgetClass, box, 
                                        NULL ); 
    load = XtVaCreateManagedWidget ( "load", dialogWidgetClass, box, NULL ); 
    loadok = XtVaCreateManagedWidget ( "loadok", commandWidgetClass, load, 
                                   NULL ); 
    executedia = XtVaCreateManagedWidget ( "execute", dialogWidgetClass, box, 
                                   NULL ); 
    executeok = XtVaCreateManagedWidget ( "executeok", commandWidgetClass, 
                                         executedia, NULL ); 
    
    /* set up all the callbacks for the buttons */
    XtAddCallback ( quit, XtNcallback, Quit, 0 );
    XtAddCallback ( brkwid, XtNcallback, Break, 0 );
    XtAddCallback ( loadok, XtNcallback, LoadOk, 0 );
    XtAddCallback ( executeok, XtNcallback, ExecuteOk, 0 );
    
    /* initialize the bob interface language */
    if ( ( bobSock = BobInitialize ( ) ) < 0 ) {
        fprintf (stderr,"Unable to initialize Bob\n" );
        exit(1);
    }
    
    /* add this socket to the event loop for monitoring */
    XtAppAddInput ( app_context, bobSock, (XtPointer)XtInputReadMask, 
                    AppCheckBob, NULL );

    /* register the external functions with BOB */
    BobAddFunction ( "message", Message );
    BobAddFunction ( "error", Error );

    /* load up the application defaults macros */
    BobLoadFile ( "." APPNAME "rc" );  /* user definitions */
    
    /* this has just been put in to demonstrate calling BOB functions */
    BobExecute ( "print", 4, DT_STRING, "Hi ", DT_INTEGER, 20,
                 DT_NIL, DT_STRING, " World\n" );
    
    /* create windows for widgets and map them */
    XtRealizeWidget ( topLevel );
    
    /* loop for events */
    XtAppMainLoop ( app_context );
}

/******************************************************************************
 * Function:
 * AppCheckBob -- The is the work proc called when there is input from Bob
 * 
 * Returns: Nothing   
 */
void AppCheckBob ( XtPointer cl_data, int *fid, XtInputId *id )
{
    /* Call bob to get the events of the Bob comms socket */
    BobCheckClient ( );
}

/******************************************************************************
 * Function:
 * Quit -- Exits from the windows system
 * 
 * Returns: Nothing   
 */
void Quit ( Widget w, XtPointer cl_data, XtPointer call_data )
{
    BobTalkTerm ();     /* shutdown comms with Bob */
    exit ( 0 );
}

/******************************************************************************
 * Function:
 * Break -- Exits from the windows system
 * 
 * Returns: Nothing   
 */
void Break ( Widget w, XtPointer cl_data, XtPointer call_data )
{
    BobBreak ( "BOB Inturrupted" );
}

/******************************************************************************
 * Function:
 * LoadOk -- The load dialog is complete and to load up file
 * 
 * Returns: Nothing   
 */
void LoadOk ( Widget w, XtPointer cl_data, XtPointer call_data )
{
    String      str;            /* filename to load */
    char        msg[500];       /* Error message */
    Arg         xargs[1];       /* New value */

    /* get the string and try to load it */
    str = XawDialogGetValueString ( load );
    if ( BobLoadFile ( str ) ) {
        /* clear the box if no error */
        XtSetArg ( xargs[0], XtNvalue, (XtArgVal)"" );
        XtSetValues ( load, xargs, 1 );
    } else {
        /* send an error to the error box */
        sprintf ( msg, "Unable to load file: %s", str );
        ShowError ( msg );
    }
}
/******************************************************************************
 * Function:
 * ExecuteOk -- The execute dialog is complete and to execute function
 * 
 * Returns: Nothing   
 */
void ExecuteOk ( Widget w, XtPointer cl_data, XtPointer call_data )
{
    String      str;            /* function to execute */
    char        msg[500];       /* error message */
    Arg         xargs[1];       /* New value */
    
    /* get the string and try to load it */
    str = XawDialogGetValueString ( executedia );
    if ( BobExecute ( str, 0 ) ) {
        /* clear the box if no error */
        XtSetArg ( xargs[0], XtNvalue, (XtArgVal)"" );
        XtSetValues ( executedia, xargs, 1 );
    } else {
        /* send an error to the error box */
        sprintf ( msg, "Unable to execute function: %s", str );
        ShowError ( msg );
    }
}
/******************************************************************************
 * Function:
 * Message --  Displays a message in the dialog boc
 * 
 * Returns: The result of this function so that Bob knows if it is an error 
 *          or not
 */
int Message ( int argc, VALUE *arg, VALUE *retval  )
{
    char                msg[500]; /* message to put in dialog */
    Arg                 xargs[1]; /* New value */
    
    /* make sure that there is 1 args */
    /* make sure that it is a string */
    if ( ! BobExtArgs ( argc, 1, 1, retval ) ) return ( FALSE );
    if ( ! BobExtCheckType ( &arg[0], DT_STRING, retval ) ) return ( FALSE );
    
    BobGetString ( msg, sizeof ( msg ), &arg[0] );
    XtSetArg ( xargs[0], XtNvalue, (XtArgVal)msg );
    XtSetValues ( message, xargs, 1 );
    
    return ( BobReturnValue ( retval, DT_INTEGER, TRUE ) );
}
/******************************************************************************
 * Function:
 * Error --  Displays a error in the dialog boc
 * 
 * Returns: The result of this function so that Bob knows if it is an error 
 *          or not
 */
int Error ( int argc, VALUE *arg, VALUE *retval  )
{
    char                msg[500]; /* error to put in dialog */
    Arg                 xargs[1]; /* New value */
    
    /* make sure that there is 1 args */
    /* make sure that it is a string */
    if ( ! BobExtArgs ( argc, 1, 1, retval ) ) return ( FALSE );
    if ( ! BobExtCheckType ( &arg[0], DT_STRING, retval ) ) return ( FALSE );
    
    BobGetString ( msg, sizeof ( msg ), &arg[0] );
    ShowError ( msg );
    
    return ( BobReturnValue ( retval, DT_INTEGER, TRUE ) );
}
/******************************************************************************
 * Function:
 * ShowError --  Displays the passed message in the error dialog box
 * 
 * Description:
 *
 * Returns: Nothing   
 */
void ShowError ( char *msg )
{
    Arg                 xargs[1]; /* New value */
    
    XtSetArg ( xargs[0], XtNvalue, (XtArgVal)msg );
    XtSetValues ( errordia, xargs, 1 );
}
    
        
