/* bobcom.h - bob compiler definitions */
/*
        Copyright (c) 1991, by David Michael Betz
        All rights reserved
*/

/* limits */
#define CMAX            32767   /* code buffer size */

/* token definitions */
#define T_NOTOKEN       -1
#define T_EOF           0

/* non-character tokens */
#define _TMIN           256
#define T_STRING        256
#define T_IDENTIFIER    257
#define T_NUMBER        258
#define T_CLASS         259
#define T_STATIC        260
#define T_IF            261
#define T_ELSE          262
#define T_WHILE         263
#define T_RETURN        264
#define T_FOR           265
#define T_BREAK         266
#define T_CONTINUE      267
#define T_DO            268
#define T_NEW           269
#define T_NIL           270
#define T_LE            271     /* '<=' */
#define T_EQ            272     /* '==' */
#define T_NE            273     /* '!=' */
#define T_GE            274     /* '>=' */
#define T_SHL           275     /* '<<' */
#define T_SHR           276     /* '>>' */
#define T_AND           277     /* '&&' */
#define T_OR            278     /* '||' */
#define T_INC           279     /* '++' */
#define T_DEC           280     /* '--' */
#define T_ADDEQ         281     /* '+=' */
#define T_SUBEQ         282     /* '-=' */
#define T_MULEQ         283     /* '*=' */
#define T_DIVEQ         284     /* '/=' */
#define T_REMEQ         285     /* '%=' */
#define T_ANDEQ         286     /* '&=' */
#define T_OREQ          287     /* '|=' */
#define T_XOREQ         288     /* '^=' */
#define T_SHLEQ         289     /* '<<=' */
#define T_SHREQ         290     /* '>>=' */
#define T_CC            291     /* '::' */
#define T_MEMREF        292     /* '->' */
#define _TMAX           292

/* function argument structure */
typedef struct argument {
    char *arg_name;             /* argument name */
    struct argument *arg_next;  /* next argument */
} ARGUMENT;

/* literal structure */
typedef struct literal {
    VALUE lit_value;            /* literal value */
    struct literal *lit_next;   /* next literal */
} LITERAL;
