# include "stdio.h"
# include "math.h"
# include "mcodef.h"


int accept(int dim, float par_vec[], int adapt, int *finish_ptr,
           float constraint[], int *nocont)
/**C*F****************************************************************
**                                                                  **
** SRC-FUNCTION   :accept()                                         **
** LONG_NAME      :accept                                           **
**                                                                  **
** AUTHOR         :Rainer Storn                                     **
**                                                                  **
** DESCRIPTION    :accept() tests whether a parameter vector        **
**                 par_vec[] falls into the region of acceptability **
**                 (ROA). If it does hit=1 is returned, otherwise   **
**                 hit=0.                                           **
**                                                                  **
** FUNCTIONS      :none                                             **
**                                                                  **
** GLOBALS        :none                                             **
**                                                                  **
** PARAMETERS     :dim          number of vector elements.          **
**                 par_vec[]    contains the vector with dim        **
**                              gaussian distributed variables.     **
**                 adapt        control variable.                   **
**                              0 : no adaptation of ROA            **
**                              1 : adaptation of ROA permitted     **
**                                  (shrinkage)                     **
**                              2 : adaptation of ROA permitted     **
**                                  (relaxation, expansion)         **
**                 finish_ptr   indicates meeting of requirements.  **
**                              0 : goals not yet reached.          **
**                              1 : goals has been reached.         **
**                 constraint[] contains current constraints of ROA.**
**                 *nocont      contains number of constraints.     **
**                                                                  **
** PRECONDITIONS  :par_vec[] must contain valid parameter vector.   **
**                                                                  **
** POSTCONDITIONS :Elements of constraint[] will probably be altered.*
**                 nocont returns number of constraints to assist   **
**                 printing routine of main().                      **
**                 Signs of elements of par_vec[] might also be     **
**                 changed into purely positive signs (quick and    **
**                 dirty).                                          **
**                                                                  **
***C*F*E*************************************************************/
{
  int   hit, i, n;
  float goal[NARY], z0, z1, z2, x, y;

/*------Set up constraints----------------------------------------------*/

  goal[0] = 9.;       /* may-constraint  */
  goal[1] = 16.;      /* must-constraint */
  goal[2] = 14.;      /* must-constraint */

  *nocont = 3;        /* three constraints */

/*------Calculate function values and initializations-------------------*/

  x    = fabs(par_vec[0]);  /* allow only positive values */
  y    = fabs(par_vec[1]);  /* allow only positive values */

  par_vec[0] = x;
  par_vec[1] = y;

  z0   = x + y;
  z1   = (x-3)*(x-3) + (y-2)*(y-2);
  z2   = x*y;

  hit  = 1;


/*------Relax constraints if adapt equals 2.---------------------------------*/


  if (adapt == 2)
  {
    for (i=0; i<=2; i++)  /* Initialize constraints to goal values */
    {
      constraint[i] = goal[i];
    }

/*--Relax may-constraints totally--------------------------------------------*/

    constraint[0] = 0;

/*--Relax must-constraints as required---------------------------------------*/

    if (z1 > constraint[1]) constraint[1] = z1;

    if (z2 > constraint[2]) constraint[2] = z2;

  }
  else if (adapt == 1)
  {                       /*--------must-constraints must be fulfilled first---*/
    if (z1 <= constraint[1])
    {
      if (z1 > goal[1]) constraint[1] = z1;   /* adapt must-constraint only if */
      else constraint[1] = goal[1];           /* goal is not reached yet.      */
    }
    else
    {
      hit = 0;
    }
    if (z2 <= constraint[2])                  /* adapt must-constraint only if */
    {                                         /* goal is not reached yet.      */
      if (z2 > goal[2]) constraint[2] = z2;
      else constraint[2] = goal[2];
    }
    else
    {
      hit = 0;
    }
    if ((constraint[1] == goal[1]) && (constraint[2] == goal[2])) /* may constraint will */
    {                                                   /* be regarded when    */
                                                        /* must constraints are*/
                                                        /* fulfilled.          */
      if (z0 >= constraint[0])   /* may-constraint can always be improved */
      {
        constraint[0] = z0;
      }
      else
      {
        hit = 0;
      }
    }
  }
  else
  {
    if (z0 < constraint[0]) hit = 0;

    if (z1 > constraint[1]) hit = 0;

    if (z2 > constraint[2]) hit = 0;
  }


  *finish_ptr = 0;
  if ((constraint[0] >= goal[0]) && (constraint[1] <= goal[1])
                            && (constraint[2] <= goal[2])) *finish_ptr = 1;

  return(hit);

}
