/****	code generation section
	(C)opyright 1995, Thor R. Mirchandani
	All Rights Reserved
*/
#include <stdlib.h>
#include "lite.h"
static int lowterm=LOWTERM,hiterm;
/* check for valid FIRST(n) */
void check_FIRST_FOLLOW(NON_LIST *n){
	int i;
	TOK_LIST *t;
	fprintf(out,"\tif(");
	for(i=0;n->first[i]!=-1;i++)
		if(n->first[i]<lowterm)
			fprintf(out,"%s(!match('%c'))",i?"&&":"",n->first[i]);
		else
			for(t=tok_list.next;t;t=t->next)
				if(t->idx==n->first[i]){
					fprintf(out,"%s(!match(%s))",i?"&&":"",t->name);
					break;
				}
/* for nullable we need to consider follow set, too */
	if(n->empty)
		for(i=0;n->follow[i]!=-1;i++)
			if(n->follow[i]<lowterm)
				fprintf(out,"&&(!match('%c'))",n->follow[i]);
			else
				for(t=tok_list.next;t;t=t->next)
					if(t->idx==n->follow[i]){
						fprintf(out,"&&(!match(%s))",t->name);
						break;
					}
	if(n==top)	/* top non-terminal matches EOI */
		fprintf(out,"&&(!match(EOI))");
	fprintf(out,"){\n\t\tyyerror(\"%s\");\n\t\texit(1);\n\t}\n",n->name);
}
/* check every rule associated with a non-terminal */
void check_every_rule(NON_LIST *n,int empty){
	RUL_LIST *r;
	for(r=rul_list.next;r;r=r->next){
		int i;
		if(n->idx!=r->owner)
			continue;
		if(r->prod[0]==r->owner){
			continue;
		}
		if(r->prod[0]==empty)
			continue;
		if(n==top) 	/* for top: match on EOI, note that we return 2 */
			fprintf(out,"\telse if(match(EOI)){\n\t\treturn 2;\n\t}\n");
		fprintf(out,"\telse if(");
		/**** if(match()...) condition */
		/* match a single char operator token */
		if(r->prod[0]<lowterm){
			fprintf(out,"match('%c')){\n\t\tnext();\n",r->prod[0]);
		}
		/* match a terminal token */
		else if(r->prod[0]<=hiterm){
			TOK_LIST *t;
			for(t=tok_list.next;t;t=t->next)
				if(r->prod[0]==t->idx) break;
			fprintf(out,"match(%s)){\n\t\tnext();\n",t->name);
		}
		/* match FIRST() set of non-terminal */
		else{
			NON_LIST *n1;
			int j;
			for(n1=non_list.next;n1;n1=n1->next)
				if(n1->idx==r->prod[0])
					break;
			for(j=0;n1->first[j]!=-1;j++){
				if(n1->first[j]<lowterm){
					fprintf(out,"%smatch('%c')",j?"||":"",n1->first[j]);
				}
				else if(n1->first[j]<=hiterm){
					TOK_LIST *t;
					for(t=tok_list.next;t;t=t->next)
						if(n1->first[j]==t->idx) break;
					fprintf(out,"%smatch(%s)",j?"||":"",t->name);
				}
			}
			/* if the symbol is nullable we need to match follow set, too! */
			if(n1->empty){
				for(j=0;n1->follow[j]!=-1;j++){
					if(n1->follow[j]<lowterm){
						fprintf(out,"||match('%c')",n1->follow[j]);
					}
					else if(n1->follow[j]<=hiterm){
						TOK_LIST *t;
						for(t=tok_list.next;t;t=t->next)
							if(n1->follow[j]==t->idx) break;
						fprintf(out,"||match(%s)",t->name);
					}
				}
			}
			fprintf(out,"){\n");
		}
		for(i=0;r->prod[i];i++){
			if(r->prod[i]<lowterm){
				if(!i)
					continue;
				fprintf(out,"\t\tif(match('%c'))\n\t\t\tnext();\n",
					r->prod[i]);
				fprintf(out,
			"\t\telse{\n\t\t\tyyerror(\"'%c'\");\n\t\t\treturn 1;\n\t\t}\n",
					r->prod[i]);
			}
			else if(r->prod[i]<=hiterm){
				TOK_LIST *t;
				if(!i)
					continue;
				for(t=tok_list.next;t;t=t->next)
					if(r->prod[i]==t->idx) break;
				fprintf(out,"\t\tif(match(%s))\n\t\t\tnext();\n",
					t->name);
				fprintf(out,
				"\t\telse{\n\t\t\tyyerror(\"%s\");\n\t\t\treturn 1;\n\t\t}\n",
					t->name);
			}
			else{
				NON_LIST *n1;
				for(n1=non_list.next;n1;n1=n1->next)
					if(n1->idx==r->prod[i])
						break;
				fprintf(out,
			"\t\tif(%s_parse()){\n\t\t\tyyerror(\"%s\");\n\t\t\treturn 1;\n\t\t}\n",
					n1->name,n1->name);
			}
		}
		fprintf(out,"\t}\n");
	}
	if(n->empty){	/* if nullable we must match on follow set */
		int j;
		fprintf(out,"\telse if(");
		for(j=0;n->follow[j]!=-1;j++){
			if(n->follow[j]<lowterm){
				fprintf(out,"%smatch('%c')",j?"||":"",n->follow[j]);
			}
			else if(n->follow[j]<=hiterm){
				TOK_LIST *t;
				for(t=tok_list.next;t;t=t->next)
					if(n->follow[j]==t->idx) break;
					fprintf(out,"%smatch(%s)",j?"||":"",t->name);
			}
		}
		fprintf(out,"){\n\t\treturn 0;\n\t}\n");
	}
	fprintf(out,"\telse return 1;\n");
}
/* function skeleteon */
void gen_function(NON_LIST *n,int empty){
	char *name;
	if(n==top){
		name="yyparse";
		fprintf(head,"#define %s_parse yyparse\n",n->name);
		fprintf(head,"int yyparse(void);\n");
		fprintf(out,"int yyparse(void){\n");
	}
	else{
		name=n->name;
		fprintf(head,"int %s_parse(void);\n",name);
		fprintf(out,"\nint %s_parse(void){\n",name);
	}
	fprintf(head,"int %s_action(void);\n",name);
	check_FIRST_FOLLOW(n);
	check_every_rule(n,empty);
	fprintf(out,"\t%s_action();\n\treturn 0;\n}\n",name);
	fprintf(out,"\nint %s_action(void){\n\treturn 0;\n}\n",name);
}
/** entry point into code generation
*/
int gen_code(void){
	NON_LIST *n;
	TOK_LIST *e;
	int empty;
	hiterm=tok_list.next->idx;
	empty=(NULL!=(e=find_tok("EMPTY")))?empty=e->idx:0;
	for(n=non_list.next;n;n=n->next)
		gen_function(n,empty);
	return 0;
}
/*********** end of file ************/