/*****	parsing functions for definition section, and user subroutine section
	(C)opyright 1995, Thor R. Mirchandani
	All Rights Reserved
*/
#include <stdlib.h>
#include "lite.h"
int defnum=LOWTERM;
/* error reporting function */
void yyerror(char *msg){
	fprintf(stderr,"Line %d: %s : %s",lineno,msg,inbuf);
}
TOK_LIST tok_list={NULL,0,(TOK_LIST *)NULL};
/* add a new termonal token to list */
void add_token(void){
	TOK_LIST *p;
	static char buffer[33];
	if(NULL==(p=(TOK_LIST *)malloc(sizeof(TOK_LIST)))){
		yyerror("Internal Error Adding Token:");
		exit(1);
	}
	strncpy(buffer,yytext,(yyleng>32)?32:yyleng)[(yyleng>32)?32:yyleng]='\0';
	fprintf(head,"#define %s %d\n",buffer,defnum);
	p->name=strdup(buffer);
	p->next=tok_list.next;
	p->idx=defnum++;
	tok_list.next=p;
}
#ifdef LIST
void trace_tok_list(void){
	TOK_LIST *p;
	for(p=tok_list.next;p;p=p->next)
		fprintf(stdout,"%s %d\n",p->name,p->idx);
}
#else
#define trace_tok_list()
#endif
int def_sect(void){
	if(NULL==(head=fopen("yyleo.h","wb"))||NULL==(out=fopen("yyleo.c","wb")))
		return fprintf(stderr,"leopard: output file error.\n");
	fprintf(head,"#define YYSTYPE int\n"
				 "int match(int);\nvoid next(void);\n"
				 "void yyerror(char *);\n");
	fprintf(out,"#include \"yyleo.h\"\n");
	fprintf(out,"#include <stdlib.h>\n");
	while(!match(EOI)){
		/* %token directive */
		if(match(TOKEN)){
			next();
			/* can have multiple tokens on a line */
			while(match(ID)){
				add_token();
				next();
			}
			/* CR or LF ends token directive */
			if(!match(CRLF)){
				yyerror("Expecting token");
				return -1;
			}
		}
		/* end of definition section */
		else if(match(NEW_SECT)){
			next();
			break;
		}
		/* any number of new lines allowed */
		else if(match(CRLF))
			next();
		/* unexexpected characters */
		else{
			yyerror("Syntax error");
			return -1;
		}
	}
	trace_tok_list();
	return 0;
}
/* the user section is copied verbatim from input to output file */
int user_sect(void){
	while(!feof(in)){
		fgets(inbuf,LINELEN,in);
		fprintf(out,"%s",inbuf);
	}
	return 0;
}
/*************** end of file ***************************************/