{ ========================================================================= }
{                                                                           }
{                                                 !!                        }
{              !!!!!!!! !!!!!!  !!    !!          !!                        }
{              !! !! !!  !!  !! !!!  !!!                                    }
{              !  !!  !  !!  !! !!!!!!!!  !!!!   !!!  !! !!!                }
{                 !!     !!!!!  !! !! !!     !!   !!   !!  !!               }
{                 !!     !!  !! !!    !!  !!!!!   !!   !!  !!               }
{                 !!     !!  !! !!    !! !!  !!   !!   !!  !!               }
{                 !!     !!  !! !!    !! !!  !!   !!   !!  !!               }
{                !!!!   !!!!!!  !!    !!  !!! !! !!!!  !!  !!               }
{                                                                           }
{ ========================================================================= }
{                     Copyright  1995, Greg Truesdell                      }
{ ========================================================================= }
Unit TBMain;

{ ========================================================================= }
                                 Interface
{ ========================================================================= }

Uses
  WinTypes, WinProcs, Messages,
  Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  SysUtils,
  DCossAPI, TBasicIn, Oxsplits;

Type
  TTBasicExample = class(TForm)
    MainMenu: TMainMenu;
    FileMenu: TMenuItem;
    OpenItem: TMenuItem;
    SaveItem: TMenuItem;
    ExitItem: TMenuItem;
    N1: TMenuItem;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    StatusBar: TPanel;
    SpeedPanel: TPanel;
    OpenBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    ExitBtn: TSpeedButton;
    BI: TBasicInterpreter;
    Panel1: TPanel;
    Panel2: TPanel;
    biRun: TSpeedButton;
    biStop: TSpeedButton;
    Splitter: ToxSplit;
    Script: TMemo;
    Trace: TMemo;
    Panel4: TPanel;
    TracePanel: TPanel;
    biTrace: TSpeedButton;
    biNew: TSpeedButton;
    biHelp: TSpeedButton;

    { basic interpreter events }
    Procedure BIBasTrace(var Cancel: Boolean; var BasTraceState: TBasTraceState);
    Procedure BIBeforeExec(var Cancel: Boolean);
    Procedure BIEndOfText(LineNo: Integer);
    Procedure BINewLine(LineNo: Integer; var Cancel: Boolean);
    Procedure BINextParse(var Cancel: Boolean);
    Procedure BISyntaxError(var Continue: Boolean; msg: String);

    { form events }
    Procedure FormActivate(Sender: TObject);
    Procedure FormClose(Sender: TObject; var Action: TCloseAction);
    Procedure FormPaint(Sender: TObject);
    Procedure FormResize(Sender: TObject);
    Procedure ShowHint(Sender: TObject);

    { buttons }
    Procedure biHelpClick(Sender: TObject);
    Procedure biNewClick(Sender: TObject);
    Procedure biRunClick(Sender: TObject);
    Procedure biStopClick(Sender: TObject);
    Procedure biTraceClick(Sender: TObject);
    Procedure ExitItemClick(Sender: TObject);
    Procedure OpenItemClick(Sender: TObject);
    Procedure SaveItemClick(Sender: TObject);
    procedure BINumExprLoop(var Results: OpenString; vType: Integer;
      var Break, Cancel: Boolean);

  Private
    { Private declarations }
    TraceOn : Boolean;
    Procedure SetTrace( switch:boolean );

  Public
    { Public declarations }
  end;

Var
  TBasicExample: TTBasicExample;

{ ========================================================================= }
                               Implementation
{ ========================================================================= }

{uses About;}

Var
  tkTrace   : Integer;
  tkOn      : Integer;
  tkOff     : Integer;
  tkTime    : Integer; { numeric function - version of this program }

{$R *.DFM}

{ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ }
{                     T B a s i c I n t e r p r e t e r                     }
{                                E V E N T S                                }
{ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    To attach and utilize the TBasicInterpreter component, you should
    keep the following points in mind.

    1.  Use the OnBeforeExec Event to add any new Keywords the program
        will need.  You may also create and initialize any pre-defined
        variables.

    2.  Use the OnNextParse Event to detect and process your Keywords. If
        a syntax error occurs, set the Cancel parameter to TRUE to inform
        the TBasicInterpreter Component that you want to quit.

    3.  Use the OnSyntaxError Event to implement message handling for
        syntax errors.  Remember to set the Continue parameter to FALSE
        if the error should stop execution of the script.

    4.  Use the OnNumExprLoop Event to process your custom Numeric
        Functions.  Remember to use the RegisterNumeric() procedure to
        register the token as a numeric function.

        For example: To Add a function called "IsLightOn" then:

            (* global declaration *)

            Var tkIsLightOn : Integer;
            ...

            (* in the OnBeforeExecute event *)

            tkIsLightOn := KeyList.AddKey('IsLightOn',True);
            RegisterNumeric(tkIsLightOn);
            ...

            (* in the OnNumExprLoop event *)

            if Token = tkIsLightOn then begin
                (* do whatever it does *)
                (* if a syntax error occurs set Cancel := True *)
                Results := (* whatever it is *)
                Exit;
            end;


    5.  Use the OnStrExprLoop Event to process your custom String
        Function.   Remember to use the RegisterFunction() procedure to
        register the token as a string function.

{ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ }



{ ========================================================================= }
{                        B  I  B e f o r e  E x e c                         }
{ ========================================================================= }
Procedure TTBasicExample.BIBeforeExec(var Cancel: Boolean);
begin
  with BI do begin
    tkTrace   := KeyList.AddKey('Trace',True);
    tkOn      := KeyList.AddKey('On',True);
    tkOff     := KeyList.AddKey('Off',True);
    { here is an example of a numeric function }
    tkTime    := KeyList.AddKey('Time',True);
    RegisterNumeric(tkTime);
  end;
  SetTrace(False);
end;

{ ========================================================================= }
{                         B  I  N e x t  P a r s e                          }
{ =========================================================================
    Add code here to detect your tokens and handle tokens not handled by
    TBasicInterpreter.  Remember to handle the tkEnd token!
{ ========================================================================= }
Procedure TTBasicExample.BINextParse(var Cancel: Boolean);
begin

  with BI do begin
    { adding the Trace On, Trace Off commands }
    if Token = tkTrace then begin
      NextToken;
      if TokenInSetOf( Token, [tkOn, tkOff] ) then begin
        if Token = tkOn
          then SetTrace(True)
          else SetTrace(False);
        Exit;
      end
      else begin
        ErrorMessage('Trace command requires "ON" or "OFF"');
        Cancel := True;
        Exit;
      end;
      Exit;
    end
    { handle the End statement }
    else if Token = tkEnd then begin
      BasicTrace('End','');
      bi.Execute := False;
      Cancel := True;
      Exit;
    end;
  end;

  { falling through to here means a Syntax Error }
  ShowMessage('Syntax Error: "'+bi.Keyword+
    '" is undefined at Line ' + IntToStr(bi.CurrentLine+1) +
    ', Column '+ IntToStr(bi.CurrentIndex) + '.');
  Cancel := True;
end;

{ ========================================================================= }
{                       B  I  N u m  E x p r  L o o p                       }
{ ========================================================================= }
Procedure TTBasicExample.BINumExprLoop(var Results: OpenString;
  vType: Integer; var Break, Cancel: Boolean);
begin
  with BI do begin

    { this is a very simple numeric function, but }
    { it demonstrates the concept }
    if Token = tkTime then begin
      { returns the Delphi time as a float value }
      Str(Time,Results);
    end;

  end;
end;

{ ========================================================================= }
{                           B  I  N e w  L i n e                            }
{ =========================================================================
    Using this event to display executing line numbers definately slows
    the interpreter down, but lets you know where it is.
{ ========================================================================= }
Procedure TTBasicExample.BINewLine(LineNo: Integer; var Cancel: Boolean);
begin
  StatusBar.Caption := 'Run: Line '+IntToStr(LineNo)+
    ' of '+IntToStr(BI.Text.Count);
  Application.ProcessMessages;
end;

{ ========================================================================= }
{                          B  I  B a s  T r a c e                           }
{ ========================================================================= }
Procedure TTBasicExample.BIBasTrace(var Cancel: Boolean; var BasTraceState: TBasTraceState);
  { return a string of count spaces }
  Function spaces(count:integer):String;
  var ii : Integer;
  begin
    Result := '';
    for ii := 1 to count do
      Result := concat(Result,' ');
  end;
  { return a string with tabs packed to a space }
  Function pack(txt:String):String;
  var ii : Integer;
  begin
    if txt[0]=#0 then Exit;
    for ii := 1 to byte(txt[0]) do begin
      if txt[ii]=#9 then txt[ii]:=' ';
    end;
    Result:=txt;
  end;
begin
  with BasTraceState, Trace.Lines do begin
    try
      Add(' Action:'+Action+' at '+IntToStr(CurrentLine)+','+IntToStr(CurrentIndex));
      Add(' Text  :'+Pack(LineText));
      Add('========'+spaces(CurrentIndex-1)+'^');
    except
    end;
  end;
end;

{ ========================================================================= }
{                       B  I  S y n t a x  E r r o r                        }
{ =========================================================================
    In this example, I am using the Syntax Error to locate the bad
    item in the script editor, select the item, then set the focus to
    the script editor.

    Remember to set Continue := FALSE if you don't want the program to
    continue after the error.
{ ========================================================================= }
Procedure TTBasicExample.BISyntaxError(var Continue: Boolean; msg: String);
var loc : Word;
    ofs : Byte;
begin
  ShowMessage(msg);

  { add an offset of 2 characters for string constants }
  { to include the quotes }
  ofs := 0;
  if bi.Token = NT_STRING_CONSTANT then ofs := 2;
  loc := bi.LocateTextAt(bi.CurrentLine, bi.CurrentIndex);
  Script.SelStart := loc-(Length(bi.Keyword)+ofs);
  Script.SelLength := Length(bi.Keyword)+ofs;
  Script.SetFocus;

  Continue := False;
end;

{ ========================================================================= }
{                         B  I  E n d  O f  T e x t                         }
{ ========================================================================= }
Procedure TTBasicExample.BIEndOfText(LineNo: Integer);
begin
  StatusBar.Caption :=
    'End of Execution at Line ' + IntToStr(LineNo+1)+
    ', Column ' + IntToStr(bi.CurrentIndex);
end;




{ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ }
{                                B U T T O N                                }
{                               M E T H O D S                               }
{ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ }



{ ========================================================================= }
{                        E x i t  I t e m  C l i c k                        }
{ ========================================================================= }
Procedure TTBasicExample.ExitItemClick(Sender: TObject);
begin
  Close;
end;

{ ========================================================================= }
{                        O p e n  I t e m  C l i c k                        }
{ ========================================================================= }
Procedure TTBasicExample.OpenItemClick(Sender: TObject);
begin
  if OpenDialog.Execute then begin
    Script.Lines.LoadFromFile(OpenDialog.Filename);
    Caption := 'File: ' + OpenDialog.Filename;
    SaveDialog.Filename := OpenDialog.Filename;
  end;
end;

{ ========================================================================= }
{                        S a v e  I t e m  C l i c k                        }
{ ========================================================================= }
Procedure TTBasicExample.SaveItemClick(Sender: TObject);
begin
  if SaveDialog.Execute then begin
    Script.Lines.SaveToFile(SaveDialog.Filename);
    Caption := 'File: ' + SaveDialog.Filename;
  end;
end;

{ ========================================================================= }
{                           b i  R u n  C l i c k                           }
{ =========================================================================
    Here is where the script gets started.  Remember to check if the
    editor has text.  Otherwise, TScriptParser will complain with a
    possible Exeception.
{ ========================================================================= }
Procedure TTBasicExample.biRunClick(Sender: TObject);
begin
  Trace.Lines.Clear;
  with BI do begin
    { assign the editor's lines to the parser's text property }
    Text.Assign(Script.Lines);
    if Text.Count = 0 then begin
      ShowMessage('Nothing to Execute.');
      Exit;
    end;
    { flip the state of biRun and biStop }
    biRun.Enabled := False;
    biStop.Enabled := True;
    { execute the program }
    Execute := True;
    { flip the execute buttons back }
    biRun.Enabled := True;
    biStop.Enabled := False;
  end;
end;

{ ========================================================================= }
{                          b i  S t o p  C l i c k                          }
{ ========================================================================= }
Procedure TTBasicExample.biStopClick(Sender: TObject);
begin
  { tell the parser to stop }
  BI.Execute := False;
  { reset the execution buttons }
  biRun.Enabled := True;
  biStop.Enabled := False;

  StatusBar.Caption := 'Cancelled.';
end;

{ ========================================================================= }
{                             S e t  T r a c e                              }
{ ========================================================================= }
Procedure TTBasicExample.SetTrace( switch:boolean );
begin
  TracePanel.Visible := switch;
  Trace.Visible := switch;
  TraceOn := switch;
  bi.TraceBasic := TraceOn;
  if TraceOn
    then Splitter.BarPosition := Splitter.Height div 2
    else Splitter.BarPosition := Splitter.Height;
end;

{ ========================================================================= }
{                         b i  T r a c e  C l i c k                         }
{ ========================================================================= }
Procedure TTBasicExample.biTraceClick(Sender: TObject);
begin
  SetTrace(not TraceOn);
end;

{ ========================================================================= }
{                           b i  N e w  C l i c k                           }
{ ========================================================================= }
Procedure TTBasicExample.biNewClick(Sender: TObject);
begin
  Script.Lines.Clear;
  Caption := 'TBasic';
  SaveDialog.Filename := '';
end;

{ ========================================================================= }
{                          b i  H e l p  C l i c k                          }
{ ========================================================================= }
Procedure TTBasicExample.biHelpClick(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;



{ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ }
{                           F o r m   E V E N T S                           }
{ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ }




{ ========================================================================= }
{                         F o r m  A c t i v a t e                          }
{ ========================================================================= }
Procedure TTBasicExample.FormActivate(Sender: TObject);
begin
  SetTrace(False);
end;

{ ========================================================================= }
{                           F o r m  R e s i z e                            }
{ ========================================================================= }
Procedure TTBasicExample.FormResize(Sender: TObject);
begin
  { try to keep the splitter visible }
  try
    SetTrace(TraceOn);
    {
    if not TraceOn then Splitter.Percent := 99
    else if Splitter.BarPosition > Splitter.Height then
      Splitter.Percent := 75;}
  except
  end;
end;

{ ========================================================================= }
{                            F o r m  P a i n t                             }
{ ========================================================================= }
Procedure TTBasicExample.FormPaint(Sender: TObject);
const TabWidth : Integer = 12;
begin
  { set tab stops to ~4 characters }
  Script.Perform(EM_SETTABSTOPS, Word(1), LongInt(@TabWidth));
end;

{ ========================================================================= }
{                             S h o w  H i n t                              }
{ ========================================================================= }
Procedure TTBasicExample.ShowHint(Sender: TObject);
begin
  StatusBar.Caption := Application.Hint;
end;

{ ========================================================================= }
{                            F o r m  C l o s e                             }
{ ========================================================================= }
Procedure TTBasicExample.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Application.HelpCommand(HELP_QUIT, 0);
end;


End.

{ ========================================================================= }
{                                   E O F                                   }
{ ========================================================================= }

