@ECHO OFF
@ECHO PACKAGE.BAT -- DC Software, 1996

if x%1 == x    goto USAGE
if x%2 == x    goto USAGE
if x%3 == x    goto USAGE

set ALT=%4
set RES=%5
if x%4 == x    goto SKIP0
if NOT EXIST %4\dcctoken.dat goto BAD_SUP
if x%5 == x    goto SKIP1
if x%5 == xVLO goto SKIP2
if x%5 == xVHI goto SKIP2
if x%5 == xVH1 goto SKIP2
if x%5 == xVH2 goto SKIP2
if x%5 == xVH3 goto SKIP2
if x%5 == xvlo goto SKIP2
if x%5 == xvhi goto SKIP2
if x%5 == xvh1 goto SKIP2
if x%5 == xvh2 goto SKIP2
if x%5 == xvh3 goto SKIP2

goto BAD_RES

:SKIP0
set ALT=..\bin

:SKIP1
set RES=VH?

:SKIP2

if NOT EXIST WORLD.IDX   goto NO_GAME
if NOT EXIST WORLD.000   goto NO_GAME
if NOT EXIST PLAYERS.DTA goto NO_GAME
if NOT EXIST PARAMS.DTA  goto NO_GAME

if x%3 == xA: goto diskette
if x%3 == xa: goto diskette
if x%3 == xB: goto diskette
if x%3 == xb: goto diskette

mkdir %3
if NOT EXIST %3\world.idx goto START

@ECHO WARNING: Delete all files in %3 ? (DEL %3\*.*) (Y/N)
yorn
if errorlevel 1 goto KEEPEM
del %3\*.*
goto START

:KEEPEM
@ECHO Do you want go copy OVER the existing files in %3 ? (Y/N)
yorn
if errorlevel 1 goto THE_END

:START
cd %2

@ECHO Ok, now copying files...

copy world.idx    %3 >NUL
if exist world.0?? copy world.0??    %3 >NUL
if exist world.1?? copy world.1??    %3 >NUL
if exist world.2?? copy world.2??    %3 >NUL
if exist world.3?? copy world.3??    %3 >NUL
if exist world.4?? copy world.4??    %3 >NUL
if exist world.5?? copy world.5??    %3 >NUL
if exist world.6?? copy world.6??    %3 >NUL
if exist world.7?? copy world.7??    %3 >NUL
if exist world.8?? copy world.8??    %3 >NUL
if exist world.9?? copy world.9??    %3 >NUL

if exist worldo.0?? copy worldo.0??   %3 >NUL
if exist worldo.1?? copy worldo.1??   %3 >NUL
if exist worldo.2?? copy worldo.2??   %3 >NUL
if exist worldo.3?? copy worldo.3??   %3 >NUL
if exist worldo.4?? copy worldo.4??   %3 >NUL
if exist worldo.5?? copy worldo.5??   %3 >NUL
if exist worldo.6?? copy worldo.6??   %3 >NUL
if exist worldo.7?? copy worldo.7??   %3 >NUL
if exist worldo.8?? copy worldo.8??   %3 >NUL
if exist worldo.9?? copy worldo.9??   %3 >NUL

copy players.dta  %3 >NUL
copy text.dta     %3 >NUL
copy params.dta   %3 >NUL
copy hint.dta     %3 >NUL

if EXIST *.PCX copy *.pcx        %3 >NUL
if EXIST *.GIF copy *.gif        %3 >NUL

if NOT EXIST control.scr goto :NO_SCRIPTS

@ECHO Now re-compiling all script files
for %%i in (*.scr) do dcc %%i


@ECHO Include SCRIPT SOURCES? (*.SCR) (Y/N)
yorn
if errorlevel 1 goto NO_SCRIPTS

copy *.scr        %3 >NUL

:NO_SCRIPTS

copy *.sco        %3 >NUL


@ECHO Include Music Files (*.cmf and *.mid)? (Y/N)
yorn
if errorlevel 1 goto NO_MUSIC

if EXIST *.cmf copy *.cmf        %3 >NUL
if EXIST *.mid copy *.mid        %3 >NUL

:NO_MUSIC

@Echo Include Sound Resources (*.VOC and *.RSC)? (Y/N)
yorn
if errorlevel 1 goto NO_SOUNDS

if EXIST *.VOC copy *.VOC        %3 >NUL
if EXIST *.RSC copy *.RSC        %3 >NUL
if NOT EXIST DCSOUNDS.RSC COPY %ALT%\DCSOUNDS.RSC %3

if EXIST DCCTOKEN.DAT COPY DCCTOKEN.DAT %3 >NUL
if NOT EXIST DCCTOKEN.DAT COPY %ALT%\DCCTOKEN.DAT %3

if EXIST DCFONTS.7x5  COPY DCFONTS.7X5  %3 >NUL
if NOT EXIST DCFONTS.7x5  COPY %ALT%\DCFONTS.7X5  %3

if NOT EXIST %1.EXE GOTO NO_EXE
COPY %1.EXE %3 >NUL
@ECHO Warning: I copied a file "%1.EXE" assuming it is the renamed game
@ECHO driver (original name DCPLAY[P].EXE). If this is NOT the case, I
@ECHO can still copy DCPLAY[P].EXE.  Do you want to do this? (Y/N)
yorn
if errorlevel 1 goto EXE_DONE

:NO_EXE

if EXIST DOS4GW.EXE goto PROTECTED
if EXIST %ALT%\DOS4GW.EXE goto PROTECTED
goto NOT_PROTECTED

:PROTECTED
if     EXIST DCPLAYP.EXE COPY DCPLAY.EXE %3\%1.EXE >NUL
if NOT EXIST DCPLAYP.EXE COPY %ALT%\DCPLAYP.EXE %3\%1.EXE >NUL
if NOT EXIST %3\%1.EXE goto WARN1

@ECHO Copying PROTECTED MODE files
if     EXIST DOS4GW.EXE COPY DOS4GW.EXE %3 >NUL
if NOT EXIST DOS4GW.EXE COPY %ALT%\DOS4GW.EXE %3 >NUL

goto EXE_DONE

:WARN1
@ECHO Warning: Found DOS4GW but not DCPLAYP.EXE, trying to use DCPLAY.EXE
pause

:NOT_PROTECTED

if     EXIST DCPLAY.EXE COPY DCPLAY.EXE %3\%1.EXE >NUL
if NOT EXIST DCPLAY.EXE COPY %ALT%\DCPLAY.EXE %3\%1.EXE >NUL

:EXE_DONE

if EXIST %3\%1.EXE goto GOODEXE

@ECHO Warning: Couldn't find DCPLAY.EXE, DCPLAYP.EXE or %1.EXE!
pause

:GOODEXE


@ECHO Now copying graphics files
if     EXIST DCBLOCK0.%RES% COPY *.%RES% %3 >NUL
if NOT EXIST DCBLOCK0.%RES% COPY %ALT%\*.%RES% %3 >NUL

if NOT EXIST *.TXT goto NO_TXT
dir *.txt | FIND "TXT"
@ECHO Copy these TXT files ?
yorn
if errorlevel 1 goto NO_TXT
copy *.txt %3 >NUL

:NO_TXT
if NOT EXIST *.DOC goto NO_DOC
dir *.DOC | FIND "DOC"
@ECHO Copy these DOC files ?
yorn
if errorlevel 1 goto NO_DOC
copy *.doc %3 >NUL

:NO_DOC
if NOT EXIST *.BAT goto NO_BAT
dir *.BAT | FIND "BAT"
@ECHO Copy these BAT files?
yorn
if errorlevel 1 goto NO_BAT
copy *.bat %3 >NUL

:NO_BAT
if NOT EXIST READ*.* goto NO_READ
dir READ*.* | FIND "READ"
@ECHO Copy these READ files?
yorn
if errorlevel 1 goto NO_READ
copy READ*.* %3 >NUL

:NO_READ
if NOT EXIST FILE_ID.DIZ goto NO_DIZ
@ECHO Copy the FILE_ID.DIZ file?
yorn
if errorlevel 1 goto NO_DIZ
copy FILE_ID.DIZ %3
goto NO_DIZ2

:NO_DIZ
@ECHO NOTE: You should create a file called FILE_ID.DIZ that contains
@ECHO a description of your game in a specific format. A lot of shareware
@ECHO distribution methods count on this file being included.  For an
@ECHO example, find the one that came with DCGAMES!

:NO_DIZ2

goto THE_END

:BAD_SUP
@ECHO Error: Support files not found in %4!
pause
goto USAGE

:BAD_RES
@ECHO Error: Unknown graphics mode (%5)! Use VLO, VHI, VH1, VH2 or VH3
pause
goto USAGE

:NO_GAME
@ECHO Error: File "world.idx" not found!
pause
goto USAGE

:USAGE
@ECHO Usage:
@ECHO    PACKAGE gameid source_dir dest_dir support_dir
@ECHO .
@ECHO Where:
@ECHO    gameid      - Is an 8 character name for your game
@ECHO                  (Copies DCPLAY.EXE to gameid.EXE)
@ECHO    source_dir  - Is the location of your game files
@ECHO                  (use . for "current" directory)
@ECHO    dest_dir    - Is where you want to put the files
@ECHO                  (like a:, b:, c:\here or .\there)
@ECHO    support_dir - Where the DCGAMES files are found
@ECHO                  (default is to look in "source_dir" and
@ECHO                   then in "source_dir\..\bin"
@ECHO    mode        - Optionally specify the graphics mode
@ECHO                  (default is VHI, VH1, VH2 and VH3)
@ECHO .
@ECHO Examples:
@ECHO   package nerak2 . .\distr \dcgames\bin vlo
@ECHO .
@ECHO   package mygame c:\mygame a:


:THE_END


