' Database Creation Procedures
' 1995 Tuomas Salste
' Needs DATACONS.TXT to work
' Include this module in your project if needed

Option Explicit
Global Const DB_COUNTER = -10
Global Const IDX_UNIQUE = True
Global Const IDX_NONUNIQUE = False
Global Const IDX_PRIMARY = True
Global Const IDX_NONPRIMARY = False

' Appends a new field 'FieldName' to a TableDef
Sub AddField (td As TableDef, ByVal FieldName As String, ByVal FieldType As Integer, ByVal Size As Integer)

Dim fl As New Field
fl.Name = FieldName
If FieldType = DB_COUNTER Then
    ' If this gives an error, add DATACONS.TXT to your project
    fl.Type = DB_LONG
    fl.Attributes = fl.Attributes Or DB_AUTOINCRFIELD
Else
    fl.Type = FieldType
End If
If FieldType = DB_TEXT Then fl.Size = Size
td.Fields.Append fl

End Sub

' Appends a new index 'IndexName' to a TableDef
Sub AddIndex (td As TableDef, ByVal IndexName As String, ByVal IndexFields As String, ByVal IndexPrimary As Integer, ByVal IndexUnique As Integer)

Dim idx As New Index
idx.Name = IndexName
idx.Fields = IndexFields
idx.Primary = IndexPrimary
idx.Unique = IndexUnique
td.Indexes.Append idx

End Sub

' Appends a QueryDef 'QueryName' to a database
Sub AddQueryDef (db As Database, ByVal QueryName As String, ByVal SQL As String)

Dim qd As QueryDef
On Error Resume Next
Set qd = db.CreateQueryDef(QueryName, SQL)

End Sub

