/*ͻ*\
                    Medusa Systems, Ind.                                 
                                                                         
                  Software Database Program                              
                                                                         
    Main programer:  John Wiggins                                        
    Course: Program II                                                   
    Due Date: 4/17/95                                                    
    Assignment:  Add & delete records.                                   
    Functionality:  initializes graphics, reads configuration file       
                    (if found), reads in any command parameters,         
                    runs title screen (unless told otherwise by          
                    configure.ShowTitleScreen), initializes mouse,       
                    runs main menu function, and, if jokes are on,       
                    runs morbid happy face gets shot function.           
                                                                         
    TRUE, FALSE, NO, and YES are defined in windw.h.                     
                                                                         
    The following parameters will over ride those settings in the        
    configuration file. (\database.cfg)                                  
    Command Parameters: notitle = no title screen                        
                        debug = create menu visible                      
                        nojoke = no jokes                                
   Calling Map:                                                          
                                                                         
   Function:                    Location:                                
                                                                         
   main			\main-jw.cpp                              
     InitGraphics		\grafx\inigraph.cpp                       
     exist_file                \main-jw.cpp                              
     ReadConfigFile    	\file\readcfg.cpp                         
     TitleScreen		\grafx\title.cpp                          
     	DisplayDisk		\grafx\disk.cpp                           
         LoadImage		\grafx\disk.cpp                           
     GotMouse			\mous.cpp                                 
     SetLimits			\mous.cpp                                 
     ReadMe                    \readme.cpp                               
     MainMenu			\menu\main_mn.cpp                         
       exist_file              \main-jw.cpp                              
         LoadAll 		\file\load_all.cpp                        
       ViewAll	                \file\view_all.cpp                        
       NoDataError             \menu\main_mn.cpp                         
       ERAMenu	                \menu\era_mn.cpp                          
         EditData              \file\edit.cpp                            
           SelectField         \grafx\field.cpp                          
           View2Pick           \file\select.cpp                          
         AddData               \file\add.cpp                             
           MediaBtn            \grafx\media.cpp                          
         DelData               \file\del.cpp                             
           View2Pick           \file\select.cpp                          
         SearchRecord	        \file\search.cpp                          
           SelectField         \grafx\field.cpp                          
           Add2List            \file\addlist.cpp                         
           ViewAll             \file\view_all.cpp                        
       NoDataError             \menu\main_mn.cpp                         
       OptionMenu	        \menu\optn_mn.cpp                         
         JokeToggle            \menu\optn_mn.cpp                         
         TitleScreenToggle     \menu\optn_mn.cpp                         
         SaveOptions	        \menu\optn_mn.cpp                         
         DisplayConfig         \menu\optn_mn.cpp                         
         Help	                \extra\help.cpp                           
       Create	                \file\create.cpp                          
         GetData	        \file\create.cpp                          
         Remove                \file\remove.cpp                          
         LoadAll 		\file\load_all.cpp                        
       About		        \grafx\about.cpp                          
       Quit                    \menu\main_mn.cpp                         
       SaveAll                 \file\saveall.cpp                         
     Ending                    \main-jw.cpp                              
     HaveNiceDay	        \extra\happy.cpp                          
                                                                         
   Found throughout the program (too many places to count):              
                                                                         
   Name           Found in             Function                          
                                           
   FileError       \file\filerr.cpp     Displays error message and exits 
                                        program.                         
   GetEvent       \event.cpp           Get what event has happened.     
   ShowMouse      \mous.cpp            Displays mouse poniter.          
   HideMosue      \mous.cpp            Hides mouse pointer.             
   Windw          \windw.cpp           Basic graphical window class.    
   OKWindw        \windw.cpp           OK window.                       
   YesNoWindw     \windw.cpp           Yes or no window.                
   YesNoCanWindw  \windw.cpp           Yes, no, or cancel window.       
   InputWindw     \windw.cpp           User input window w/Ok and       
                                        Cancel buttons.                  
   My own creations:                                                     
                                                                         
   ItemWindw            \windw.cpp     Same as InputWindw but w/o the    
                                       Cancel button.                    
   ShowRecrdWindw       \msi_wndw.cpp  Shows records (next/last/cancel)  
   DisplayWindw         \msi_wndw.cpp  A good way to display text(list)  
                                                                         
    Through out this program this is how I labeld certain variables.     
    "temp"   = temporary.                                                
    "flag"   = flag                                                      
    "config" = configuration (struct in medusa.h)                        
    "program_info" = program struct in medusa.h                          
                                                                         
     = "Creating Turbo C++ Games" by Clayton Walnum; published by Que.  
\*ͼ*/
#include <graphics.h>
#include <iostream.h>
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include "msi_wndw.h"
#include "medusa.h"
#include "mous.h"  // includes dos.h
#include "windw.h" // includes event.h & string.h

void main(int argc, char **argv)
{
  configure CurConfig;
  // In case a config file doesn't exist AND the user didn't use
  // any parameters.
  CurConfig.DebugFlag = FALSE;
  CurConfig.JokeFlag = FALSE;
  CurConfig.ShowTitleFlag = TRUE;
  // Check to see if file exists.
  int FileExist = exist_file("database.cfg");
  // Read in configuration file (if it exists.)
  // This is placed prior to the parameter testing in order to allow
  // the parameters to over ride those found in the configuration file.
  if (FileExist == TRUE)
    ReadConfigFile(CurConfig);
  // Parameter tests. \\
  // Tests to see if the user has any arguments.
  if (argc >= 2)
  {
    for (int i=1; i < argc; i++)
    {
      if ((strcmp(argv[i], "notitle") == 0) ||
          (strcmp(argv[i], "nojoke") == 0) ||
          (strcmp(argv[i], "debug") == 0))
      {
        if (strcmp(argv[i], "notitle") == 0)
	  CurConfig.ShowTitleFlag = FALSE;
        if (strcmp(argv[i], "nojoke") == 0)
	  CurConfig.JokeFlag = FALSE;
        if (strcmp(argv[i], "debug") == 0)
	  CurConfig.DebugFlag = TRUE;
      }
      // If user used invalid parameters \\
      else
      {
        textcolor(LIGHTRED + BLINK);
	cprintf("Invalid parameter.\n\r");
	textcolor(LIGHTGRAY);
	cout << "Valid options are: " << endl << endl
             << " nojoke  - Disable jokes." << endl
    	     << " notitle - Disables title." << endl
	     << " debug   - Enable create file. (for debuging only)" << endl
             << "Press any key to exit." << endl;
        getch();
        exit(1);
      }
    }
  }
  InitGraphics(); // Starts graphics.
  // Show title screen \\
  if (CurConfig.ShowTitleFlag == TRUE)
  {
    TitleScreen("Software Inventory v3.0");
    // Clear graphics screen.
    cleardevice();
  }
  // Start mouse \\
  mouse.GotMouse();
  // Set mouse screen limits.
  mouse.SetLimits(0, getmaxx() - 10, 0, getmaxy() - 10);
  mouse.ShowMouse();
  // Main Menu windows and buttons \\
  MainMenu(CurConfig);
  // Hide the mouse (otherwise it's shown for the Have Nice Day function.
  mouse.HideMouse();
  // Show ending message \\
  Ending();
  // Funny ending \\
  if (CurConfig.JokeFlag == TRUE)
    HaveNiceDay();
  closegraph();
}

/*ͻ*\
    Name:     John Wiggins                        
    Course:   Programming II (forgot csci number) 
   Function:  Tell user that this is over, fin.  
\*ͼ*/
void Ending()
{
  CapTWindw Ending("Medusa Systems, Ind.", "Thank you for using this",
		    "Software Database program.");
  Ending.DrawWindow();
  sleep(2); // Make sure user sees message.
}

/*ͻ*\
    Name:     John Wiggins                          
    Course:   Programming II (forgot csci number)   
   Function:  Checks for the existance of a file.   
              Returns 1 if file exists, otherwise 0 
\*ͼ*/

int exist_file(char *file_name)
{
  FILE *file_point;
  file_point = (fopen(file_name, "r"));
  if (!file_point)
    return FALSE;
  else
  {
    fclose(file_point);
    return TRUE;
  }
}
