unit Sample1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBScroll, StdCtrls, Spin, Buttons, TabNotBk, DBTables,
  DBCtrls, DB, ExtCtrls;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    TabbedNotebook1: TTabbedNotebook;
    GroupBox2: TGroupBox;
    CheckBoxColLines: TCheckBox;
    CheckBoxFramed: TCheckBox;
    CheckBoxOnOff: TCheckBox;
    CheckBoxRowLines: TCheckBox;
    CheckBoxRowSelect: TCheckBox;
    Panel1: TPanel;
    Label6: TLabel;
    DBNavigator1: TDBNavigator;
    DBNavigator2: TDBNavigator;
    DBNavigator3: TDBNavigator;
    GroupBox4: TGroupBox;
    CheckBoxRowAutoHeight: TCheckBox;
    SpinEditLinesPerRow: TSpinEdit;
    LabelLines: TLabel;
    GroupBox3: TGroupBox;
    CheckBoxShowHeader: TCheckBox;
    CheckBoxShowSelField: TCheckBox;
    CheckBoxScrollBar: TCheckBox;
    DBScroll1: TDBScroll;
    SpeedButton1: TSpeedButton;
    SpeedButtonBack: TSpeedButton;
    SpeedButtonStop: TSpeedButton;
    SpeedButtonGo: TSpeedButton;
    Table1OrderNo: TFloatField;
    Table1CustNo: TFloatField;
    Table1SaleDate: TDateTimeField;
    Table1ShipDate: TDateTimeField;
    Table1EmpNo: TIntegerField;
    Table1ShipToContact: TStringField;
    Table1ShipToAddr1: TStringField;
    Table1ShipToAddr2: TStringField;
    Table1ShipToCity: TStringField;
    Table1ShipToState: TStringField;
    Table1ShipToZip: TStringField;
    Table1ShipToCountry: TStringField;
    Table1ShipToPhone: TStringField;
    Table1ShipVIA: TStringField;
    Table1PO: TStringField;
    Table1Terms: TStringField;
    Table1PaymentMethod: TStringField;
    Table1ItemsTotal: TCurrencyField;
    Table1TaxRate: TFloatField;
    Table1Freight: TCurrencyField;
    Table1AmountPaid: TCurrencyField;
    CheckBoxSort: TCheckBox;
    Image5: TImage;
    LAvail1: TLabel;
    LAvail2: TLabel;
    BitBtnReadMe: TBitBtn;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    MemoField: TMemo;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    CMarginV: TSpinEdit;
    CMarginR: TSpinEdit;
    CMarginL: TSpinEdit;
    GroupBox5: TGroupBox;
    CheckBoxResizeCol: TCheckBox;
    CheckBoxResizeRow: TCheckBox;
    GroupBox6: TGroupBox;
    Label1: TLabel;
    CheckBoxCustomized: TCheckBox;
    Label5: TLabel;
    ListBoxAreas: TListBox;
    ListBoxColors: TListBox;
    ButtonColor: TButton;
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxColLinesClick(Sender: TObject);
    procedure CheckBoxRowLinesClick(Sender: TObject);
    procedure CheckBoxOnOffClick(Sender: TObject);
    procedure CheckBoxFramedClick(Sender: TObject);
    procedure CheckBoxRowSelectClick(Sender: TObject);
    procedure SpinEditLinesPerRowChange(Sender: TObject);
    procedure CMarginVChange(Sender: TObject);
    procedure CMarginLChange(Sender: TObject);
    procedure CMarginRChange(Sender: TObject);
    procedure DoNotFocus(Sender: TObject);
    procedure ScrollBar1Enter(Sender: TObject);
    procedure CheckBoxScrollBarClick(Sender: TObject);
    procedure ListBoxAreasClick(Sender: TObject);
    procedure ListBoxColorsClick(Sender: TObject);
    procedure CheckBoxShowHeaderClick(Sender: TObject);
    procedure CheckBoxShowSelFieldClick(Sender: TObject);
    procedure CheckBoxRowAutoHeightClick(Sender: TObject);
    procedure ButtonColorClick(Sender: TObject);
    procedure CheckBoxResizeColClick(Sender: TObject);
    procedure CheckBoxResizeRowClick(Sender: TObject);
    procedure CheckBoxCustomizedClick(Sender: TObject);
    procedure BitBtnReadMeClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButtonBackClick(Sender: TObject);
    procedure SpeedButtonStopClick(Sender: TObject);
    procedure SpeedButtonGoClick(Sender: TObject);
    procedure MemoFieldDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure MemoFieldDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure TabbedNotebook1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure DBScroll1CellSetTextAndColor(Sender: TObject; ColIndex: Word;
      TextIn, TextOut: PChar; var TxtColor, TxtColorSel: TColor);
    procedure CheckBoxSortClick(Sender: TObject);
  private
    { Private-Deklarationen }
    GoFor, GoBack: Boolean;
    FirstSearch: Boolean;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  GoFor:= False;
  GoBack:= False;
  FirstSearch:= True;

  with DBScroll1 do begin
    CMarginV.Value:= CellMarginVert;
    CMarginL.Value:= CellMarginLeft;
    CMarginR.Value:= CellMarginRight;
    CheckBoxOnOff.Checked:= not (DataSource.State in [dsInActive]);
    CheckBoxFramed.Checked:= Framed;
    CheckBoxColLines.Checked:= dsColLines in Options;
    CheckBoxRowLines.Checked:= dsRowLines in Options;
    CheckBoxRowSelect.Checked:= dsRowSelect in Options;
    CheckBoxSort.Checked:= Header.SortOnLClick or Header.SortOnRClick;

    CheckBoxShowHeader.Checked:= Header.Show;
    CheckBoxShowSelField.Checked:= SelField.Show;
    CheckBoxScrollBar.Checked:= dsScrollBarV in Options;

    CheckBoxRowAutoHeight.Checked:= RowAutoHeight > 0;
    SpinEditLinesPerRow.Visible:= RowAutoHeight > 0;
    LabelLines.Visible:= RowAutoHeight > 0;
    SpinEditLinesPerRow.Value:= RowAutoHeight;

    CheckBoxResizeCol.Checked:= dsColResize in Options;
    CheckBoxResizeRow.Checked:= dsRowResize in Options;
  end;
end;

procedure TForm1.CheckBoxColLinesClick(Sender: TObject);
begin
  if CheckBoxColLines.Checked then
    DBScroll1.Options:= DBScroll1.Options + [dsColLines]
  else
    DBScroll1.Options:= DBScroll1.Options - [dsColLines];
end;

procedure TForm1.CheckBoxRowLinesClick(Sender: TObject);
begin
  if CheckBoxRowLines.Checked then
    DBScroll1.Options:= DBScroll1.Options + [dsRowLines]
  else
    DBScroll1.Options:= DBScroll1.Options - [dsRowLines];
end;

procedure TForm1.CheckBoxOnOffClick(Sender: TObject);
begin
  DBScroll1.DataSource.DataSet.Active:= CheckBoxOnOff.Checked;
end;

procedure TForm1.CheckBoxFramedClick(Sender: TObject);
begin
  DBScroll1.Framed:= CheckBoxFramed.Checked;
end;

procedure TForm1.CheckBoxRowSelectClick(Sender: TObject);
begin
  if CheckBoxRowSelect.Checked then
    DBScroll1.Options:= DBScroll1.Options + [dsRowSelect]
  else
    DBScroll1.Options:= DBScroll1.Options - [dsRowSelect];
end;

procedure TForm1.CheckBoxScrollBarClick(Sender: TObject);
begin
  if CheckBoxScrollBar.Checked then
    DBScroll1.Options:= DBScroll1.Options + [dsScrollBarV]
  else
    DBScroll1.Options:= DBScroll1.Options - [dsScrollBarV];
end;

procedure TForm1.SpinEditLinesPerRowChange(Sender: TObject);
begin
  DBScroll1.RowAutoHeight:= SpinEditLinesPerRow.Value;
end;

procedure TForm1.CMarginVChange(Sender: TObject);
begin
  DBScroll1.CellMarginVert:= CMarginV.Value;
end;

procedure TForm1.CMarginLChange(Sender: TObject);
begin
  DBScroll1.CellMarginLeft:= CMarginL.Value;
end;

procedure TForm1.CMarginRChange(Sender: TObject);
begin
  DBScroll1.CellMarginRight:= CMarginR.Value;
end;

procedure TForm1.DoNotFocus(Sender: TObject);
begin
  DBScroll1.SetFocus;
end;

procedure TForm1.ScrollBar1Enter(Sender: TObject);
begin
  DBScroll1.SetFocus;
end;

procedure TForm1.ListBoxAreasClick(Sender: TObject);
VAR
  AColor: TColor;
begin
  with DBScroll1 do begin
    Case ListBoxAreas.ItemIndex Of
      0: AColor:= Header.Color;
      1: AColor:= Header.Font.Color;
      2: AColor:= Color;
      3: AColor:= Font.Color;
      4: AColor:= ColorSel;
      5: AColor:= ColorSelText;
      6: AColor:= SelField.Color;
      7: AColor:= SelField.Font.Color;
    End;

    if AColor=clBlack then ListBoxColors.ItemIndex:= 0;
    if AColor=clMaroon then ListBoxColors.ItemIndex:= 1;
    if AColor=clGreen then ListBoxColors.ItemIndex:= 2;
    if AColor=clOlive then ListBoxColors.ItemIndex:= 3;
    if AColor=clNavy then ListBoxColors.ItemIndex:= 4;
    if AColor=clPurple then ListBoxColors.ItemIndex:= 5;
    if AColor=clTeal then ListBoxColors.ItemIndex:= 6;
    if AColor=clGray then ListBoxColors.ItemIndex:= 7;
    if AColor=clSilver then ListBoxColors.ItemIndex:= 8;
    if AColor=clRed then ListBoxColors.ItemIndex:= 9;
    if AColor=clLime then ListBoxColors.ItemIndex:= 10;
    if AColor=clYellow then ListBoxColors.ItemIndex:= 11;
    if AColor=clBlue then ListBoxColors.ItemIndex:= 12;
    if AColor=clFuchsia then ListBoxColors.ItemIndex:= 13;
    if AColor=clAqua then ListBoxColors.ItemIndex:= 14;
    if AColor=clWhite then ListBoxColors.ItemIndex:= 15;
    if AColor=clHighlight then ListBoxColors.ItemIndex:= 16;
  end;
  ButtonColor.Enabled:= ListBoxAreas.ItemIndex >= 0;
end;

procedure TForm1.ListBoxColorsClick(Sender: TObject);
VAR
  AreaColor: TColor;
begin
  if ListBoxAreas.ItemIndex < 0 then begin
    ListBoxColors.ItemIndex:= -1;
    exit;
  end;
  Case ListBoxColors.ItemIndex Of
    0: AreaColor:= clBlack;
    1: AreaColor:= clMaroon;
    2: AreaColor:= clGreen;
    3: AreaColor:= clOlive;
    4: AreaColor:= clNavy;
    5: AreaColor:= clPurple;
    6: AreaColor:= clTeal;
    7: AreaColor:= clGray;
    8: AreaColor:= clSilver;
    9: AreaColor:= clRed;
   10: AreaColor:= clLime;
   11: AreaColor:= clYellow;
   12: AreaColor:= clBlue;
   13: AreaColor:= clFuchsia;
   14: AreaColor:= clAqua;
   15: AreaColor:= clWhite;
   16: AreaColor:= clHighlight;
  End;
  Case ListBoxAreas.ItemIndex Of
    0: DBScroll1.Header.Color:= AreaColor;
    1: DBScroll1.Header.Font.Color:= AreaColor;
    2: DBScroll1.Color:= AreaColor;
    3: DBScroll1.Font.Color:= AreaColor;
    4: DBScroll1.ColorSel:= AreaColor;
    5: DBScroll1.ColorSelText:= AreaColor;
    6: DBScroll1.SelField.Color:= AreaColor;
    7: DBScroll1.SelField.Font.Color:= AreaColor;
  End;
end;

procedure TForm1.CheckBoxShowHeaderClick(Sender: TObject);
begin
  DBScroll1.Header.Show:= CheckBoxShowHeader.Checked;
end;

procedure TForm1.CheckBoxShowSelFieldClick(Sender: TObject);
begin
  DBScroll1.SelField.Show:= CheckBoxShowSelField.Checked;
end;

procedure TForm1.CheckBoxRowAutoHeightClick(Sender: TObject);
begin
  SpinEditLinesPerRow.Visible:= CheckBoxRowAutoHeight.Checked;
  LabelLines.Visible:= CheckBoxRowAutoHeight.Checked;
  if CheckBoxRowAutoHeight.Checked then
    DBScroll1.RowAutoHeight:= SpinEditLinesPerRow.Value
  else
    DBScroll1.RowAutoHeight:= 0;
end;

procedure TForm1.ButtonColorClick(Sender: TObject);
VAR
  AColDlg: TColorDialog;
begin
  AColDlg:= TColorDialog.Create(Self);
  try
    if AColDlg.Execute then begin
      Case ListBoxAreas.ItemIndex Of
        0: DBScroll1.Header.Color:= AColDlg.Color;
        1: DBScroll1.Header.Font.Color:= AColDlg.Color;
        2: DBScroll1.Color:= AColDlg.Color;
        3: DBScroll1.Font.Color:= AColDlg.Color;
        4: DBScroll1.ColorSel:= AColDlg.Color;
        5: DBScroll1.ColorSelText:= AColDlg.Color;
        6: DBScroll1.SelField.Color:= AColDlg.Color;
        7: DBScroll1.SelField.Font.Color:= AColDlg.Color;
      End;
      ListBoxColors.ItemIndex:= -1;
    end;
  finally
    AColDlg.Free;
  end;
end;

procedure TForm1.CheckBoxResizeColClick(Sender: TObject);
begin
  if CheckBoxResizeCol.Checked then
    DBScroll1.Options:= DBScroll1.Options + [dsColResize]
  else
    DBScroll1.Options:= DBScroll1.Options - [dsColResize];
end;

procedure TForm1.CheckBoxResizeRowClick(Sender: TObject);
begin
  if CheckBoxResizeRow.Checked then
    DBScroll1.Options:= DBScroll1.Options + [dsRowResize]
  else
    DBScroll1.Options:= DBScroll1.Options - [dsRowResize];
end;

procedure TForm1.CheckBoxCustomizedClick(Sender: TObject);
begin
  if CheckBoxCustomized.Checked then
    DBScroll1.OnCellSetTextAndColor:= DBScroll1CellSetTextAndColor
  else
    DBScroll1.OnCellSetTextAndColor:= nil;
  DBScroll1.InvalidateSmooth;
end;

procedure TForm1.BitBtnReadMeClick(Sender: TObject);
VAR
  TempBuf: Array[0..500] of Char;
begin
  StrPCopy(TempBuf, 'write.exe '+
           ExtractFilePath(Application.ExeName)+'readme.wri');
  WinExec(TempBuf, SW_SHOW);
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  if FirstSearch then begin
    DBScroll1.Show('1003');
    FirstSearch:= False;
  end else
    DBScroll1.Show('');
end;

procedure TForm1.SpeedButtonBackClick(Sender: TObject);
begin
  GoFor:= False;
  GoBack:= True;
  while (not DataSource1.DataSet.BOF) and GoBack do begin
    DataSource1.DataSet.Prior;
    Application.ProcessMessages;
  end;
end;

procedure TForm1.SpeedButtonGoClick(Sender: TObject);
begin
  GoBack:= False;
  GoFor:= True;
  while (not DataSource1.DataSet.EOF) and GoFor do begin
    DataSource1.DataSet.Next;
    Application.ProcessMessages;
  end;
end;

procedure TForm1.SpeedButtonStopClick(Sender: TObject);
begin
  GoBack:= False;
  GoFor:= False;
end;

procedure TForm1.TabbedNotebook1Change(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
  {Tab 4  ->  Drag & Drop-Page}
  if NewTab = 4 then DBScroll1.DragMode:= dmAutomatic;
end;

procedure TForm1.MemoFieldDragDrop(Sender, Source: TObject; X, Y: Integer);
VAR
  S: String;
begin
  if (Source is TDBScroll) and (Sender is TMemo) then begin
    S:= StrPas((Source as TDBscroll).SelField.Text);
    (Sender as TMemo).Lines.Add(S);
  end;
end;

procedure TForm1.MemoFieldDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Accept:= Source is TDBScroll;
end;

procedure TForm1.DBScroll1CellSetTextAndColor(Sender: TObject;
  ColIndex: Word; TextIn, TextOut: PChar; var TxtColor,
  TxtColorSel: TColor);
var
  S: String;
begin
  if (Sender as TDBScroll).Fields[3].AsFloat < 400 then begin
    if ColIndex = 1 then
      StrFmt(TextOut, '!! %s !!', [TextIn]);
    TxtColor:= clRed;
    TxtColorSel:= clMaroon;
  end;
end;

procedure TForm1.CheckBoxSortClick(Sender: TObject);
begin
  if CheckBoxSort.Checked then
    with DBScroll1.Header do begin
      CurrIndexFont.Style:= CurrIndexFont.Style + [fsBold];
      SortOnLClick:= True;
      SortOnRClick:= True;
      IndexUnderline:= True;
      MessageDlg('Click at the Header of the Grid'#10+
                 '(in the underlined columns)'#10'and note '+
                 'the changed sort orders.', mtInformation, [mbOK], 0);
    end
  else with DBScroll1.Header do begin
    CurrIndexFont.Style:= CurrIndexFont.Style - [fsBold];
    SortOnLClick:= False;
    SortOnRClick:= False;
    IndexUnderline:= False;
  end;
end;

end.
