VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Database Table Structure Printer"
   ClientHeight    =   2670
   ClientLeft      =   1875
   ClientTop       =   2640
   ClientWidth     =   4125
   Height          =   3360
   Left            =   1815
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2670
   ScaleWidth      =   4125
   Top             =   2010
   Width           =   4245
   Begin ListBox lst_Tables 
      Height          =   1980
      Left            =   120
      TabIndex        =   0
      Top             =   252
      Width           =   3855
   End
   Begin CommonDialog CMDialog1 
      DefaultExt      =   "mdb"
      DialogTitle     =   "Open Database"
      Filter          =   "Access Database|*.mdb"
      Left            =   -360
      Top             =   0
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Print Which Table?"
      Height          =   195
      Left            =   120
      TabIndex        =   1
      Top             =   30
      Width           =   1650
   End
   Begin Menu mnu_File 
      Caption         =   "&File"
      Begin Menu mnu_OpenDB 
         Caption         =   "&Open"
      End
      Begin Menu mnu_Print 
         Caption         =   "&Print"
         Enabled         =   0   'False
      End
      Begin Menu mnu_Line 
         Caption         =   "-"
      End
      Begin Menu mnu_Exit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnu_Help 
      Caption         =   "&Help"
      Begin Menu mnu_About 
         Caption         =   "&About"
      End
   End
End
'Copyright 1993 by Charles Gallo. All Rights Reserved
Dim db As DataBase
Dim td As TableDefs

Sub ChooseDatabase ()
'Copyright 1993 by Charles Gallo. All Rights Reserved
'************************************************************
' Maintenance Header
' Version   Date        Coder                   Action
'   1       07/13/93    C. Gallo(74020,3224)    Initial keyin

' Calls:Nothing

' Is Called By:Form_Load, mnu_OpenDB

' Purpose:To Choose and open a database and add it's tables to
' the listbox


'************************************************************
    'Call the Common Dialog Routine to get the database name
    On Error Resume Next                'This is here if there is no DB Open
    db.Close
    On Error GoTo 0
    lst_Tables.Clear                    'clear the listbox
    mnu_Print.Enabled = False
Retrydatabase:
    On Error GoTo DatabaseError
    CmDialog1.CancelError = True
    CmDialog1.Flags = OFN_FILEMUSTEXIST + OFN_HIDEREADONLY
    CmDialog1.Action = 1
    'Open the database
    Set db = OpenDatabase(CmDialog1.Filetitle)
    On Error GoTo 0

    Dim snap As Snapshot
    'Take a snapshot of the tables (And Queries in the database)
    Set snap = db.ListTables()
    lst_Tables.AddItem "--TABLES--"
    'loop thru the tables in the database
    'first add all the NON query objects
    While Not snap.EOF
        If (snap!Attributes And DB_SYSTEMOBJECT) = 0 Then
            If (snap!TableType = DB_TABLE) Then
                lst_Tables.AddItem snap!Name
                mnu_Print.Enabled = True                        'there is something in the listbox so enable print
            End If
        End If
        snap.MoveNext
    Wend
    'yes I KNOW this is slower, but it gives better output
    snap.MoveFirst
    lst_Tables.AddItem "--QUERIES--"
    While Not snap.EOF
        If (snap!Attributes And DB_SYSTEMOBJECT) = 0 Then
            If (snap!TableType = DB_QUERYDEF) And (snap!Attributes And 5) = 0 Then
                lst_Tables.AddItem snap!Name
                mnu_Print.Enabled = True                        'there is something in the listbox so enable print
            End If
        End If
        snap.MoveNext
    Wend
    
    
    snap.Close
Exit Sub
DatabaseError:
    If Err = 32755 Then             'The user pressed cancel in the cmdialog box
        Exit Sub
    End If
    MsgBox "This is Not a Valid Access Database, or the Database is Corrupt!", MB_ICONEXCLAMATION, "Cagney Systems Inc."
    Resume Retrydatabase

End Sub

Sub Form_Load ()
    'Copyright 1993 by Charles Gallo. All Rights Reserved
    Call Formcenter(Me)
    Me.Show
    x% = DoEvents()
    Call ChooseDatabase
End Sub

Sub Formcenter (dummy As Form)
    Move (screen.Width - dummy.Width) \ 2, (screen.Height - dummy.Height) \ 2
End Sub

Sub lst_Tables_DblClick ()
    'Copyright 1993 by Charles Gallo. All Rights Reserved
    mnu_Print_Click
End Sub

Sub mnu_About_Click ()
    'Copyright 1993 by Charles Gallo. All Rights Reserved
    Temp$ = "Access Database Table Structure Printer" + Chr$(13) + Chr$(10)
    Temp$ = Temp$ + "Copyright by 1993 Charles Gallo. All Rights Reserved" + Chr$(13) + Chr$(10)
    Temp$ = Temp$ + "Charles Gallo (CIS ID 74020,3224)" + Chr$(13) + Chr$(10)
    Temp$ = Temp$ + "This program may be distributed without charge" + Chr$(13) + Chr$(10)
    Temp$ = Temp$ + "As long as the source code, and this statement" + Chr$(13) + Chr$(10)
    Temp$ = Temp$ + "are included"
    MsgBox Temp$, MB_ICONEXCLAMATION, "Cagney Systems Inc."
End Sub

Sub mnu_Exit_Click ()
    'Copyright 1993 by Charles Gallo. All Rights Reserved
    End
End Sub

Sub mnu_OpenDB_Click ()
'Copyright 1993 by Charles Gallo. All Rights Reserved
    Call ChooseDatabase
End Sub

Sub mnu_Print_Click ()
    'Copyright 1993 by Charles Gallo. All Rights Reserved
'************************************************************
' Maintenance Header
' Version   Date        Coder                   Action
'   1       07/13/93    C. Gallo(74020,3224)    Initial keyin
'   2       07/27/93    C. Gallo(74020,3224)    Added code to print Queries

' Calls:QueryPrint

' Is Called By:mnu_Print

' Purpose:To print the stucture of an Access database table or call the Query print routine


'************************************************************
    'First Make sure the user did'nt pick the tables or Queries header
    If (lst_Tables.Text = "--TABLES--") Or (lst_Tables.Text = "--QUERIES--") Then
        'Yep, the user selected one of the headers
        MsgBox "You Have selected one of the message headers, Please select one of the Tables or Queries", MB_ICONEXCLAMATION
        Exit Sub
    End If
    'get the tabledef object of the open database
    Set td = db.TableDefs
    On Error GoTo PrintError
'Put a line label here because if the user selects a query we'll get an error in the next line
QueryError:
    td(lst_Tables.Text).Fields.Refresh
    Temp$ = "Table = " + lst_Tables.Text

    'setup the printer and print the header info
    Printer.FontName = "Arial"
    Printer.FontBold = True
    Printer.Print Tab(40 - Len(Temp$) / 2); Temp$
    Printer.FontBold = False
    Printer.Print
    Printer.Print "Date = "; Format$(Now, "MM/DD/YYYY")
    Printer.Print
    Printer.Print "Field Name"; Tab(40); "Field Type"; Tab(60); "Field Size"
    Printer.Print

    For i% = 0 To td(lst_Tables.Text).Fields.Count - 1               'for all the fields in this table (The table name is form the listbox)
        Printer.Print td(lst_Tables.Text).Fields(i%).Name;           'Print the field name
        Printer.Print Tab(40);                                  'tab to the type column

        'print the field type
        Select Case td(lst_Tables.Text).Fields(i%).Type
            Case DB_BOOLEAN
                Printer.Print "Boolean";
            Case DB_BYTE
                Printer.Print "Byte";
            Case DB_INTEGER
                Printer.Print "Integer";
            Case DB_LONG
                Printer.Print "Long";
            Case DB_CURRENCY
                Printer.Print "Currency";
            Case DB_SINGLE
                Printer.Print "Single";
            Case DB_DOUBLE
                Printer.Print "Double";
            Case DB_DATE
                Printer.Print "Date";
            Case DB_Binary
                Printer.Print "Binary";
            Case DB_TEXT
                Printer.Print "Text";
            Case DB_LONGBINARY
                Printer.Print "BLOB";
            Case DB_MEMO
                Printer.Print "Memo";
            Case Else
                Printer.Print "Error";
        End Select
        Printer.Print Tab(60);                                      'tab to the field size column
        Printer.Print td(lst_Tables.Text).Fields(i%).Size           'and print the field size
    Next
    Printer.Print
    Printer.Print "Primary Key"
    'Print the primary key
    Printer.Print
    On Error Resume Next
    Printer.Print td(lst_Tables.Text).Indexes("PrimaryKey").Fields
    On Error GoTo 0
    
    
    Printer.EndDoc                              'end the printer doc
'Note: It would be VERY easy to add screen display to this app.
'Just add a second form, put a grid control on the form, and stuff the grid in the loop!
Exit Sub
PrintError:
    If Err = 3265 Then
        'we are trying to print a Query
        Temp$ = lst_Tables.Text
        Call PrintQuery(Temp$)
        Exit Sub
    End If
End Sub

Sub PrintQuery (WhichQuery$)
'******************************************************
' Maintenance Header
' Version   Date        Coder       Action
'   1       07/27/93    C. Gallo    Initial keyin

' Calls:

' Is Called By:

' Purpose:To print the SQL string of the defined query


'*******************************************************
    Dim qd As Querydef

    'setup the printer and print the header info
    Printer.FontName = "Arial"
    Printer.FontBold = True
    Printer.Print Tab(40 - Len(WhichQuery$) / 2); WhichQuery$
    Printer.FontBold = False
    Printer.Print
    Printer.Print "Date = "; Format$(Now, "MM/DD/YYYY")
    Printer.Print
    Printer.Print "Query Name = ";
    Printer.Print WhichQuery$
    Printer.Print
    Debug.Print Printer.FontSize
    Printer.FontSize = 10

    Set qd = db.OpenQueryDef(WhichQuery$)
    Temp$ = qd.SQL
    qd.Close
    For StringPointer% = 1 To Len(Temp$)
        Printer.Print Mid$(Temp$, StringPointer%, 1);
        If (Printer.CurrentX >= Printer.ScaleWidth * .7) And (Mid$(Temp$, StringPointer%, 1) = " ") Then
            'if we're more than 70% of the way accross the printer
            Printer.Print
        End If
    Next
    
    Printer.EndDoc                              'end the printer doc

End Sub

