/*
   DataBase ++ 2.02.
   
   The following example creates a database and fills it with 10 records.
   It creates 2 index tags and then displays all records on the screen
   with both tag orders.
   
   Borland compile ( c4fox.lib == your codebase lib for FoxPro files ):

      bcc -ml -DS4FOX example2 dbpp202.lib c4fox.lib emu.lib mathl.lib cl.lib
*/

#include "dbppdata.h"             // DataBase++
#include <iostream.h>

#define MAX_NAMES    10
#define FNAME        "people.dbf"

void main()
{
   int i;
   
   // Create the DBDatabase object with the file name.
   DBDatabase db( FNAME );

   // Create a DBStructure object and add fields to it.
   DBStructure dbs;
   dbs.addField( "name", 'C', 20 );
   dbs.addField( "age", 'N', 3 );

   // Create a DBIndexTag object and fill it with tag info.
   DBIndexTag idx;
   idx.addTag( "NAME", "name" );
   idx.addTag( "AGE", "age" );
      
   // Create the database and open it.
   if ( ! db.create( dbs, idx ) )
   {
      cout << "Error creating file\n";
      exit( 1 );
   }
   
   // Create some names.
   char *names[ MAX_NAMES ] = {
      "Jeff", "Wendy", "Kyle", "Nicole", "Scott",
      "Andy", "Dave", "Bruce", "Done", "Henry"
   };

   // Open index files (dBASE only).
//   db.openIndex( "name.ndx" );
//   db.openIndex( "age.ndx" );
   
   // Add some records.
   for ( i = 0; i < MAX_NAMES; i++ )
   {
      // Append a blank record.
      db.append();

      // Replace a field with a string.
      db.replace( "name", names[ i ] );

      // Replace a field with an int.
      db.replace( "age", i * 10 );
   }

   // Display all records with NAME set.
   db.setIndexTag( "NAME" );
   for ( db.goTop(); !db.eof(); db.skip() )
      cout << db.getString( "name" ) << "   " << db.getInt( "age" ) << endl;

   cout << endl;
   
   // Display all records with AGE set.
   db.setIndexTag( "AGE" );
   for ( db.goTop(); !db.eof(); db.skip() )
      cout << db.getString( "name" ) << "   " << db.getInt( "age" ) << endl;

   // Close file.
   db.close();
}

