/*
   Library: DataBase++ Ver. 2.02.
   File:    DBPPINDX.HPP
   Purpose: Declarations for class DBIndexTag. Code in dbppindx.cpp
   Notice:  Copyright (C), 1992 - 1995, Jeff Stapleton. All rights reserved.
*/

#ifndef __DBPPINDX_H
#define __DBPPINDX_H

#include "dbppobjt.h"
#include "dbpparay.h"    // DBArray class.

/* DBIndex file struct.
*/
struct DBIndex : public DBObject 
{
   char  *tagName;
   char  *expression;
   int   unique;
   int   descending;
};

/* DBIndexTag class.
*/
class DBIndexTag : public DBObject 
{
   public:

      /* Construct/destruct.
      */
      DLLAPI DBIndexTag() : indexArray( 10, 2 ) {}
      virtual DLLAPI ~DBIndexTag() {}

      /* Instance methods.
      */
      VOID      DLLAPI  addTag( char *tagName, char *expression,                 // Add a new index tag. 
                          int unique = 0, int descending = 0 );  
      int       DLLAPI  numTags() { return indexArray.itemsInArray(); }          // Return number fields in this.
      DBIndex * DLLAPI  operator [] ( int idx ) { return (DBIndex *) indexArray[ idx ]; }    // Access to an individual DBIndex struct.
      DBArray & DLLAPI  idxArray() { return indexArray; }
      
   private:
      
      DBArray indexArray;
};

#endif   // __DBPPINDX_H
