/*
   Library: DataBase++ Ver. 2.02.
   File:    DBPPARAY.HPP
   
   Purpose: Declarations for class DBArray. DBArray is an array class that
            holds pointers to DBObject types. It is much smaller than
            the Borland equivalent BI_IArrayAsVector types. This array can be
            converted easily to use templates if your compiler supports them.
   
   Notice:  Copyright (C), 1992 - 1995, Jeff Stapleton. All rights reserved.
*/   

#ifndef _DBPPARAY_H
#define _DBPPARAY_H

#include "dbppobjt.h"

class DBArray : public DBObject
{
   public:

      DLLAPI  DBArray( int sz = 1, int growBy = 1 );
      virtual DLLAPI ~DBArray();

      VOID DLLAPI       add( DBObject *anObject );
      int  DLLAPI       itemsInArray() { return numItems; }
      VOID DLLAPI       ownsObjects( unsigned bool ) { shouldDelete = bool; }
      VOID DLLAPI       remove( int index );
      VOID DLLAPI       remove( DBObject *anObject );
      DBObject*  DLLAPI operator [] ( int index );
      
   private:

      DBObject **    theArray;
      int            size;
      int            numItems;
      int            delta;
      int            shouldDelete;

      VOID           grow();
};

#endif // _DBPPARAY_H

