/**********************[ SoftC Database Library ]*************************
** Copyright (c) 1988, 1997 SoftC, Ltd.
** All Rights Reserved.
**************************************************************************
**
**      This module contains the internal structure definitions,
**      prototypes, etc. for the database library.
**/

/************************[ compilation switches ]************************/
#ifndef __DBLVL0_DOT_H__
#define __DBLVL0_DOT_H__

/*
**      dBASE
*/
#if defined(__ALL__) || defined(__DBASE3__) || defined(__DBASE__)
#define DBASE3_ENABLE
#define DBASE_ENABLE
#endif

#if defined(__ALL__) || defined(__DBASE4__) || defined(__DBASE__)
#define DBASE4_ENABLE
#define DBASE_ENABLE
#endif

#ifdef DBASE_ENABLE
#if defined(DBASE3_ENABLE) && defined(DBASE4_ENABLE)
#define DB_MGEN 1
#endif
#endif

/*
**      Clipper
*/
#if defined(__ALL__) || defined(__CLIPPER__)
#define CLIPPER_ENABLE
#endif

/*
**      Fox
*/
#if defined(__ALL__) || defined(__FOXBASE__) || defined(__FOX__)
#define FOXBASE_ENABLE
#define FOX_ENABLE
#endif

#if defined(__ALL__) || defined(__FOXPRO1__) || defined(__FOX__)
#define FOXPRO1_ENABLE
#define FOX_ENABLE
#endif

#if defined(__ALL__) || defined(__FOXPRO2__) || defined(__FOX__)
#define FOXPRO2_ENABLE
#define FOX_ENABLE
#endif

#if defined(__ALL__) || defined(__FOXPRO3__) || defined(__FOX__)
#define FOXPRO3_ENABLE
#define FOX_ENABLE
#endif

#ifdef FOX_ENABLE
#if defined(FOXBASE_ENABLE) && defined(FOXPRO1_ENABLE)
#define DB_MGEN 1
#endif
#if defined(FOXBASE_ENABLE) && defined(FOXPRO2_ENABLE)
#define DB_MGEN 1
#endif
#if defined(FOXBASE_ENABLE) && defined(FOXPRO3_ENABLE)
#define DB_MGEN 1
#endif
#if defined(FOXPRO1_ENABLE) && defined(FOXPRO2_ENABLE)
#define DB_MGEN 1
#endif
#if defined(FOXPRO1_ENABLE) && defined(FOXPRO3_ENABLE)
#define DB_MGEN 1
#endif
#if defined(FOXPRO2_ENABLE) && defined(FOXPRO3_ENABLE)
#define DB_MGEN 1
#endif
#endif

/*
** Multiple file families?
*/
#if defined(DBASE_ENABLE) && defined(CLIPPER_ENABLE)
#define DB_MULTI 2
#endif
#if defined(DBASE_ENABLE) && defined(FOX_ENABLE)
#define DB_MULTI 2
#endif
#if defined(CLIPPER_ENABLE) && defined(FOX_ENABLE)
#define DB_MULTI 2
#endif

/****************************[ header files ]****************************/
/************************[ constant definitions ]************************/
/* variable types */
#define DBCHAR SCCHAR
#define DBCHARP SCCHARP
#define DBCHARPP SCCHARPP
#define DBUCHAR SCUCHAR
#define DBUCHARP SCUCHARP
#define DBUCHARPP SCUCHARPP
#define DBSHORT SCSHORT
#define DBSHORTP SCSHORTP
#define DBSHORTPP SCSHORTPP
#define DBUSHORT SCUSHORT
#define DBUSHORTP SCUSHORTP
#define DBUSHORTPP SCUSHORTPP
#define DBINT SCINT
#define DBINTP SCINTP
#define DBINTPP SCINTPP
#define DBUINT SCUINT
#define DBUINTP SCUINTP
#define DBUINTPP SCUINTPP
#define DBLONG SCLONG
#define DBLONGP SCLONGP
#define DBLONGPP SCLONGPP
#define DBULONG SCULONG
#define DBULONGP SCULONGP
#define DBULONGPP SCULONGPP
#define DBVOID SCVOID
#define DBVOIDP SCVOIDP
#define DBVOIDPP SCVOIDPP
#define DBFLOAT SCFLOAT
#define DBFLOATP SCFLOATP
#define DBFLOATPP SCFLOATPP
#define DBDOUBLE SCDOUBLE
#define DBDOUBLEP SCDOUBLEP
#define DBDOUBLEPP SCDOUBLEPP
#define DBINTF SCINTF
#define DBVOIDF SCVOIDF
#define DBCHARPF SCCHARPF
#define DBULONGF SCULONGF
#define DBSINTF SCSINTF
#define DBSVOIDF SCSVOIDF
#define DBSLONGF SCSLONGF

/*
 *  Enable/Disable extended numeric fields.
 *  Use of extended numeric fields is NOT compatible with
 *  dBASE, Clipper, or FoxBASE.
 *    define __EXTENDED_DBF__
 */


#define MOVE_GO      0x00
#define MOVE_STEP    0x01
#define MOVE_METHOD  0x70
#define MOVE_FIRST   0x20
#define MOVE_LAST    0x30
#define MOVE_NEXT    0x40
#define MOVE_PREV    0x50

#define DBOFFTAIL   100  /* after the last key of the tree */
#define DBOFFHEAD   101  /* before the first key of the tree */

#if defined( SC_WIN32 )
#define DBFILEHANDLE HANDLE
#define DBINVALIDFILEHANDLE INVALID_HANDLE_VALUE
#elif defined( SC_ANSI )
#define DBFILEHANDLE FILE SC_FAR_POINTER
#define DBINVALIDFILEHANDLE DBNULL
#else
#define DBFILEHANDLE DBINT
#define DBINVALIDFILEHANDLE (DBINT)-1
#endif
#define DBFILEHANDLEP DBFILEHANDLE SC_FAR_POINTER

#define MAX_DATE    3652059L        /* 12-31-9999 */
#define DATE_FUDGE  1721410L        /* dBASE, etc. date fudge factor */

/* shareware library definitions */
#define __CRIPPLE_REC_LIMIT__ 500L  /* record limit for crippled lib */
#define __CRIPPLE_MAX_FILES__ 10    /* 10 files open maximum */
#ifdef __CRIPPLE__
#undef __DOS_EXT__                  /* no DOS Extentions */
#endif

/* Record & file locking constants */
#define FOXLOCK  0x40000000L
#define CLIPLOCK 1000000000L


#define _OFF_TREE_ -1

#define _MAX_FNAME_ 80

#define DBNUMPGS 10 /* number of index pages to allocate space */

/* record status flag */
#define DBUSED 0x20        /* record used flag */
#define DBNOTUSED 0x2A     /* record not used flag */

#define APPEND_OP ((DBSHORT)1)
#define OVERWR_OP ((DBSHORT)2)
#define DATA_AREA 256
#define _LPN_MAX_ _MAX_DIR
#define _LFN_MAX_ (_MAX_FNAME + _MAX_EXT)
#define XFER_SIZE (sizeof(TRollBackStruct) + sizeof(DBLONG) + _LPN_MAX_ + _LFN_MAX_ + DATA_AREA)

/****************************[ enumerations ]****************************/
enum TAG_TYPE {
   INDEX_TAG,
   BIT_VECTOR_TAG
};

/**************************[ macro defintions ]**************************/
#define setKey(a,b) (_SCmemcpy(a+DBpTag->u.bt.keyOffset, b, DBpTag->keyLength))
#define setRecNo(a,b) (*((long *)(a+DBpTag->u.bt.recordNumberOffset)) = b)
#define setChild(a,b) (*((long *)(a+DBpTag->u.bt.childPageOffset)) = b)

#define isClipper(x) ((x == DBCLIPPER87) || (x == DBCLIPPER5))

#define isDBase(x)   ((x == DBDBASE3) || (x == DBDBASE4))
#define isDBase3(x)  (x == DBDBASE3)
#define isDBase4(x)  (x == DBDBASE4)

#define isFox(x)     ((x == DBFOXBASE) || \
              (x == DBFOXPRO1) || \
              (x == DBFOXPRO2) || \
              (x == DBFOXPRO3))
#define isFoxPro2(x) ((x == DBFOXPRO2) || (x == DBFOXPRO3))

#ifdef _DEBUG
#define DBLOGERROR SCLOGERROR
#else
#define DBLOGERROR(a)
#endif
#define DBMKFP(p,seg,ofs)  {(*((DBUINT *)&(p) + 1)) = seg; \
                    (*((DBUINT *)&(p))) = ofs;}
#define _DBstrupr(a) {DBINT zz=0; \
              while((a)[zz] != 0) { \
              (a)[zz] = (DBCHAR)toupper((a)[zz]); \
              zz++;}}
#define _DBstrlwr(a) {DBINT zz=0; \
              while((a)[zz] != 0) { \
              (a)[zz] = (DBCHAR)tolower((a)[zz]); \
              zz++;}}
#ifndef max
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#endif
#ifndef min
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif

/************************[ structure defintions ]************************/
/**************************[ type definitions ]**************************/
#ifdef SC_BORLAND
#define DBFIND_STRUC struct ffblk
#define DBFIND_STRUCP struct ffblk SC_FAR_POINTER
#endif

/**********
 *
 *  DBF Type Definitions
 *
 **********/

#define DBRECHDRLEN 1      /* record header length */
#define DBDBFOFSN  4l      /* offset to number of records in header */

#define DBFLDNAMSZ 11                /* maximum length of field name */
#define DBFLDSZ sizeof(DBFIELDSTRUC) /* field description length */

typedef struct {        /* dBASE field description */
   DBCHAR   name[DBFLDNAMSZ]; /* dBASE field name */
   DBUCHAR  type;             /* dBASE field type */
   DBSHORT  fieldOffset;      /*       data address */
   DBSHORT  length;           /*       field width */
   DBUCHAR  width;            /* dBASE field width */
   DBUCHAR  decimals;         /* dBASE decimal count */
   DBUSHORT bitMask;          /*       bit mask (bit fields) */
   DBUCHAR  maxValue[8];      /*       maximum 'N'/'F' field value */
   DBCHAR   bitShift;         /*       bit shift (bit fields) */
   DBUCHAR  r3[2];            /* reserved */
   DBUCHAR  indexed;          /* dBASE field is indexed */
}  DBFIELDSTRUC;
#define DBFIELDSTRUCP DBFIELDSTRUC SC_FAR_POINTER

#define DBDATAHDRSZ sizeof(DBDATAHDR) /* number of bytes in header */

typedef struct {  /* dBASE header */
   DBUCHAR signature;       /* 00 database version
                             *    0x3 no memo file
                             *    0x83 standard memo file
                             *    0xF5 FoxPro memo file
                             *    0x8B dBASE IV memo file
                             *    0x30 FoxPro3 file */
   DBUCHAR year;            /* 01 year file was last updated */
   DBUCHAR month;           /* 02 month */
   DBUCHAR day;             /* 03 day */
   DBLONG  fileSize;        /* 04 number of records in data file */
   DBSHORT headerLength;    /* 08 data file header length */
   DBSHORT recordLength;    /* 0a length of each individual record */
   DBSHORT u1;              /* 0c reserved */
   DBUCHAR transaction;     /* 0e transaction begun flag (dBASE IV) */
   DBUCHAR encrypted;       /* 0f data encrypted flag (dBASE IV) */
   DBLONG  firstFree;       /* 10 reserved for LAN (free record thread) */
   DBUCHAR u2[8];           /* 14 reserved for LAN */
   DBUCHAR productionIndex; /* 1c production index flag */
   DBUCHAR u4;              /* 1d unknown flag (FoxPro3 sets to 3) */
   DBUCHAR u3[2];           /* 1e reserved */
}  DBDATAHDR;
#define DBDATAHDRP DBDATAHDR SC_FAR_POINTER

#define DBRECMOD 0x40     /* i/o buffer changed */
#define DBRECADD 0x20     /* records added to buffer */

typedef struct {  /* disk buffering control structure */
   DBLONG   firstRecord;     /* first record in buffer */
   DBUCHARP data;            /* disk cache */
   DBUCHARP currentRecord;   /* pointer to current record in buffer */
   DBINTP   recordOffset;    /* pointer to record offset array */
   DBINT    lengthInBytes;   /* buffer length in bytes */
   DBINT    lengthInRecords; /* buffer length in records */
   DBINT    recordsLoaded;   /* number of records in buffer */
   DBUINT   updated:1;       /* buffer status (changed) */
   DBUINT   appended:1;
   DBUINT   original:1;
}  DBRECBFR;
#define DBRECBFRP DBRECBFR SC_FAR_POINTER

typedef struct {  /* dBASE data file packet */
   DBLONG        recordNumber;     /* current record number */
   DBCHARP       filterExpression;
   DBUCHARP      filterPCode;
   DBRECBFR      buffer;           /* disk buffering control structure */
   DBFIELDSTRUCP field;            /* field description array */
   DBUINT        memoUsed:1;       /* memo file attached */
   DBUINT        fieldChanged:1;   /* field changed status flag */
   DBUINT        transaction:1;    /* transaction in progress */
   DBUINT        encrypted:1;      /* file encrypted flag */
   DBUINT        productionIndex:1;/* production index flag */
   DBSHORT       longestField;     /* length of the longest data field */
   DBSHORT       numberOfFields;   /* number of fields per record */
   DBSHORT       numberOfLocks;    /* number of locks applied */
   DBSHORT       counterField;     /* counter field number */
   DBUCHAR       year;
   DBUCHAR       month;
   DBUCHAR       day;
}  DBDATAPKT;
#define DBDATAPKTP DBDATAPKT SC_FAR_POINTER


/**********************************
 *                                *
 *  Memo File Packet Definitions  *
 *                                *
 **********************************/

typedef struct {  /* memo file packet */
   DBLONG   recordLength;   /* read remaining byte count */
   DBLONG   fileAddress;    /* file read address */
   DBLONG   recordNumber;   /* current record number */
}  DBMEMOPKT;
#define DBMEMOPKTP DBMEMOPKT SC_FAR_POINTER


/**********
 *
 *  DBT Type Definitions
 *
 **********/

#define DBDBTOFSF 0l     /* offset to first free in header */
typedef struct {  /* dBASE memo file header */
   DBLONG  firstFree;      /* next available memo record */
   DBLONG  u1;             /* unknown (0) */
   DBUCHAR filename[8];    /* data file name (no extension) */
   DBSHORT u2;             /* unknown (0) */
   DBUCHAR u3;             /* unknown (2) */
   DBUCHAR u4;             /* unknown (1) */
   DBSHORT blockSizeAdder; /* block size adder */
   DBSHORT u5;             /* structure filler */
}  DBDBTHDR;
#define DBDBTHDRP DBDBTHDR SC_FAR_POINTER

#define DBDBTHDRSZ sizeof(DBDBTHDR)

typedef struct {  /* dBASE memo record header */
   DBSHORT u1;           /* unknown (-1) */
   DBSHORT u2;           /* unknown (8) */
   DBLONG  length;       /* record length (including header) */
}  DBDBTRHDR;
#define DBDBTRHDRP DBDBTRHDR SC_FAR_POINTER

#define DBDBTOFSBL 4l    /* offset to length in block header */
typedef struct {  /* dBASE memo unused record header */
   DBLONG address;       /* next unused record number */
   DBLONG length;        /* number of records in this block */
}  DBDBTFHDR;
#define DBDBTFHDRP DBDBTFHDR SC_FAR_POINTER


/**********
 *
 *  FPT Type Definitions
 *
 **********/

#define DBFPTOFSF 0l     /* offset to first free in header */
typedef struct {  /* FoxPro memo file header */
   DBLONG firstFree;      /* next available memo record */
   DBLONG blockSizeAdder; /* block size adder (33 - 16384) */
   DBLONG flags;          /* FP3 sets to 0x800 */
}  DBFPTHDR;
#define DBFPTHDRP DBFPTHDR SC_FAR_POINTER

typedef struct {  /* FoxPro memo record header */
   DBLONG signature;      /* signature (0-picture, 1-text) */
   DBLONG length;         /* record size in bytes */
}  DBFPTRHDR;
#define DBFPTRHDRP DBFPTRHDR SC_FAR_POINTER


/**********************************
 *                                *
 *  Index Tag Packet Definitions  *
 *                                *
 **********************************/

typedef struct {  /* btree level array */
   DBLONG  pageNumber;    /* current page number */
   DBSHORT itemIndex;     /* key item array index */
   DBSHORT u1;
}  DBTREE;
#define DBTREEP DBTREE SC_FAR_POINTER

typedef struct {
   DBLONG   recordNumber; /* current record number */
   DBUCHARP value;        /* current key */
   DBSHORT  length;
}  DBKEYS;
#define DBKEYSP DBKEYS SC_FAR_POINTER

#define DBMAXTAGNAME 10
#define DBMAXKEYLEN 100

typedef struct
{
   DBUCHAR  keyType;              /* index key type */
   DBSHORT  minKeysPerPage;       /* minimum number of keys per page */
   DBSHORT  minKeysLeftPage;      /* minimum number of keys on left */
   DBSHORT  maxKeysPerPage;       /* maximum number of keys on page */
   DBSHORTP itemOffset;           /* offsets to each item on page */
   DBKEYS   currentKey;           /* current key and record number */
   DBUINT   childPageOffset:8;    /* offset to page number in key item */
   DBUINT   recordNumberOffset:8; /* offset to record number in key item */
   DBUINT   keyOffset:8;          /* offset to key value in key item */
   DBUINT   itemLength:8;         /* key item length */
   DBUINT   keyDecimals:5;        /* number of decimal digits in key */
   DBUINT   fillSpaces:1;         /* ' ' fill character */
   DBUINT   continueSearch:1;     /* continue key search flag */
}  DBBTREEPKT;
#define DBBTREEPKTP DBBTREEPKT SC_FAR_POINTER

typedef struct {  /* index tag packet */
   DBUCHAR  tagType;              /* tag packet type */
   DBCHAR   name[DBMAXTAGNAME+1]; /* tag name */
   DBLONG   rootPage;             /* tag root page */
   DBLONG   headerOffset;         /* offset to index tag header */
   DBTREEP  tree;                 /* page tree array */
   DBCHARP  keyExpression;        /* index expression */
   DBUCHARP keyPCode;             /* compiled index expression */
   DBCHARP  forExpression;        /* for expression */
   DBUCHARP forPCode;             /* compiled for expression */
   DBINT    treeHeight:8;         /* maximum height of btree */
   DBINT    treeLevel:8;          /* current btree page level */
   DBUINT   keyLength:8;          /* index key length */
   DBUINT   tagChanged:1;         /* index modified */
   DBUINT   descending:1;         /* descending order index */
   DBUINT   unique:1;             /* unique keys index */
   DBUINT   compressed:1;         /* compressed keys index */
   union {
      DBBTREEPKT bt;
   } u;
}  DBTAGPKT;
#define DBTAGPKTP DBTAGPKT SC_FAR_POINTER

/***********************************
 *                                 *
 *  Index File Packet Definitions  *
 *                                 *
 ***********************************/

typedef struct {  /* page control structure */
   DBULONG  recordMask;  /* record number mask (FoxPro2) */
   DBLONG   number;      /* page number */
   DBSHORTP itemOffset;  /* pointer to item offset array */
   DBUCHARP data;        /* pointer to page buffer */
}  DBPCTRL;
#define DBPCTRLP DBPCTRL SC_FAR_POINTER

typedef struct {  /* index page I/O buffer definition */
   DBLONG   number;     /* page number */
   DBSHORTP itemOffset; /* array containing offsets to each item on page */
   DBUCHARP data;       /* index page cache */
   DBUINT   used:1;     /* page status (used, not used, changed) */
   DBUINT   changed:1;
   DBSHORT  tag;        /* who is using buffer */
}  DBIPC;
#define DBIPCP DBIPC SC_FAR_POINTER

#define DBNUMTAGS 48
typedef struct {  /* index file packet */
   DBLONG    numberFree;            /* number of blocks available */
   DBLONG    minPageOffset;
   DBLONG    pageBoundary;
   DBTAGPKTP tagTable[DBNUMTAGS+1]; /* tag array */
   DBIPCP    page;                  /* index page control array */
   DBUINT    tagCount:6;            /* tag count */
   DBUINT    tagsOpen:6;            /* number of tags currently open */
   DBUINT    pageShift:4;           /* number of bits to shift */
   DBUINT    tagTableEntries:6;     /* number of entries in tag table */
   DBUINT    freeThreadOffset:5;    /* offset to free thread on page */
   DBUINT    recordMaskOffset:5;    /* record mask on page */
   DBUINT    tagTableLength:6;      /* length of each tag table entry */
   DBUINT    keyCountOffset:5;      /* number of keys on page */
   DBUINT    compound:1;            /* compound index */
   DBUINT    productionIndex:1;     /* structure index */
   DBUINT    minNumOfPages:3;       /* minimum number of pages required */
   DBSHORT   numberOfPages;         /* number of page buffers allocated */
   DBSHORT   pagesLoaded;           /* number of index pages loaded */
   DBSHORT   bufferSize;            /* number of elements in control array */
   DBSHORT   pageHeaderSize;        /* length of index page header */
   DBSHORT   version;               /* tag file version */
}  DBINDEXPKT;
#define DBINDEXPKTP DBINDEXPKT SC_FAR_POINTER


/**********
 *
 *  CDX/IDX Type Definitions
 *
 **********/

/*
 * FoxPro 2 index page offsets
 */

#define DBCDXKCO 2                   /* key count offset */
#define DBCDXFSO 12                  /* Free space offset */
#define DBCDXDMO 18                  /* duplicate byte count mask */
#define DBCDXTMO 19                  /* trailing byte count mask */
#define DBCDXRBO 20                  /* bits for record number */
#define DBCDXDBO 21                  /* bits for duplicate count */
#define DBCDXTBO 22                  /* bits for trailing count */
#define DBCDXBCO 23                  /* bytes per item description */
#define DBCDXIBO 24                  /* offset to first item */

#define DBCDXOFSR 0l                 /* offset to root page in header */
#define DBCDXOFSL 8l                 /* offset to file length in header */
#define DBCDXOFSF 4l                 /* offset to first free in header */
#define DBCDXOFSH2 502L              /* offset to 2nd part of FP2 header */

#define DBCDXLEFT 4                  /* offset to left page link */
#define DBCDXRIGHT 8                 /* offset to right page link */

#define DBCDXPGBD 0x1FF

typedef struct {  /* FoxBASE+/FoxPro index header */
   DBLONG  rootPage;    /* index file root page offset */
   DBLONG  firstFree;   /* head of list of unused pages
                         * -1 if none (FoxBASE)
                         * 0 if none (FoxPro) */
   DBLONG  fileSize;    /* (FB/FP1) number of pages in index file
                         * (FP2)    reserved */
   DBSHORT keyLength;   /* index key length (numeric/date keys are 8)
                         * (char <= 100, not NULL terminated) */
   DBUCHAR flags;       /* unique flag     = 0x01,
                         * for clause      = 0x08,
                         * bit vector      = 0x10 (SoftC),
                         * compact index   = 0x20 (FoxPro 2),
                         * compound index  = 0x40 (FoxPro 2),
                         * structure index = 0x80 (FoxPro 2) */
   DBUCHAR version;     /* version (reserved) */
}  DBCDXHDR;
#define DBCDXHDRP DBCDXHDR SC_FAR_POINTER

typedef struct {  /* FoxPro2 index header (part 2) */
   DBSHORT keyOrder;        /* key order - 0 ascending,
                             *             1 descending */
   DBSHORT totalPoolLength; /* total expression pool length */
   DBSHORT forPoolLength;   /* for expression pool length */
   DBSHORT u5;              /* reserved */
   DBSHORT keyPoolLength;   /* key expression pool length */
}  DBCDXHDR2;
#define DBCDXHDR2P DBCDXHDR2 SC_FAR_POINTER

#define DBCDXPGHDRSZ 12     /* each page has a twelve byte header */
#define DBFPUNIQUE 0x1      /* index tag uses unique keys */
#define DBFPDESCENDING 0x1  /* index tag uses descending key order */

/*
 *  Index page structure (FoxBASE+/FoxPro 1)
 *
 *  DBSHORT tree_level;   0 - branch, 1 - root, 2 - leaf
 *  DBSHORT num_keys;     the number of keys on this page
 *  DBLONG prev_page;     horizontal link to the left
 *  DBLONG next_page;     horizontal link to the right
 *  struct key_items[];   duplicated to fill 512 byte page
 *
 *  Index key item structure
 *
 *  DBCHAR key[];         actual key - length determined by 'k' in header
 *  DBLONG number;        record number (tree_level = 2)
 *                        branch page number (tree_level = 0,1)
 *
 *
 *
 *  Index page structure (FoxPro 2 interior node)
 *
 *  DBSHORT tree_level;   0 - branch, 1 - root
 *  DBSHORT num_keys;     the number of keys on this page
 *  DBLONG prev_page;     horizontal link to the left
 *  DBLONG next_page;     horizontal link to the right
 *  struct key_items[];   duplicated to fill 512 byte page
 *
 *  Index key item structure
 *
 *  DBCHAR key[];         actual key - length determined by 'k' in header
 *  DBLONG number;        record number
 *  DBLONG page;          branch page number
 *
 *
 *
 *  Index page structure (FoxPro 2 exterior node)
 *
 *  DBSHORT tree_level;   2 - leaf
 *  DBSHORT num_keys;     the number of keys on this page
 *  DBLONG prev_page;     horizontal link to the left
 *  DBLONG next_page;     horizontal link to the right
 *  DBSHORT free_space;   free space in page
 *  DBLONG record_mask;   record number mask
 *  DBCHAR dupe_mask;     duplicate byte count mask
 *  DBCHAR trail_mask;    trailing byte count mask
 *  DBCHAR bits_record;   number of bits used for record number
 *  DBCHAR bits_dupe;     number of bits used for duplicate count
 *  DBCHAR bits_trail;    number of bits used for trail count
 *  DBCHAR byte_count;    number of bytes holding record number,
 *                        duplicate count and trailing count
 *  DBCHAR buffer[488];   index keys and information
 *
 *  The buffer is divided into two sections. The first part contains the
 *  record number, duplicate count, and trailing count (compressed) with
 *  the information stored in LSB format (trailing count is most significant
 *  bits). The key text is stored in the second part working backwards from
 *  the end of the buffer, allowing for previous key entries. The key text
 *  is stored as "changes" from the previous key (first key stored in
 *  entirety, except for trailing characters. Trailing 0's and spaces are
 *  not stored but counted in the trailing count field.
 */

typedef union { /* CDX record number and dup & trail counts */
   DBUCHAR c[6];
   DBLONG l;
}  DBCDXITEM;


/**********
 *
 *  MDX/NDX Type Definitions
 *
 **********/

/* DB4 header definitions */
#define DBMDXOFSTC 28l     /* offset to tag count */
#define DBMDXOFSL 32l      /* offset to file size */
#define DBMDXOFSF 36l      /* offset to first free */
#define DBMDXOFST 512l     /* offset to tag table */
#define DBMDXHDRL 4l       /* min len of header in 512 byte blocks */

/* DB4 tag header definitions */
#define DBMDXOFSFE 0x2fa   /* offset to for expression */

/* DB3 header definitions */
#define DBNDXOFSR 0l       /* offset to root page */
#define DBNDXOFSL 4l       /* offset to file length */


typedef struct {  /* dBASE tag file header */
   DBUCHAR version;         /* tag file version */
   DBUCHAR year;            /* file create year */
   DBUCHAR month;           /*             month */
   DBUCHAR day;             /*             day */
   DBUCHAR filename[16];    /* data file name (no extension) */
   DBSHORT blockSize;       /* block size */
   DBSHORT blockSizeAdder;  /* block size adder */
   DBUCHAR productionIndex; /* production index flag (1) */
   DBUCHAR tagTableEntries; /* number of entries in tag table (48) */
   DBUCHAR tagTableLength;  /* length of each tag table entry (32) */
   DBUCHAR u3;              /* unknown (0) */
   DBSHORT tagCount;        /* number of tags in use */
   DBSHORT u4;              /* unknown (0) */
   DBLONG  fileSize;        /* number of pages in tag file */
   DBLONG  firstFree;       /* unused page thread (first unused block) */
   DBLONG  numberFree;      /* number of blocks available */
   DBUCHAR modYear;         /* file modify year */
   DBUCHAR modMonth;        /*             month */
   DBUCHAR modDay;          /*             day */
   DBUCHAR u5;              /* structure filler */
}  DBMDXHDR;
#define DBMDXHDRP DBMDXHDR SC_FAR_POINTER

typedef struct {  /* dBASE 4 short file header */
   DBSHORT tagCount;       /* number of tags in use */
   DBSHORT u4;             /* unknown (0) */
   DBLONG  fileSize;       /* number of pages in tag file */
   DBLONG  firstFree;      /* unused page thread (first unused block) */
   DBLONG  numberFree;     /* number of blocks available */
}  DBMDXSHDR;
#define DBMDXSHDRP DBMDXSHDR SC_FAR_POINTER


typedef struct {  /* dBASE tag table structure */
   DBLONG  headerOffset;    /* tag header page number */
   DBCHAR  name[11];        /* tag name */
   DBUCHAR keyFormat;       /* key format (0x10 data field, 0 calculated) */
   DBUCHAR nextTagLess;     /* forward tag thread (less than) */
   DBUCHAR nextTagGreater;  /* forward tag thread (greater than) */
   DBUCHAR previousTag;     /* backward tag thread (previous tag) */
   DBUCHAR u3;              /* unknown (2) */
   DBUCHAR keyType;         /* key type ('C' character,
                             *           'N' numeric/float,
                             *           'D' date) */
   DBCHAR  u4[11];          /* unused */
}  DBMDXTAG;
#define DBMDXTAGP DBMDXTAG SC_FAR_POINTER

typedef struct {  /* dBASE tag header structure */
   DBLONG  rootPage;         /* tag root page */
   DBLONG  fileSize;         /* file size in pages (dB3 only) */
   DBUCHAR keyFormat;        /* key format (0x00 right, left, dtoc */
                             /* (dB4 only)  0x08 descending order */
                             /*             0x10 fields, string */
                             /*             0x40 unique keys) */
   DBUCHAR keyType;          /* key type  ('C' character string */
                             /* (dB4 only) 'D' date */
                             /*            'N' numeric) */
   DBSHORT u2;               /* unknown (0) */
   DBSHORT keyLength;        /* index key length (numeric are 12) */
                             /*                  (date keys are 8) */
                             /*              (DBUCHAR <= 100, not NULL terminated) */
   DBSHORT maxKeysPerPage;   /* maximum number of keys per page */
   DBSHORT keyType2;         /* key type 0 = 'C','N',1 = 'D' (dB4) */
                             /* key type 0 = 'C',1 = 'N','D' (dB3) */
   DBSHORT itemLength;       /* index key item length */
   DBUCHAR u3[3];            /* unknown (0) */
   DBUCHAR flags;            /* unique flag (dB3 only) */
}  DBMDXTHDR;
#define DBMDXTHDRP DBMDXTHDR SC_FAR_POINTER

typedef struct {
   DBMDXTHDR hdr;
   DBUCHAR keyExpression[224];
}  DBMDXTHDR2;
#define DBMDXTHDR2P DBMDXTHDR2 SC_FAR_POINTER
#define DBD4UNIQUE     0x40 /* index tag uses unique keys */
#define DBD3UNIQUE     0x1  /* index uses unique keys */
#define DBD4DESCENDING 0x8  /* index tag uses descending key order */

/***********************
 *
 *  dBASE IV
 *
 ***********************/

#define DBMDXPGHDRSZ 8     /* each page has an eight byte header */

/*
 *  typedef struct {  index key item structure
 *    DBLONG p;       record number or child page
 *    union k {     index key
 *      DBDOUBLE d;     date type
 *      DBCHAR s[];     character type
 *      DBCHAR n[12];   numeric keys (BCD floating point)
 *    }
 *  } keyitem;
 *
 *  struct {        index page structure
 *    DBLONG kc;        actual number of keys on page.
 *    DBLONG u;         unknown (0)
 *    keyitem k[mxk]  index key array.
 *    DBLONG tp;        child page number (0 = leaf page)
 *                      if key is greater than last key on page.
 *  }
 */


/***********************
 *
 *  dBASE III+
 *
 ***********************/

#define DBNDXPGHDRSZ 4     /* each page has a four byte header */

/*
 *  typedef struct {  index key item structure
 *    DBLONG lp;      child page number if key is less than this key
 *    DBLONG d;       data record number
 *    union k {     index key
 *      DBCHAR s;       character type
 *      DBDOUBLE d;     numeric/date type
 *    }
 *  } keyitem;
 *
 *  struct {          index page structure
 *    DBLONG kc;        actual number of keys on page.
 *    keyitem k[maxkeyspg]  index key array.
 *    DBLONG lp;        child page number (0 = leaf page)
 *                      if key is greater than last key on page.
 *  }
 */


/**********
 *
 *  NTX Type Definitions
 *
 **********/

#define DBNTXHDRSZ sizeof(DBNTXHDR)  /* number of bytes in header */
#define DBNTXOFSP 0   /* offset to branch page in key item */
#define DBNTXOFSD 4   /* offset to data record number in key item */
#define DBNTXOFSK 8   /* offset to key in key item */
#define DBNTXOFSV 2l  /* offset to version in header */
#define DBNTXOFSF 8l  /* offset to first free in header */
#define DBNTXOFSE 22l /* offset to key expression */
#define DBNTXPGSZ 1024 /* index page size */
#define DBNTXPGSZL 1024l /* index page size (long) */
#define DBNTXPGBD 0x3FFl /* index page boundary */
#define DBNTXMNPGS 3  /* minimum number of index pages */

typedef struct {  /* Clipper index file header */
   DBUSHORT sign;              /* 06 indicating dBase/Clipper file */
                               /* 07 supports descending key order */
   DBUSHORT version;           /* 01 Clipper version number */
   DBLONG   rootPage;          /* index file root page offset */
   DBLONG   firstFree;         /* head of list of unused pages */
   DBUSHORT itemLength;        /* index key item length */
   DBUSHORT keyLength;         /* index key length */
   DBUSHORT keyDecimals;       /* number of decimal places in key */
   DBUSHORT maxKeysPerPage;    /* maximum number of keys per page */
   DBUSHORT minKeysPerPage;    /* half page size */
   DBUCHAR  keyExpression[256];/* key expression string */
   DBSHORT  unique;            /* 1 = unique keys only */
   DBSHORT  descending;        /* 1 = descending key order */
   DBSHORT  keyType;           /* 0 = Clipper compatible keys only */
}  DBNTXHDR;
#define DBNTXHDRP DBNTXHDR SC_FAR_POINTER

#define DBCLUNIQUE     0x1 /* index uses unique keys */
#define DBCLDESCENDING 0x1 /* index uses descending key order */

typedef struct {  /* Clipper index short header */
   DBUSHORT version;         /* 01 Clipper version number */
   DBLONG   rootPage;        /* index file root page offset */
   DBLONG   firstFree;       /* head of list of unused pages */
}  DBNTXSHDR;
#define DBNTXSHDRP DBNTXSHDR SC_FAR_POINTER


/**********
 *
 *  Evaluator Type Definitions
 *
 **********/

typedef struct {
   DBUCHARP expressionValue;    /* expression value */
   DBSHORT  expressionType;     /*            type */
   DBSHORT  expressionLength;   /*            length */
}  DBEVALPROC;
#define DBEVALPROCP DBEVALPROC SC_FAR_POINTER


/**********
 *
 *  Main File Packet Structure
 *
 **********/

typedef struct
{
   SCFILE       file;
   DBUINT       packetType:3;          /* packet type */
   DBUSHORT     signature;             /* file type signature */
   DBUCHAR      style;                 /* xBase family & member */
   union {
      DBDATAPKT data;
      DBMEMOPKT memo;
      DBINDEXPKT index;
   } u;
} DBPACKET;
#define DBPACKETP DBPACKET SC_FAR_POINTER
#define DBPACKETPP DBPACKET SC_FAR_POINTER SC_FAR_POINTER

typedef struct {  /* lock structure */
   DBULONG address;    /* lock begin address */
   DBULONG length;     /* lock region length */
#ifdef SC_WIN32
   HANDLE   fileHandle; /* file handle */
#else
   DBINT    fileHandle; /* file handle */
#endif
}  DBLOCK;
#define DBLOCKP DBLOCK SC_FAR_POINTER

typedef struct {
   DBLONG lOffset;
   DBULONG ulDataBytes;
   DBINT writeFlush:1;
   DBINT readOnly:1;
   DBINT flush:1;
   DBINT shared:1;
   DBINT autoLocks:1;
   DBINT multiLocks:1;
   DBINT nOperation:2;
   DBINT wNameLen;
} TRollBackStruct;

/*************************[ class definitions ]**************************/
/************************[ variable definitions ]************************/
/************************[ external declarations ]***********************/
#if defined( __cplusplus)
extern "C" {
#endif

extern DBPCTRL     DBpageBuffer[4];
extern DBUCHAR     DBkeybfr1[DBMAXKEYLEN+5];    /* key buffer 1 */
extern DBUCHAR     DBkeybfr2[DBMAXKEYLEN+5];    /* key buffer 2 */
extern DBUCHAR     DBkeybfr3[DBMAXKEYLEN+5];    /* key buffer 3 */
extern DBLONG      DBrecnum;          /* record number buffer */
extern DBSHORT     DBtag;             /* index tag handle */

extern DBPACKETP   DBpData;
extern DBPACKETP   DBpIndex;
extern DBPACKETP   DBpMemo;
extern DBPACKETP   DBpLog;
extern DBTAGPKTP   DBpTag;

extern DBUCHARP    DBKeyItem;         /* record # & dup/trail fields */
extern DBUCHARP    DBKeyText;         /* key text pointer */
extern DBSHORT     DBDupeLen;         /* leading byte duplicate count */
extern DBSHORT     DBTrailLen;        /* trailing byte duplicate count */
extern DBSHORT     DBUniqueLen;       /* unique portion byte count */
extern DBCDXITEM   DBItem;

/* global variables for expression evaluator */
extern DBINT       DBevalDBF;         /* data file handle */
extern DBEVALPROC  DBevalAccumulator; /* key accumulator packet for eval */

#if defined( __cplusplus )
}
#endif

/*************************[ function prototypes ]************************/
#ifdef ANSI_PROTOTYPES
#if defined( __cplusplus )
extern "C" {
#endif
/*  Miscellaneous Functions */
DBINT _DBEvaluateStr( CONST DBINT, CONST DBCHARP, DBUCHARPP );
DBINT _DBLockTransStruc( CONST DBINT );
DBINT _DBAllocNewFilePacket( SCINTP, CONST SCINT, SCVOIDPP );

/*  Data file functions */
DBINT _DBCloseFile( DBVOID );
DBINT _DBGetRecordCacheSize( DBINTP );
DBINT _DBSetRecordCacheSize( CONST DBINT );
DBINT _DBFreeCache( DBPACKETP);
DBINT _DBGetFieldData( DBUCHARP, CONST DBUCHARP, CONST DBSHORT, CONST DBUCHAR );
DBINT _DBFlushFile( DBPACKETP );
DBINT _DBPutFieldData( CONST DBUCHARP, DBUCHARP, CONST DBSHORT, CONST DBUCHAR );
DBINT _DBVerifyField( CONST DBINT, CONST DBSHORT );
DBINT _DBAllocCache( DBPACKETP );
DBINT _DBGetFileHeader( DBVOID );
DBINT _DBLockHeader( DBVOID );
DBINT _DBUnLockHeader( DBVOID );
DBINT _DBLockFile( DBVOID );
DBINT _DBAppendRecord( DBPACKETP, DBLONGP );
DBINT _DBFillCache( DBPACKETP, CONST DBLONG );
DBINT _DBGetRecord( DBPACKETP, DBUCHARP, CONST DBLONG );
DBINT _DBLockRecord( CONST DBLONG );
DBINT _DBIsRecordLocked( CONST DBLONG );
DBINT _DBUnLockRecord( CONST DBLONG );
DBINT _DBUpdateRecord( DBVOID );
DBINT _DBLockDataStruc( CONST DBINT );
DBINT _DBUnLockAll( DBVOID );
DBINT _DBSetLockAddressLength( DBVOID );

/*  Memo file functions */
DBINT _DBCloseMemo( CONST DBINT );
DBINT _DBGetMemoHeader( DBVOID );
DBINT _DBGetMemoType( CONST DBLONG, DBLONGP, DBINTP );
DBINT _DBLockMemo( DBVOID );
DBINT _DBLockMemoStruc( CONST DBINT );
DBINT _DBUnLockMemo( DBVOID );
DBINT _DBReadMemo( CONST DBINT, CONST DBLONG, CONST DBLONG, CONST DBINT, DBCHARPP );

/*  Index file functions */
DBINT _DBCloseIndex( CONST DBINT, CONST DBINT);
DBINT _DBStepNext( DBVOIDP, DBLONGP );
DBINT __DBStepNext( DBVOID );
DBINT _DBStepPrevious( DBVOIDP, DBLONGP );
DBINT _DBGoTreeTop( DBVOIDP, DBLONGP );
DBINT _DBGoTreeBottom( DBVOIDP, DBLONGP );
DBINT __DBGoTreeBottom( DBVOID );
DBINT _DBGetCurrentKey( DBVOIDP, DBLONGP );
DBINT _DBKeySearch( DBVOIDP, DBLONGP, CONST DBINT );
DBINT _DBLockIndex( DBVOID );
DBVOID _DBClearPageBuffer( DBVOID );
DBINT _DBReadPage( CONST DBLONG );
DBINT _DBLockPage( CONST DBSHORT );
DBINT _DBWritePage( CONST DBLONG );
DBINT _DBLockTagPkt( CONST DBLONG );
DBINT _DBLockIndexPkt( CONST DBINT );
DBINT _DBFlushIndex( DBVOID );
DBINT _DBGetIndexHeader( DBVOID );
DBINT _DBUnLockIndex( DBVOID );
DBINT _DBMarkPage( CONST DBLONG );
DBVOID _DBGetDupTrail( CONST DBUCHARP, CONST DBUCHARP );
DBINT _DBGetKeyFromPage( DBVOIDP, DBLONGP );
DBVOID _DBGetCurKeyFromPage( DBVOIDP, DBLONGP );
DBVOID _DBBuildDupTrail( CONST DBUCHARP, CONST DBLONG );
DBINT _DBCompareKeys( CONST DBUCHARP, CONST DBUCHARP, CONST DBSHORT, CONST DBSHORT );
DBINT _DBDateToKey( DBUCHARP, CONST DBUCHARP, CONST DBINT );
DBINT _DBNumericToKey( DBUCHARP, CONST DBDOUBLE, CONST DBINT );
DBINT _DBDoubleToKey( DBUCHARP, CONST DBDOUBLE );
DBINT _DBFloatToKey( DBUCHARP, CONST DBFLOAT );
DBINT _DBLogicalToKey( DBUCHARP, CONST DBINT );
DBINT _DBLongToKey( DBUCHARP, CONST DBLONG );
DBINT _DBUnsignedLongToKey( DBUCHARP, CONST DBULONG );
DBINT _DBShortToKey( DBUCHARP, CONST DBSHORT );
DBINT _DBUnsignedShortToKey( DBUCHARP, CONST DBUSHORT );
DBINT _DBKeyToDate( DBUCHARP, CONST DBINT, CONST DBUCHARP );
DBINT _DBKeyToNumeric( DBDOUBLEP, CONST DBUCHARP, CONST DBINT );
DBINT _DBKeyToDouble( DBDOUBLEP, CONST DBUCHARP );
DBINT _DBKeyToFloat( DBFLOATP, CONST DBUCHARP );
DBINT _DBKeyToLogical( DBINTP, CONST DBUCHARP );
DBINT _DBKeyToLong( DBLONGP, CONST DBUCHARP );
DBINT _DBKeyToUnsignedLong( DBULONGP, CONST DBUCHARP );
DBINT _DBKeyToShort( DBSHORTP, CONST DBUCHARP );
DBINT _DBKeyToUnsignedShort( DBUSHORTP, CONST DBUCHARP );
DBINT _DBInsertKey( CONST DBLONG, CONST DBVOIDP, CONST DBLONG, CONST DBINT );
DBINT _DBKeyStep( CONST DBLONG, DBVOIDP, DBLONGP, CONST DBINT );
DBINT _DBCloseTag( CONST DBLONG, CONST DBINT );
DBINT _DBUpTree( DBVOID );
DBINT _DBFilterIndex( CONST DBINT );

/*  Transaction Log file functions */
DBINT _DBCloseLog( CONST DBINT );
DBINT _DBOpenLog( DBINTP, CONST DBCHARP, CONST DBINT );
DBINT _DBLockLogStruc( CONST DBINT );
DBINT _DBRollBack( CONST DBCHARP );
DBINT writeTransRecord( SCFILEP, CONST DBSHORT, CONST DBULONG, CONST DBLONG );

#if defined( __cplusplus )
}
#endif
#endif

#endif
