/*
** EXAMP180.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
double dDouble, dKey;
char szKey[8];

DBFIELD aField[] = { { "SIZE", DBDOUBLEFIELD, 7, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "SIZE", DBDOUBLEKEY, "SIZE", 7, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   dDouble=2000;
   DBPutFieldData( iDBF, 0, &dDouble );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBDoubleToKey( lTag, szKey, dDouble );
   DBInsertKey( lTag, szKey, lRecNo );
   dDouble=1000;
   DBPutFieldData( iDBF, 0, &dDouble );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBDoubleToKey( lTag, szKey, dDouble );
   DBInsertKey( lTag, szKey, lRecNo );
   dDouble=3000;
   DBPutFieldData( iDBF, 0, &dDouble );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBDoubleToKey( lTag, szKey, dDouble );
   DBInsertKey( lTag, szKey, lRecNo );
   dDouble=4000;
   DBPutFieldData( iDBF, 0, &dDouble );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBDoubleToKey( lTag, szKey, dDouble );
   DBInsertKey( lTag, szKey, lRecNo );
   DBGoFirstKey( lTag, szKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBKeyToDouble( lTag, &dKey, szKey );
      DBGetRecord( iDBF, lRecNo );
      DBGetFieldData( iDBF, 0, &dDouble );
      printf( "%ld %7.0f %7.0f\n", lRecNo, dKey, dDouble );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }
   DBCloseFile( iDBF );
   DBCloseIndex( iMDX );
   DBTerminate();
   exit( 0 );
}
