/*
** EXAMP113.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iFPT, iMemoType;
long lRecNo, lMemoLength;
DBMEMOINFO pMemoInfo;
char *pMemo;
DBFIELD aField[] = { { "MEMO", 'M', 10, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBFOXPRO2 );
   DBCreateMemo( "EXAMPLE.FPT", 1, DBFOXPRO2 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBFOXPRO2|DBOPENLAN );
   DBOpenMemo( &iFPT, "EXAMPLE.FPT", DBFOXPRO2|DBOPENLAN );
   DBGetMemoInfo( iFPT, &pMemoInfo );
   printf( "Readonly? %s\n", pMemoInfo.flags.isreadonly ? "YES":"NO" );
   printf( "Shareable? %s\n", pMemoInfo.flags.isshareable ? "YES":"NO" );
   puts( "Memo files cannot be buffered" );
   printf( "Memo file name is %s\n", pMemoInfo.fname );
   printf( "Locked? %s\n", pMemoInfo.lockt ? "YES":"NO" );
   printf( "Block size is %d\n", pMemoInfo.blksz );
   DBLockMemo( iFPT );
   DBPutMemoRecord( iFPT, &lRecNo, "Memo text.", 10, 10, DBAPPENDRECORD );
   DBUnLockMemo( iFPT );
   DBGetMemoType( iFPT, 1L, &lMemoLength, &iMemoType );
   if( iMemoType == DBTEXTDATA )
      printf( "Memo type is text.\n" );
   else
      printf( "Memo type is binary.\n" );
   DBPutFieldData( iDBF, 0, &lRecNo );
   DBLockHeader( iDBF );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBUnLockHeader( iDBF );
   DBGetRecord( iDBF, 1L );
   DBGetFieldData( iDBF, 0, &lRecNo );
   DBGetMemoRecord( iFPT, lRecNo, &pMemo, 10, DBCOMPLETE );
   puts( pMemo );
   DBCloseFile( iDBF );
   DBCloseMemo( iFPT );
   DBTerminate();
   exit( 0 );
}
