/*
** EXAMP105.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iCDX;
long lRecNo, lTag;
char szKey[13];

DBFIELD aField[] = { { "FILENAME", 'C', 12, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBFOXPRO2|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
//   DBCreateIndex( "EXAMPLE.CDX", 2, DBFOXPRO3|DBPRODUCTIONINDEX|DBCOMPOUNDINDEX);
   DBCreateIndex( "EXAMPLE.CDX", 2, DBFOXPRO3);
   DBOpenIndex( &iCDX, "EXAMPLE.CDX", DBFOXPRO3 );
   DBPutFieldData( iDBF, 0, "CONFIG.SYS" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBPutFieldData( iDBF, 0, "AUTOEXEC.BAT" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBPutFieldData( iDBF, 0, "WIN.COM" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBPutFieldData( iDBF, 0, "COMMAND.COM" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBBuildTag( iDBF, iCDX, "FILENAME", DBCHARACTERKEY, "FILENAME", 12, 0, NULL, NULL, 0 );
   DBOpenTag( &lTag, iCDX, 1 );
   DBSetDefaultKeyType( lTag, DBCHARACTERKEY );
   DBGoFirstKey( lTag, szKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      printf( "%ld %s\n", lRecNo, szKey );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }
   DBCloseIndex( iCDX );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
