/*
** EXAMP087.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
DBTAGINFO pTagInfo;

DBFIELD aField[] = { { "FILENAME", 'C', 12, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "FILENAME", DBCHARACTERKEY|DBDESCENDINDEX, "FILENAME", 12, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   DBGetTagInfo( lTag, &pTagInfo );
   printf( "Tag name is %s\n", pTagInfo.tname );
   printf( "Key length is %d\n", pTagInfo.keylen );
   printf( "Key type is %c\n", pTagInfo.keytype );
   printf( "Key format is %d\n", pTagInfo.keyfmt );
   printf( "Expression length is %d\n", pTagInfo.exprlen );
   printf( "Expression is %s\n", pTagInfo.expr );
   DBCloseIndex( iMDX );
   DBTerminate();
   exit( 0 );
}
