/*
** EXAMP080.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
double dNumeric;
char szKey[8];

DBFIELD aField[] = { { "SIZE", 'N', 7, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4|DBOPENBUFFERED );
   DBCreateTag( iMDX, "SIZE", DBNUMERICKEY, "SIZE", 12, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   dNumeric=2000;
   DBPutFieldData( iDBF, 0, &dNumeric );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBNumericToKey( lTag, szKey, dNumeric );
   DBInsertKey( lTag, szKey, lRecNo );
   dNumeric=1000;
   DBPutFieldData( iDBF, 0, &dNumeric );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBNumericToKey( lTag, szKey, dNumeric );
   DBInsertKey( lTag, szKey, lRecNo );
   dNumeric=3000;
   DBPutFieldData( iDBF, 0, &dNumeric );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBNumericToKey( lTag, szKey, dNumeric );
   DBInsertKey( lTag, szKey, lRecNo );
   dNumeric=4000;
   DBPutFieldData( iDBF, 0, &dNumeric );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBNumericToKey( lTag, szKey, dNumeric );
   DBInsertKey( lTag, szKey, lRecNo );
   DBGoFirstKey( lTag, szKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBKeyToNumeric( lTag, &dNumeric, szKey );
      printf( "%ld %7.0f\n", lRecNo, dNumeric );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }
   DBCloseFile( iDBF );
   DBFlushIndex( lTag );
   DBCloseIndex( iMDX );
   DBTerminate();
   exit( 0 );
}
