/*
** EXAMP040.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd..  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
char szBuffer[21];
double dValue;

DBFIELD aField[] = {
   { "branch", DBNUMERICFIELD, 3, 0 },
   { "salesman", DBCHARACTERFIELD, 20, 0 },
   { "quota", DBNUMERICFIELD, 9, 2 }
};

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "salesmen.dbf", sizeof(aField)/sizeof(DBFIELD), aField, DBCLIPPER5 );
   DBOpenFile( &iDBF, "salesmen.dbf", DBCLIPPER5 );
   dValue = 100;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Ralph Schwartz" );
   dValue = (double)150000.0;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   dValue = (double)100;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Bobby Hinze" );
   dValue = (double)125000.0l;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   dValue = (double)300;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Marsha Clark" );
   dValue = (double)200000l;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   dValue = (double)500;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Eric Nelson" );
   dValue = (double)125000l;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   dValue = (double)400;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Joe Wipper" );
   dValue = (double)150000l;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   dValue = (double)200;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Jean Larson" );
   dValue = (double)150000l;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

   DBCreateIndex( "salesmen.MDX", 2, DBDBASE4 );
   DBOpenIndex( &iMDX, "salesmen.mdx", DBDBASE4 );
   DBCreateTag( iMDX, "quota1", DBNUMERICKEY, "quota", 8, 2, "quota >= 150000" );
   DBOpenTag( &lTag, iMDX, 1 );
   lRecNo = 1l;
   do
   {
      DBGetRecord( iDBF, lRecNo );
      if (DBFilterIndex( iDBF, lTag ) == 1)
      {
             DBGetNamedStr( iDBF, "salesman", szBuffer );
             printf( "Adding salesman %s\n", szBuffer );
             DBGetNamedData( iDBF, "quota", &dValue );
             DBNumericToKey( lTag, szBuffer, dValue );
             DBAddKey( lTag, szBuffer, lRecNo );
      }
      lRecNo++;
   } while (!DBIsEndOfFile( iDBF ));
   DBCloseIndex( iMDX );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
